---
name: writing-prds
description: Help users write effective PRDs. Use when someone is documenting product requirements, preparing specs for engineering, writing feature briefs, or defining what to build for their team.
---

# Writing PRDs

Help the user write effective product requirements documents using frameworks and insights from 11 product leaders.

## How to Help

When the user asks for help with PRDs:

1. **Start with the why** - Ask about the problem being solved and why it matters now, before features
2. **Define success upfront** - Help them articulate how they'll know the feature succeeded
3. **Choose the right format** - Discuss whether they need a traditional doc, a prototype, or executable evals
4. **Keep it actionable** - Ensure the document leads to clear team action, not just documentation

## Core Principles

### Lead with problem and context
Maggie Crowley: "The most important section is the first part - what is the background and context? What is the problem, why does it matter, and why does it matter now?" Center the team on the 'why' and the urgency before discussing solutions.

### The PR/FAQ forces clarity
Bill Carr: "Whenever we're devising a new product, we start by writing a press release describing it in a way that speaks to the customer. The idea better jump off the page." Use the PR to describe customer, problem, and solution in factual, data-rich language.

### Demos before memos in AI age
Aparna Chennapragada: "If you're not prototyping and building to see what you want to build, you're doing it wrong. Prompt sets are the new PRDs." For AI features, include functional prototypes and prompt sets as core requirements.

### Evals as living PRDs
Hamel Husain & Shreya Shankar: "This is the purest sense of what a product requirements document should be - this eval judge that's telling you exactly what it should be, and it's automatic and running constantly." Translate product requirements into executable evaluations for AI products.

### Keep it lightweight for action
Eric Simons: "We tend to keep them pretty light. I like to have the minimal amount of context that ensures everyone's on the same page and that key outcomes will be present when we get there." Focus on key outcomes rather than exhaustive details that developers ignore.

### PRDs demonstrate craft
Vikrama Dhiman: "Is your PRD quality good enough? Are you writing drafts that go to care teams, marketing teams? You must have impact through the artifacts you work on." High-quality PRDs demonstrate professional craft and create clarity at scale.

### AI can scaffold the basics
Claire Vo: "I had used ChatGPT to come up with a very serviceable PRD spec for this very technical product." Use AI to scaffold basics like user stories and out-of-scope items, then focus on high-level strategy and narrative.

### Live PRDs reduce ambiguity
Guillermo Rauch: "The product management team is now actually building the product. We've specced out in v0, think of it as a live PRD. The amount of detail - we're all saying 'just ship it.'" Interactive, animated prototypes reduce ambiguity and speed up approval.

### Include the 'Why Now'
Justify the timing of this investment against other opportunities. If you can't explain why this matters now versus later, the priority is questionable.

## Questions to Help Users

- "What problem is this solving, and why does it matter now?"
- "How will you know if this feature was successful - what metric moves?"
- "Who is the customer, and what does their life look like after this ships?"
- "What is explicitly out of scope to prevent scope creep?"
- "Could you build a quick prototype instead of writing more documentation?"
- "What are the key decisions that still need to be made?"

## Common Mistakes to Flag

- **Starting with the solution** - The document should lead with the problem and context
- **No success criteria** - Every PRD needs a clear definition of how you'll measure success
- **Exhaustive detail** - Lightweight PRDs focused on outcomes are more likely to be read and used
- **Static when prototypes work better** - For AI and UI work, live prototypes communicate more than prose
- **Missing the 'Why Now'** - Without urgency justification, priorities will be questioned

## Deep Dive

For all 14 insights from 11 guests, see `references/guest-insights.md`

## Related Skills

- Writing Specs & Designs
- Working Backwards
- Stakeholder Alignment
- Shipping Products
