---
name: writing-specs-designs
description: Help users write effective specs and design documents. Use when someone is creating technical specs, feature specs, design docs, or trying to communicate product requirements to engineering and design teams.
---

# Writing Specs & Designs

Help the user write effective specs and design documents using frameworks and insights from 7 product leaders.

## How to Help

When the user asks for help with specs and design docs:

1. **Determine the fidelity level** - Ask if they need conceptual alignment (low-fi) or detailed implementation guidance (high-fi)
2. **Encourage prototyping over polish** - Push toward functional prototypes where possible rather than static documentation
3. **Focus on moving pieces** - Help them identify the key affordances, connections, and system behaviors
4. **Consider long-term implications** - Remind them that temporary shortcuts often become permanent design decisions

## Core Principles

### Low-fidelity sketches drive collaboration
Christina Wodtke: "If I got on the whiteboard and drew really badly, somebody else will go, 'No, no, no, it doesn't work that way. Give me this pen.' It gets you so fast to a shared vision." Drawing 'badly' invites participation and corrections, accelerating alignment.

### Well-shaped specs clarify without over-specifying
Ryan Singer: "The output of the shaping session is some kind of drawing or diagram where engineers, product, and design are all saying, 'I know exactly what to go build.'" Aim for a level of detail where the team sees the 'electricity in the walls' without prescribing UI details.

### Prototype to feel the product
Tamar Yehoshua: "I can't tell you if this is going to work. I have to feel it. I have to try it. A mock-up doesn't tell you what it's going to feel like." Push for prototypes with real data to test experience, not just static screenshots.

### Code prototypes over static mocks
Noah Weiss: "We stopped spending cycles on design explorations of static mocks and said, 'How quickly can we get into prototyping the path in real software, even if it's messy and throwaway?'" Move to real software prototypes as quickly as possible.

### Products live in the pixels
Nikita Bier: "You should be designing the hierarchy, the pixels, the flows, everything. Products live and die in the pixels." For zero-to-one products, own the granular design details; every tap is precious.

### Optimize every tap
Nikita Bier: "Every tap on a mobile app is a miracle. Users will turn and bounce to their next app very quickly." Design with extreme efficiency; each interaction must provide immediate value.

### Use fat marker sketches
Ryan Singer: "Use breadboarding and fat marker sketching. We're going to hit this button, go to here, this calculation runs, then we get this answer." Fat markers prevent getting bogged down in UI details like colors or spacing.

### Shortcuts become permanent
Tom Conrad: "Temporary design shortcuts often become permanent product legacies that persist through multiple technical rewrites." Be mindful that early implementation details may define long-term user expectations.

### PMs should learn to sketch
Ravi Mehta: "Learn how to sketch, learn Balsamiq. Having that ability to think at a conceptual level about how UI and UX works is a critical part of being a PM." Develop self-sufficiency in creating conceptual wireframes.

## Questions to Help Users

- "Do you need team alignment (low-fi sketch) or implementation guidance (high-fi spec)?"
- "Could you prototype this instead of documenting it?"
- "What are the 10 or fewer moving pieces in this solution?"
- "Have you tested this design with real users, not just stakeholders?"
- "What temporary shortcuts might become permanent decisions?"
- "Is every tap in this flow providing clear value to the user?"

## Common Mistakes to Flag

- **Over-specified wireframes** - High-fidelity mockups can slow collaboration; start with fat marker sketches
- **Static mocks for complex interactions** - Test the feel with real prototypes, not screenshots
- **Ignoring pixel-level details** - For consumer products, every tap and transition matters
- **Specs that no one reads** - If engineers aren't using the document, it's the wrong format or fidelity
- **Temporary decisions that persist** - Recognize that early shortcuts may last decades

## Deep Dive

For all 10 insights from 7 guests, see `references/guest-insights.md`

## Related Skills

- Writing PRDs
- Usability Testing
- Stakeholder Alignment
- Shipping Products
