# Writing Specs & Designs - All Guest Insights

*7 guests, 10 mentions*

---

## Christina Wodtke
*Christina Wodtke*

> "I just found if I got on the whiteboard and drew really badly... Somebody else will go, "No, no, no, it doesn't work that way. Give me this pen," and start doing it. And it gets you so fast to a shared vision... I know designers spend all this time making wireframes and I'm like, that's the lamest use of time ever."

**Insight:** Low-fidelity drawing on whiteboards is faster and more collaborative for aligning teams than high-fidelity wireframes.

**Tactical advice:**
- Draw 'badly' on a whiteboard to invite others to participate and correct the vision.
- Use simple shapes (squares, circles) to represent complex systems during early design discussions.

*Timestamp: 00:42:38*


## Nikita Bier
*Nikita Bier*

> "Every tap on a mobile app is a miracle for you as a product developer because users will turn and bounce to their next app very quickly... Every tap that you get, every single one is so scarce that you should be optimizing everything."

**Insight:** Mobile design requires extreme efficiency because user attention is highly fragmented and every interaction is a potential bounce point.

**Tactical advice:**
- Optimize every single tap in the user flow to ensure it provides immediate value
- Watch users interact with their phones to understand the frequency of app-switching

*Timestamp: 00:13:49*

---

> "You should be designing the hierarchy, the pixels, the flows, everything. That's on you. And products live and die in the pixels."

**Insight:** For zero-to-one products, the product lead must be deeply involved in the granular design details as they determine success.

**Tactical advice:**
- Take ownership of the information hierarchy and user flows rather than delegating them entirely to a separate design org

*Timestamp: 00:01:10*


## Noah Weiss
*Noah Weiss*

> "We stopped spending so many cycles on design explorations of static mocks or walkthroughs and said, 'How quickly can we get into prototyping the path in real software, even if it's messy and you throw it away,'... You got to live and touch and smell the software. You can't just look at it."

**Insight:** Prioritize high-fidelity prototyping in code over static design mocks to better understand how the software actually feels.

**Tactical advice:**
- Move from static mocks to real software prototypes as quickly as possible.
- Use 'messy' throwaway code to test the 'feel' of an interaction early.

*Timestamp: 01:22:38*


## Ravi Mehta
*Ravi Mehta*

> "I would suggest learn how to sketch, learn Balsamiq. Having that ability to think at a conceptual level about how UI and UX works is I think a critical part of being a product manager. And if it's a skill that you don't have today, there's great resources to be able to work on that skill."

**Insight:** PMs should be self-sufficient in creating conceptual wireframes to communicate ideas without depending entirely on designers.

**Tactical advice:**
- Use low-fidelity tools like Balsamiq to quickly iterate on product concepts.
- Focus on the conceptual layout and user flow rather than high-fidelity visual design.

*Timestamp: 00:27:51*


## Ryan Singer
*Ryan Singer*

> "The output of the shaping session is... some kind of drawing or diagram where engineers, product, and design are all looking at that and they’re saying, 'We understand that. I know exactly what to go build.'"

**Insight:** A well-shaped spec is a low-fidelity diagram that provides technical and functional clarity without over-specifying UI details.

**Tactical advice:**
- Aim for a level of detail where the team can see the 'electricity in the walls' (technical feasibility).
- Ensure the spec describes the 'moving pieces' of the solution (usually 10 or fewer).

*Timestamp: 00:39:05*

---

> "In a shaping session, you can’t collaborate on something so high fidelity. So we need also some ways to collaborate... like breadboarding and fat marker sketching. These are tools to help us express an idea very, very clearly in detail. We’re going to hit this button and from this button, go to here. This calculation runs, then we get this answer."

**Insight:** Use low-fidelity tools like breadboarding to map out logic and flows quickly during collaborative sessions.

**Tactical advice:**
- Use 'fat marker sketches' to prevent getting bogged down in UI details like colors or exact spacing.
- Focus on the 'affordances' (buttons, inputs) and the 'connections' (where they lead) to define the system.

*Timestamp: 01:00:38*


## Tom Conrad
*Tom Conrad*

> "I'm not sure what the point of this story is other than maybe it's something about, I think we all do this as designers and product people. We take these shortcuts that we think that we'll go back later and clean up. Sometimes, it's literally been 30 years that little design detail lingers three implementations later and now it's just a part of the way that these Apple products work."

**Insight:** Temporary design shortcuts often become permanent product legacies that persist through multiple technical rewrites.

**Tactical advice:**
- Be mindful that 'temporary' UI/UX decisions may last decades
- Recognize that early implementation details can define long-term user expectations

*Timestamp: 00:09:51*


## Tamar Yehoshua
*Tamar Yehoshua*

> "The thing that I learned from him the most was the power of prototyping. And that even though he was such a great product thinker, he would always say, 'I can't tell you if this is going to work. I have to feel it. I have to try it. And a mock-up doesn't tell you what it's going to feel like.'"

**Insight:** High-fidelity prototypes are essential for evaluating the 'feel' and viability of a product in a way static designs cannot.

**Tactical advice:**
- Push for prototypes that use real data to truly test the user experience.

*Timestamp: 00:30:17*

---

> "If you're doing it right, it'll be faster and you need to have an engineering infrastructure that enables prototyping... you write code that is never going to make it to production so you can just crank it out much faster and then you can see what works and then you build the production code."

**Insight:** Prototyping should be a distinct, fast phase where code is intentionally 'throwaway' to accelerate learning.

**Tactical advice:**
- Build a layer of abstraction in your tech stack that allows for rapid UI experimentation.
- Hire 'design engineers' or prototypers who focus on speed over production-grade code.

*Timestamp: 00:34:08*


