---
name: written-communication
description: Help users communicate more effectively in writing. Use when someone is drafting memos, emails, strategy docs, announcements, or any written communication that needs to be clear, concise, and persuasive.
---

# Written Communication

Help the user communicate more effectively in writing using frameworks and insights from 38 product leaders.

## How to Help

When the user asks for help with written communication:

1. **Clarify the purpose** - Ask what action or outcome they want from readers
2. **Apply the pyramid principle** - Guide them to lead with the conclusion, not build up to it
3. **Cut ruthlessly** - Help them eliminate unnecessary context and get to the point faster
4. **Test for simplicity** - Ensure someone unfamiliar with the topic could understand the core message

## Core Principles

### Focus on the how, not the what
Wes Kao: "Most writers spend too much time on the what and the why and not enough time on how. Most readers already agree with the general premise of what you're saying." Minimize context and justification; focus on specific steps, nuances, and examples.

### Writing clarifies thinking
Julie Zhuo: "I approach my writing as letters to myself. This is the framework, this is the advice I need to give myself. It was hugely helpful for clarifying my train of thought." Use writing as a tool to organize scattered thoughts and force clarity.

### Writing is clarity at scale
Kevin Yien: "Writing is clarity at scale. A key component to a PM's job is creating clarity both internally and externally." Write in the voice of the customer to demonstrate deep understanding.

### Every project needs one canonical doc
Naomi Gleit: "There needs to be one canonical doc. Everyone should know exactly where it is. It links to all other docs." Create a single source of truth for every project.

### Communication is the job
Boz: "Communication is the job. Leadership is exclusively done through the creation of artifacts or verbalizations that affect other humans." Take extreme ownership of whether your message was successfully received.

### Start right before the bear attack
Wes Kao: "Don't start talking about going to REI to buy a Patagonia jacket. Start right before your friend left a Clif Bar out and you almost got mauled by a bear." Cut preamble and start at the point of highest tension or relevance.

### Conclusion first, always
Wes Kao: "In business, start with your conclusion, then here's why. Not here's all my thinking, here's all my data points, and then my conclusion at the end." Place the recommendation at the very top.

### Write what you repeat
Deb Liu: "Write what you repeat. If you say something more than once, write it down. Then the next time someone asks, you can just hand them." Document recurring advice to scale your influence.

### Concision is density, not brevity
Wes Kao: "Being concise is not about absolute word count, it's about economy of words. You can have a 300 word memo that's meandering and a thousand word memo that is tight and concise." Focus on insight density, not just making things shorter.

### Repeat across modalities
Boz: "I will give an all-hands and then write a post with the content of the all-hands, because different people respond differently to these modalities." Use multiple channels and formats to ensure messages are absorbed.

### Use numbered lists for reference
Naomi Gleit: "I never use bulleted lists because you can never refer to a bullet. I always use numbered lists because you can say 'as referenced in number two.'" Enable precise referencing during discussions.

### Full sentences expose gaps in logic
Wes Kao: "I dislike when people overuse bullets and sentence fragments when they should use complete sentences that show the connected tissue between ideas." Turn bullet fragments into full sentences to test if the idea is fully thought out.

## Questions to Help Users

- "What do you want the reader to do after reading this?"
- "What is your conclusion - can you state it in one sentence at the top?"
- "Are your first two paragraphs actually necessary, or are they preamble?"
- "Could someone unfamiliar with this topic understand the core point?"
- "Is this something you've explained multiple times that should be documented?"
- "Have you read this out loud to check if it sounds like natural conversation?"

## Common Mistakes to Flag

- **Building up to the conclusion** - Business writing should lead with the answer, not build suspense
- **Too much context** - Cut the backstory; start at the point of relevance
- **Bullet fragments hiding weak logic** - Full sentences force clearer thinking
- **Single-channel communication** - Important messages need multiple modalities
- **Assuming one communication is enough** - Messages need repetition across formats

## Deep Dive

For all 61 insights from 38 guests, see `references/guest-insights.md`

## Related Skills

- Stakeholder Alignment
- Giving Presentations
- Running Effective Meetings
- Writing PRDs
