# Written Communication - All Guest Insights

*38 guests, 61 mentions*

---

## Alex Komoroske
*Alex Komoroske*

> "Maybe in 10 different one-on-ones with people on the team, I had to explain to them a strategic thing that we were doing... Well, you know what? That should probably be a document, right? If the same idea worked for 10 different people... now I'll write that document in 30 minutes and now I have it as a memorialized thing that other people can read on their own time without having to involve me."

**Insight:** Scale your impact by identifying recurring verbal explanations and codifying them into asynchronous documentation.

**Tactical advice:**
- Identify patterns in 1:1 conversations and turn successful explanations into permanent docs.
- Use metaphors to connect 'nine of the ten dots,' inviting the reader to engage and connect the final dot themselves.

*Timestamp: 00:08:58*


## Boz
*Boz*

> "Communication is the job... it is exclusively done through the creation of artifacts or verbalizations that affect other humans. That is all there is."

**Insight:** Leadership is fundamentally a communication task; if your ideas don't break through or aren't understood, you haven't done the job.

**Tactical advice:**
- Take extreme ownership of whether your message was successfully received by the audience.
- Understand that silence and the absence of check-ins are also forms of communication.

*Timestamp: 00:51:40*

---

> "One is multimodality... I will give an all-hands and then write a post with the content of the all-hands, because different people are going to respond differently to these modalities."

**Insight:** Using multiple channels and repeating key messages ensures that information is absorbed by diverse audiences.

**Tactical advice:**
- Repeat key points using different metaphors and modalities (verbal, written, visual).
- Address the audience's fears and concerns at the very beginning to establish trust in your premise.

*Timestamp: 00:56:46*


## Brandon Chu
*Brandon Chu*

> "It was the writing process itself that actually allowed me to solidify those mental models and those frameworks in my mind. And so I wasn't ahead of the game in any way. It was just I think I really wanted to disambiguate the chaos in my mind about what my job was."

**Insight:** Writing is primarily a tool for the author to achieve clarity and refine mental models, with communication being a secondary benefit.

**Tactical advice:**
- Use writing to 'release' ideas from your mind and clear space for new thinking
- Invest significant time (e.g., 40 hours) into editing and refining core ideas
- Share raw, early thoughts with others to test how your internal narrative resonates externally

*Timestamp: 27:21*


## Christina Wodtke
*Christina Wodtke*

> "They were like, "What's your confidence level on your key results? What did you do last week? And what are you doing next week?" And the last week, next week is great because it allows you to start noting down what stops you from getting shit done."

**Insight:** Weekly status updates should focus on confidence levels and blockers to facilitate cross-team learning and support.

**Tactical advice:**
- Send weekly status updates (via email or Slack) including confidence levels (1-10) for each KR.
- List 'P1' priorities for the next week and reflect on why previous priorities weren't met.

*Timestamp: 00:48:13*


## Claire Hughes Johnson
*Claire Hughes Johnson*

> "Whenever I do write something down, I'm glad I did. So I probably do more crystallizing by writing than I would admit."

**Insight:** Writing serves as a primary tool for clarifying and crystallizing complex thoughts and strategies.

**Tactical advice:**
- Use the act of writing to force clarity on topics you think you already understand

*Timestamp: 00:06:20*

---

> "Having really smart communication practices is something that I think a lot of companies don't invest in early... Do you have a newsletter? Do you have founders do like a message or a quick video, whether that's on Slack or email. There's a lot of smart tools. You can learn a lot from social media in some ways, but you actually need a strategy for it."

**Insight:** Effective internal communication requires a deliberate strategy and multiple channels to ensure information is actually absorbed by the team.

**Tactical advice:**
- Invest in an internal intranet or centralized homepage for company information
- Use a mix of newsletters, Slack messages, and short videos to reach different audiences
- Create a 'weekly snippets' document to share important news across teams

*Timestamp: 01:14:12*


## Deb Liu
*Deb Liu*

> "His advice was write what you repeat. If you say something more than once, just write it down. And then the next time someone asks you, you can just hand them."

**Insight:** Scale your influence and save time by documenting any advice, framework, or feedback that you find yourself repeating to multiple people.

**Tactical advice:**
- Identify recurring questions or topics in your 1:1s and turn them into written memos or blog posts
- Use written artifacts to provide consistent guidance across a large organization

*Timestamp: 00:43:40*


## Dharmesh Shah
*Dharmesh Shah*

> "It's the megaphone issue. Someone will pass you in the hall... they'll ask you a question, and as it turns out... people will take that and over-index on what was an opinion... flash tags are literally... an escalating set of what I call the dying on the hill spectrum."

**Insight:** Standardized tags in written communication prevent 'founder shadow' where casual suggestions are mistaken for mandates.

**Tactical advice:**
- Use #FYI for information with no response expected.
- Use #Suggestion for ideas that don't require a response.
- Use #Recommendation for thought-out ideas where a response is expected if the recipient disagrees.
- Use #Plea for high-conviction requests that are still not mandates.

*Timestamp: 00:57:55*


## Eeke de Milliano
*Eeke de Milliano*

> "Stripe had a very strong writing culture. All communication was along from writing business reviews, strategy memos, product reviews... I don't think you can be a good writer, unless you're a clear thinker."

**Insight:** A strong writing culture forces clear thinking and rigorous analysis across the organization.

**Tactical advice:**
- Use long-form writing for business and product reviews instead of just slides
- Evaluate candidates on their ability to write clearly as a proxy for clear thinking

*Timestamp: 00:15:14*


## Elizabeth Stone
*Elizabeth Stone*

> "I take notes in leadership meetings and I share those notes with the whole organization. And that is sometimes it includes candor around reflections on things that aren't going well or problems we need to solve."

**Insight:** Radical transparency in written communication, such as sharing raw leadership meeting notes, builds trust and provides necessary context to the entire org.

**Tactical advice:**
- Share leadership meeting notes broadly to provide 'context, not control'
- Include reflections on failures or unsolved problems in internal updates to model candor

*Timestamp: 00:48:15*


## Emilie Gerber
*Emilie Gerber*

> "I would say my most successful pitches are three sentences and anytime... Sometimes it needs to be longer than that, and generally I feel like my pitch is weaker for that reason. Attention spans are short, and so the more concise you can make it, the better."

**Insight:** The most effective media pitches are extremely concise, ideally around three sentences.

**Tactical advice:**
- Keep email pitches to three sentences when possible
- Avoid over-explaining or using marketing jargon in outreach

*Timestamp: 00:35:06*

---

> "When I email a reporter, I love to make the subject line just as clear as possible as what the goal is and why I'm emailing them. And so let's say it's for a recurring column that they have, I'll put the name of that column and the person that I think should be included in the subject line."

**Insight:** Subject lines should be highly specific and signal that you understand the reporter's specific beat or column.

**Tactical advice:**
- Include the name of a specific column in the subject line
- State the goal (e.g., 'funding story' or 'guest idea') immediately

*Timestamp: 00:34:38*


## Gergely
*Gergely*

> "To write that post, it takes at least a few days or sometimes even longer. Sometimes it takes a week or two for me to research... I write a first draft. I get some feedback from people who I trust often... And then there's an editing phase where I work with an editor who helps make sure that it's just correct."

**Insight:** High-quality technical writing requires a multi-stage process involving deep research, peer review, and professional editing.

**Tactical advice:**
- Incorporate a feedback loop with trusted peers before publishing deep-dive content.
- Hire a professional editor to ensure clarity and correctness, especially for long-form technical pieces.

*Timestamp: 00:26:37*

---

> "I wrote four or five books' worth of content just last year. It's because I have these deadlines... I also know that thousands of people are paying me, they have expectations of me."

**Insight:** External accountability and strict deadlines are essential for maintaining high-volume writing output.

**Tactical advice:**
- Create public or paid commitments to force a consistent writing schedule.
- Break large writing projects (like books) into smaller, publishable units (like newsletter posts) to maintain motivation.

*Timestamp: 00:30:46*


## Geoff Charles
*Geoff Charles*

> "The best way of doing that is to shut down your laptop, take out a piece of paper, write the question as simply as possible at the top of the paper, and just spend time just thinking about how to answer that question."

**Insight:** Use writing as a tool for first-principles thinking and problem crystallization rather than just documentation.

**Tactical advice:**
- Block out deep work time specifically for thinking and writing without a laptop.
- Start a document with a single, simple question at the top and attempt to answer it from scratch.
- Write to free up headspace for processing rather than using your brain for memory.

*Timestamp: 00:49:25*


## Ian McAllister
*Ian McAllister*

> "I think business writing, I spent a lot of that time doing that at Amazon, is so valuable because you've got to be a clear thinker to be a clear communicator. And so there's two tests in writing well or communicating well. It's both those things. So I found it's pretty valuable in kind of sharpening your ax."

**Insight:** Effective business writing is a direct reflection of clear thinking and serves as a tool to sharpen one's logic.

**Tactical advice:**
- Organize thoughts to be compact and avoid being wordy or rambling
- Use writing as a mechanism to sharpen your own thinking

*Timestamp: 00:08:15*

---

> "Avoid weasel words, answer first and then explain, own your problems... if you can get in the habit early of answering a when question with a date, knowing how to use numbers to answer questions and honestly just learning from feedback and grade yourself after you get feedback on a doc or after a meeting."

**Insight:** High-stakes communication requires directness, the use of data, and a commitment to continuous self-improvement based on feedback.

**Tactical advice:**
- Answer the core question first before providing context
- Avoid 'weasel words' that obscure meaning
- Answer 'when' questions with specific dates
- Grade your own performance after meetings or document reviews

*Timestamp: 00:16:36*


## Jason Feifer
*Jason Feifer*

> "What you want to do is write something that makes it pretty clear to me that this is targeted to me. That's step number one... Don't fake it. People fake it all the time. People email me and they tell me they're fans of my work, they've never read my work. It's very obvious, right? Don't do that. But if you've read something, or if you're familiar with something, if you're familiar with the publication in some way, any signals of that are good."

**Insight:** High-stakes cold outreach succeeds through genuine personalization and demonstrating a deep understanding of the recipient's work.

**Tactical advice:**
- Keep pitch emails short—ideally three paragraphs maximum.
- Reference specific past articles or podcast episodes to prove you are not sending a mass blast.
- Structure pitches using 'Problem' and 'Solution' bullet points to make them easily scannable for busy editors.

*Timestamp: 00:55:40*


## Jason Fried
*Jason Fried*

> "The first one is this book here, so Several Short Sentences About Writing... It's an extraordinarily good book about writing and it's all about the sentence, beautifully written, fun to read, really great."

**Insight:** Effective written communication starts with mastering the structure and clarity of individual sentences.

**Tactical advice:**
- Focus on the 'sentence' as the fundamental unit of clear communication
- Read 'Several Short Sentences About Writing' to improve clarity

*Timestamp: 01:37:33*


## Jason Shah
*Jason Shah*

> "Every employee goes through actually like a business writing class after they start at Amazon. They give you a little card with five tips that you're supposed to keep on your desk about concision and specificity in the words you use. For example, you should never write the word great in an Amazon press release. You should write user friendly in X, Y, Z way and will save customers time 20 minutes each day through this."

**Insight:** High-quality business writing relies on objective specificity and the removal of subjective adjectives.

**Tactical advice:**
- Avoid subjective words like 'great'.
- Use concrete numbers and data points instead of adjectives.
- Practice strict concision by 'killing your darlings' and cutting unnecessary words to force clarity of thought.

*Timestamp: 00:23:22*


## Jeff Weinstein
*Jeff Weinstein*

> "I remember writing the first draft... and he wrote back, 'This doesn't sound like you yet.' ... I rewrote it completely, and I made it sound like me, and I've tried to make things sound like me since."

**Insight:** Effective executive communication requires a personal, authentic voice rather than a sanitized corporate tone.

**Tactical advice:**
- Write internal documents in your own voice to increase clarity and ownership.

*Timestamp: 02:31:54*


## John Mark Nickels
*John Mark Nickels*

> "The most powerful takeaway from that book for me was if it's in your head, you're screwed because it's like you're trying to keep track of stuff and be creative and come up with the future of transportation and remember to pick up something from the pharmacy. It's a recipe for disaster. This whole idea of empty mind, beginner's mind, well, you have to empty the mind of all the to-dos first. Just get that out of the head."

**Insight:** Externalizing all tasks and thoughts is a prerequisite for the 'empty mind' needed for high-level creative work.

**Tactical advice:**
- Write down every task and idea immediately to clear mental bandwidth
- Maintain a simple 'waiting for' list to track dependencies without mental clutter

*Timestamp: 00:40:41*


## Jules Walter
*Jules Walter*

> "On the communications side, I read some stuff like Minto's Pyramid Principles. Extremely helpful... Whenever I see a great email exec update or whatever, I literally save it in a special folder."

**Insight:** Effective written communication is built by studying structured frameworks and maintaining a reference library of high-quality executive updates.

**Tactical advice:**
- Apply the Minto Pyramid Principle to structure documents logically.
- Maintain a 'swipe file' of excellent email templates and executive updates to reference for future writing.
- Prioritize clarity over complexity, as being 'wrong but clear' is often better than being ambiguous.

*Timestamp: 00:40:36*


## Julian Shapiro
*Julian Shapiro*

> "Novelty, I define, as new idea, so something I haven't heard of before, that's also significant, so it's not some trivial fact about Kim Kardashian, and it's something that I wouldn't have easily intuited on my own. When you have those ingredients, it's new, it's significant, and you wouldn't have easily thought of it on your own, that's when you trigger that dopamine hit reaction"

**Insight:** Effective writing relies on a high frequency of novelty—ideas that are new, significant, and counter-intuitive.

**Tactical advice:**
- Identify points of novelty in a draft and condense the 'white space' between them
- Use counter-narrative information (telling people they've been lied to) to increase engagement
- Use 'elegant articulation' to boil complex thoughts into concise, memorable sentences

*Timestamp: 39:03*

---

> "I believe that your likelihood to follow through on something you start writing is a function of the objective you have with writing that piece and how strong your motivation is for seeing that objective to fruition... I'll pair one of those objectives that I've selected with a motivation."

**Insight:** To ensure completion of a writing project, you must pair a clear objective (e.g., 'open people's eyes') with a personal motivation (e.g., 'get something off my chest').

**Tactical advice:**
- Define the objective: Are you proving the status quo wrong or articulating what everyone is thinking?
- Identify the motivation: Are you solving a nagging problem or geeking out on an obsession?
- Use the objective as a guidepost to know exactly when the piece is finished

*Timestamp: 47:00*


## Julie Zhuo
*Julie Zhuo*

> "I approach my writing then and I still do now as letters to myself. This is the framework. This is the advice that I need to give myself that I need to go and really do better, and that is what my writing became for me, and it was hugely helpful for clarifying my train of thought."

**Insight:** Writing serves as a form of 'self-therapy' that organizes scattered thoughts and forces clarity of thinking.

**Tactical advice:**
- Write 'letters to yourself' to clarify your own perspective on complex topics
- Use writing as a tool to become more comfortable speaking up in large meetings

*Timestamp: 00:21:40*

---

> "I actually like word count goal even better than time goal because sometimes you can spend 30 minutes and then still just produce a sentence, and so, that was always how I approached my writing. I was like, 'All right, I'm going to sit my butt down. I'm going to write for 30 or 45 minutes, but it's going to be, whatever, like 250 words.'"

**Insight:** Prioritize word count goals over time-based goals to ensure tangible output and overcome writer's block.

**Tactical advice:**
- Set a specific daily or weekly word count goal (e.g., 500 words)
- Focus on 'getting the words out' first without worrying about quality or editing

*Timestamp: 00:25:32*

---

> "I wanted to get better at in the moment communicating more clearly and being just a little bit sharper, a little bit crisper in the points that I had to make... what if I just push myself to communicate in a much shorter form which is going to force me to really strip away all that ornamentation and focus on the core idea."

**Insight:** Short-form writing (like Twitter threads) forces you to strip away ornamentation and focus on the core essence of an idea.

**Tactical advice:**
- Practice boiling down complex advice into a numbered list or short thread
- Use character limits to force sharper, crisper communication

*Timestamp: 00:33:36*


## Kevin Yien
*Kevin Yien*

> "Writing is clarity at scale, and a key component to a PM's job is creating clarity both internally and externally... if you can't sell or support your own product, I don't trust you to build the product. And so that's where I think writing is the foundational component there."

**Insight:** Writing is the primary tool for a PM to scale clarity and demonstrate a deep understanding of the customer's voice.

**Tactical advice:**
- Write compelling messaging in the voice of the person you are trying to serve.
- Focus on internal clarity through crisp PRDs and external clarity through support/sales-ready writing.

*Timestamp: 00:13:07*

---

> "Good writing comes from consuming as much good writing as possible... the more you index towards developing your own taste for what you think is good by consuming others, then you can shift into producing your own and then comparing them and riffing it off other people."

**Insight:** Developing writing taste through high-quality consumption is the prerequisite for producing compelling writing.

**Tactical advice:**
- Read writing that compels action, such as Paul Graham's essays.
- Avoid reading only PM artifacts; look for diverse, high-quality voices.

*Timestamp: 00:15:16*

---

> "I think there is a lot of value to saying, 'I need 20 minutes of focused time to interrogate something that I've done. We're not going to talk. I'm literally going to force us into a room or Zoom. You're going to read this doc, I'm going to watch you comment on it in real time.'"

**Insight:** Silent document reviews accelerate the feedback loop by reducing the latency between a question and the author's response.

**Tactical advice:**
- Schedule 'silent read' meetings where the only expectation is to engage with the document.
- Respond to comments in real-time within the doc to move 'one clock speed faster'.

*Timestamp: 00:32:35*


## Lane Shackleton
*Lane Shackleton*

> "The thesis is that we're in the midst of a new phase, which is essentially two-way writeups and that's where it's more conversational and feedback and discussion is actually part of the content itself... you have a done reading button at the end of a writeup... making sure that you're actually addressing the most important question... and then probably the most valuable is sentiment or pulse, which is, well, how do you feel overall about this particular proposal?"

**Insight:** Move beyond 'one-way' documents to 'two-way writeups' that integrate feedback, sentiment, and reading status directly into the doc.

**Tactical advice:**
- Add a 'Done Reading' button to track who has consumed the content.
- Use an upvoted Q&A table (Dory) instead of margin comments for major questions.
- Include a sentiment pulse (e.g., 1-5 scale) to gauge overall team alignment.

*Timestamp: 01:14:35*


## Luc Levesque
*Luc Levesque*

> "It's called Smart Brevity... I've always been big on writing crisply and being very tight and not having three-page memos that you're sending off. Especially now that we're remote and we're all doing slack and email and different ways of messaging, how tightly you communicate, how crisp your communication is really important."

**Insight:** In a remote-first world, the ability to communicate complex ideas with extreme brevity is a competitive advantage.

**Tactical advice:**
- Adopt 'Smart Brevity' principles to make internal memos and messages scannable
- Avoid long-form memos in favor of tight, high-impact communication that respects the reader's time

*Timestamp: 01:11:31*


## Logan Kilpatrick
*Logan Kilpatrick*

> "OpenAI has such a slack heavy culture and it really... The instantaneous real time communication on Slack is so crucial. And I just love being able to tag in different people from different teams and get everybody coalesced."

**Insight:** A Slack-heavy culture can be a competitive advantage for rapid cross-functional coordination.

**Tactical advice:**
- Use real-time messaging to coalesce teams faster than walking to a desk or scheduling a meeting.
- Encourage tagging cross-functional stakeholders in public channels to maintain transparency and speed.

*Timestamp: 00:40:45*


## Maggie Crowley
*Maggie Crowley*

> "When you write something, read it out loud, literally just read the thing you wrote out loud and half the time you'll realize it's way too complicated... Just say that thing. The thing that you said to me in conversation is the thing you should write."

**Insight:** Effective writing should mirror natural conversation and be stripped of unnecessary complexity.

**Tactical advice:**
- Read your drafts out loud to identify over-complication
- Write exactly what you would say in a conversation rather than using 'business' prose

*Timestamp: 00:11:27*

---

> "The Minto principle is something that I would recommend everyone do, which is put the headline, the full conclusion first and then you're supporting argument second."

**Insight:** Structure documents to deliver the most important information immediately rather than building up to a conclusion.

**Tactical advice:**
- Use the Minto Pyramid Principle: conclusion first, supporting data second
- Delete the first two paragraphs of most documents as they are usually unnecessary
- Limit conclusions or next steps to a maximum of three items

*Timestamp: 00:18:36*


## Matt Abrahams
*Matt Abrahams*

> "The structure that almost everybody listening in is familiar with is one that comes from the world of advertising. Most advertisements are set up as problem, solution, benefit. There's some problem in the world, here's how we solve it with our product or service, and here's how you benefit from it."

**Insight:** Using a logical structure like Problem-Solution-Benefit makes information more digestible and memorable for the brain.

**Tactical advice:**
- Frame communications by first identifying a problem, then the solution, then the specific benefit

*Timestamp: 00:37:54*

---

> "I really like is a three-question structure: What? So what? Now what? ... What is your product, your service, your offering, your update, your feedback? ... The so what is why is this important and relevant ... And then the now what is what comes next."

**Insight:** The 'What, So What, Now What' framework provides a universal template for clear, actionable communication.

**Tactical advice:**
- Define the 'What' (the facts or the update)
- Explain the 'So What' (the relevance and importance)
- Detail the 'Now What' (the next steps or call to action)

*Timestamp: 00:39:08*


## Melissa Perri
*Melissa*

> "I have CEOs write two-pagers on where did the company come from? How is it different today? What are our external treats to our market? What's our competition? How do you view our competition? What should we care about? What should we not care about?"

**Insight:** Writing strategy in prose (memos) forces clarity and exposes gaps in logic that bullet points or slides might hide.

**Tactical advice:**
- Draft a two-page strategy memo covering vision, market positioning, competition, and prioritized strategic intents.
- Use Google Docs or a Wiki to link strategy documents across different levels (executive, director, team).

*Timestamp: 24:28*


## Nancy Duarte
*Nancy Duarte*

> "Can I make a presentation I can just circulate on email and everyone gets it? Well, that's called a slide doc. You put more words, you put stronger picture... everything they need to see your thinking, it follows behind it."

**Insight:** Slide docs are a hybrid format designed to be read asynchronously, providing the depth of a memo with the visual clarity of a deck.

**Tactical advice:**
- Write in full sentences and prose for documents intended to be read without a presenter
- Use a dense appendix to show the full depth of thinking
- Use slide docs as an alternative to the Amazon-style six-page memo

*Timestamp: 00:43:08*


## Nikita Miller
*Nikita Miller*

> "documentation. It's a thing. Asynchronous communication, everyone just has to get used to it and better at it, so increasingly just being better communicators, whether it's on a video or written."

**Insight:** Strong documentation and asynchronous skills are the foundational requirements for successful distributed teams.

**Tactical advice:**
- Invest in building the team's muscle for written clarity to support remote work

*Timestamp: 43:48*


## Noah Weiss
*Noah Weiss*

> "I actually think especially as you get to more senior positions, writing is the only scalable way of having influence on a larger, larger product org... It's the antidote to that to scale your ability to influence the product direction and maybe even the principles and how you develop product at a company."

**Insight:** Writing is the primary scalable tool for senior leaders to influence product direction and organizational principles beyond direct meetings.

**Tactical advice:**
- Study 'On Writing' by Stephen King to improve production volume and quality.
- Use writing to influence the 'teams of teams' that you cannot meet with daily.

*Timestamp: 01:09:55*


## Ronny Kohavi
*Ronny Kohavi*

> "I've actually put a lot of effort in this idea of institutional learning, of doing the quarterly meeting of the most surprising experiments. ... Document it. We had a large deck internally of these successes and failures, and we encourage people to look at them. The other thing that's very beneficial is just to have your whole history of experiments and do some ability to search by keywords."

**Insight:** Maintain a searchable database of all experiment results to build institutional memory and prevent repeating failed ideas.

**Tactical advice:**
- Document both successful and failed experiments in a central deck or database
- Enable keyword searching across historical experiments for easy retrieval

*Timestamp: 00:17:32*

---

> "I took that to heart. And many of the features that the team presented instead of a PowerPoint, you start off with a structured document that tells you what you need, the questions you need to answer for your idea. And then we review them as a team."

**Insight:** Replace slide decks with structured narrative documents (like Amazon's 6-pagers) to facilitate deeper reviews and honest feedback.

**Tactical advice:**
- Use a structured document template that requires answering specific questions about a proposed idea
- Review documents as a team to ensure feedback is captured and persists after the meeting

*Timestamp: 01:19:34*


## Wes Kao
*Wes Kao*

> "The idea of the super specific how is that most writers, most course instructors spend too much time on the what and the why and not enough time on how. So if you think about people who are reading your writing, most of them probably already agree with the general premise of what you're saying."

**Insight:** Effective communication focuses on the 'how'—the specific application and nuances—rather than justifying the 'what' or 'why'.

**Tactical advice:**
- Minimize time spent on the general premise or context.
- Focus on the specific steps, nuances, and examples of how to apply an idea.

*Timestamp: 00:15:18*

---

> "I have a framework that I call start right before you get eaten by the bear. And the idea is that if you're telling a story about camping, don't start talking about going to REI to buy a Patagonia jacket... Start right before your friend left a Clif Bar out in their tent and you all almost got mauled by a bear. Get to the juicy part."

**Insight:** Engagement is maximized by cutting the preamble and starting the narrative at the point of highest tension or relevance.

**Tactical advice:**
- Cut out the backstory and context-setting 'scope creep'.
- Start your story or document at the most critical or 'juicy' moment.

*Timestamp: 00:17:48*

---

> "more people should learn the craft of writing and the technical aspects of writing, not just look at what other people are doing to try to get audience engagement, but to actually improve your ability to precisely say what you mean and convey the level of conviction that you have and not accidentally mislead people with your words"

**Insight:** Mastering the technical mechanics of writing prevents accidental leading or misleading of the reader.

**Tactical advice:**
- Study the technical craft of sentence structure and logic.
- Be intentional about whether you are leading the reader to a conclusion or presenting objective data.

*Timestamp: 00:41:29*

---

> "in business, you often want to start with here's my conclusion, and then here's why, versus here's all the things I've done, here's all my thinking, here's all my data points, and then now here's my conclusion at the end of that."

**Insight:** Business communication should follow the pyramid principle: lead with the conclusion to respect the reader's time.

**Tactical advice:**
- Place the recommendation or conclusion at the very top of the document or message.
- Separate the 'FYI' context from the specific action items or decisions required.

*Timestamp: 00:43:04*

---

> "Being concise is not about absolute word count, it's about economy of words. It's about the density of the insight that you're sharing. And so you can have a 300 word memo that's meandering and long-winded and a thousand word memo that is tight and concise."

**Insight:** Concision is defined by the density of insight and economy of words rather than a simple character count.

**Tactical advice:**
- Focus on the 'density' of insights rather than just making the text shorter
- Identify your 'core point' or 'the lead' before you start cutting

*Timestamp: 00:18:31*

---

> "I think the blast radius of a poorly written memo is way bigger than most people think. If you are just shooting off a message in a Slack channel with 15 other people, and it's confusing, you didn't include information you should have included, there's going to be a bunch of back and forth."

**Insight:** Poorly written communication creates significant negative leverage through confusion and unnecessary back-and-forth for the entire team.

**Tactical advice:**
- Take an extra 30 seconds to reread and clean up messages before sending
- Ensure all necessary information is included to prevent follow-up questions

*Timestamp: 00:25:37*

---

> "Signposting is using certain words, phrases, formatting, and an overall structure in your writing that helps guide your reader and signals what is coming in the rest of the post."

**Insight:** Using specific transition words helps guide the reader's attention and reduces cognitive load.

**Tactical advice:**
- Use phrases like 'for example', 'because', and 'as a next step' to signal intent
- Kick off paragraphs with 'First, second, third' to create structure without heavy formatting

*Timestamp: 00:27:38*

---

> "I also dislike when people overuse bullets and sentence fragments, phrases in bullets when they should use complete sentences that actually show the connected tissue between ideas, that show the logical flow of what it is that you're saying."

**Insight:** Over-reliance on bullet fragments can hide gaps in logic; full sentences force clearer thinking.

**Tactical advice:**
- Turn bullet fragments into full sentences to test if the idea is fully thought out
- Avoid excessive bolding (more than 30% of a note) to maintain the impact of highlights

*Timestamp: 00:30:33*


## Ebi Atawodi
*Ebi Atawodi*

> "Clarity comes when you write. So I made them write two-page documents. I'll let you go up to four, maybe. But two page documents with insights, your strategy or I use the word approach sometimes and then the big rocks."

**Insight:** Writing short, structured documents (2-4 pages) is the most effective way to achieve clarity in product strategy.

**Tactical advice:**
- Draft two-page strategy documents using the structure: Insights, Strategy/Approach, and Big Rocks

*Timestamp: 00:58:43*


## Naomi Gleit
*Naomi Gleit*

> "I really believe in frameworks for things that helps drive extreme clarity. I work on a lot of different projects. A lot of times I'm ramping up a new project, I'm like, "Where can I learn what I need to learn about this project?" I ask five different people, get five different answers. That is unacceptable. Of course, I'm sure there's hundreds of docs associated with the project, but there needs to be one canonical doc."

**Insight:** Every project should have a single 'canonical doc' that serves as the central source of truth and links to all other relevant documentation.

**Tactical advice:**
- Create one canonical doc for every project
- Ensure the doc links to all other associated documents

*Timestamp: 00:00:00*

---

> "I never use bulleted lists because you can never refer to a bullet. I always use numbered lists because you can always in the visual in a meeting as referenced in number two, I have feedback on that, versus the third bullet, two up from the second, whatever, that is not extreme clarity."

**Insight:** Use numbered lists instead of bullet points to allow for precise referencing during discussions and meetings.

**Tactical advice:**
- Replace bulleted lists with numbered lists in all documents and presentations

*Timestamp: 00:52:19*

---

> "Everyone should know exactly where the canonical doc is. That's the one place I can go to get all the information I need about a project and it will link to all the other docs... The basic information that you need to know is what are the discrete areas of work, I call those work streams... Who are the owners on those work streams?"

**Insight:** A canonical document must define work streams, single-threaded owners, and the communication processes for the team.

**Tactical advice:**
- Define discrete work streams in the project doc
- Assign a single-threaded owner (STO) to every work stream
- List canonical meetings, email lists, and chat channels in the doc

*Timestamp: 00:53:18*


## Peter Deng
*Peter Deng*

> "Language actually affects the way you think... when I make slide decks... I spent hours obsessing over them because I really wanted to make sure I captured the right essence of what I was trying to say."

**Insight:** Precise language is a tool for clear thinking; the words used in docs and decks have significant downstream effects on team alignment.

**Tactical advice:**
- Obsess over word choice in vision docs and PRDs to avoid misinterpretation
- Limit word count on slides to force density and clarity of thought

*Timestamp: 00:17:14*


## Tamar Yehoshua
*Tamar Yehoshua*

> "He doesn't believe in PowerPoint. You write a six pager about ... It's like studying for the final exam is writing these six pagers."

**Insight:** Narrative writing (six-pagers) forces deeper thinking and better preparation than slide decks.

*Timestamp: 00:27:25*


## Will Larson
*Will Larson*

> "I feel really strongly that you can write a lot more if you write what you want to write... the biggest strength of writing what you want is you get to write where there's energy and you don't have to write where there's no energy, which takes you really, really negative."

**Insight:** Sustainable writing is driven by personal energy and curiosity rather than external deadlines or financial incentives.

**Tactical advice:**
- Write about topics that directly relate to your current work to refine your thinking
- Give up on projects where the energy has dissipated rather than forcing them

*Timestamp: 00:28:12*

---

> "If your goal is to write a lot consistently over time, my biggest advice would be just publish. And so there's a lot of people out there with stuff that hundreds of drafts and they've not published anything. And my thing is I publish almost everything I write."

**Insight:** To build a long-term writing habit, prioritize publishing frequently over achieving perfect quality.

**Tactical advice:**
- Don't start writing something if you don't intend to publish it
- Ignore 'silly feedback' from the internet to maintain the psychological safety to keep publishing

*Timestamp: 00:38:51*


