# Aesthetic directions (pick one fast)

Pick a direction that fits the brand and audience, then commit.

## 1) Editorial magazine
- Vibe: confident, information-dense, premium
- Layout: big headline, narrow body column, pull quotes, rule lines
- Type pairing: display serif + neutral sans
- Details: subtle paper texture, crisp separators, minimal shadows

## 2) Retro utilitarian
- Vibe: 'old web that still converts'
- Layout: simple columns, strong hierarchy, obvious buttons
- Type pairing: system-like mono + bold grotesk
- Details: flat color blocks, pixel-ish icons, zero fluff

## 3) Luxury minimal
- Vibe: quiet, expensive, high intent
- Layout: generous negative space, few words, one hero image
- Type pairing: high-contrast serif + light sans
- Details: hairline borders, soft gradients, slow fades

## 4) Playful product
- Vibe: friendly, approachable, modern
- Layout: chunky cards, rounded shapes, illustrated accents
- Type pairing: quirky display + clean body
- Details: bouncy hover states, tiny microcopy jokes (sparingly)

## 5) Brutalist
- Vibe: raw, direct, anti-marketing
- Layout: hard grid, oversized type, stark color accents
- Type pairing: heavy sans + mono for details
- Details: minimal animation, high contrast, loud CTA

## 6) Techno-futurist
- Vibe: sharp, fast, high-performance
- Layout: diagonal cuts, layered panels, glow accents
- Type pairing: condensed display + readable sans
- Details: subtle scanlines/noise, kinetic hero entrance

## 7) Organic natural
- Vibe: human, calm, sustainable
- Layout: soft shapes, warm imagery, breathing room
- Type pairing: warm serif + friendly sans
- Details: grain, organic gradients, gentle parallax

## 8) Industrial dashboard
- Vibe: serious B2B, operational clarity
- Layout: metric chips, mini charts, structured sections
- Type pairing: crisp sans + mono for numbers
- Details: hover tooltips, sticky CTA rail

## 9) Art deco geometric
- Vibe: bold, geometric, memorable
- Layout: symmetric frames, patterned borders, iconography
- Type pairing: geometric display + understated body
- Details: gold accents, stepped animations

## 10) Cozy handmade
- Vibe: personal, creator-led, community
- Layout: scrapbook vibe, stickers, annotations
- Type pairing: handwritten accent + simple body
- Details: subtle wobble animations, imperfect edges

### Implementation tip

Use CSS variables for palette and spacing. If importing web fonts, load only the weights you use and include a system-font fallback.
