# Copy and content templates

Use these patterns to draft fast, then tailor to the product and audience.

## Hero title formulas (pick 1)

1. Outcome + audience
   - "<Outcome> for <Audience>."
2. Outcome + time
   - "Get <Outcome> in <Timeframe>."
3. Remove a pain
   - "Stop <Pain>. Start <Better State>."
4. Do X without Y
   - "<Do X> without <Common Friction>."
5. Category + differentiator
   - "The <Category> built for <Differentiator>."

## Subheadline formulas

- "<How it works> so you can <Outcome>."
- "<Approach>, <feature>, and <proof> in one <category>."
- "Built for <audience> who need <job-to-be-done> without <tradeoff>."

## CTA patterns

Primary CTA labels (keep it specific):
- "Start free"
- "Get the template"
- "Book a demo"
- "Generate my report"
- "See pricing"

CTA microcopy (1 short line under the button):
- "No credit card required"
- "Takes 60 seconds"
- "Cancel anytime"
- "Join <N> teams"

Rules:
- Match the CTA promise to what happens next.
- Avoid multiple competing CTAs above the fold.

## Social proof menu

Place at least one proof element above the fold.

Options:
- Customer logos (5 to 8 max)
- One short testimonial (name, role, company)
- Metric proof ("Trusted by 12,000 teams")
- Credibility badges (awards, press)

## Features section template

Use outcome-first cards (not feature-first):

- Headline: "<Outcome>"
- Body: "<How> in <1 sentence>"
- Proof: small stat, quote, or screenshot label

Recommended count:
- 3 to 6 feature blocks, grouped into 2 themes max.

## FAQ template (answer objections)

Pick the 5 to 8 questions that most reduce friction.

Common prompts:
- "How does it work?"
- "Who is this for?"
- "What do I get right away?"
- "Do I need a credit card?"
- "Can I cancel?"
- "How do you handle security/privacy?"
- "What if I'm not satisfied?"
- "How is this different from <alternative>?"

Guidelines:
- Keep each answer 2 to 4 sentences.
- End 1 to 2 answers with a gentle CTA (link or button).

## Conversion copy checklist

- Make the promise concrete (avoid vague words like "best" or "next-gen").
- Use the visitor's language (jobs, pains, outcomes).
- Reduce risk with specifics (time, steps, requirements).
- Repeat the CTA after each major persuasion section.
