# Landing page anatomy and checklists

## Definitions

- Above-the-fold: the part of a web page shown before scrolling.
- Below-the-fold: the portion of a webpage a user must scroll to see.

Use the fold concept to improve engagement, retention, conversions, UX, and SEO.

## Proven landing page anatomy

Default section order:

1. Navigation
2. Hero
3. Social proof
4. CTA block
5. Features
6. CTA repeated 1 to 2 times
7. Footer

Notes:
- Keep navigation minimal. Avoid sending attention to competing destinations.
- Consider a fixed or sticky CTA (especially on mobile) when it reduces friction.

## Above-the-fold: 5-step checklist

1. Define the value you offer (title)
2. Detail your approach (supporting subheadline)
3. Help the user envision it (visual)
4. Establish credibility (social proof)
5. Simplify the next step (call to action)

Fast validation questions:
- Can a first-time visitor explain the offer in 5 seconds?
- Is the CTA's outcome obvious (what happens after I click)?
- Does the visual match the promise (not just decoration)?

## Below-the-fold: persuasion sequence

1. Show clear value (features)
2. Motivate to action (social proof)
3. Clarify questions (FAQ)
4. Repeat your call to action (CTA)

Add optional sections only when needed:
- Pricing and plans
- Security/compliance
- Comparisons
- Case studies
- Integrations

## Annotated examples to learn from

### Notion (patterns)

- Supporting subheadline clarifies the promise.
- Strong product visual helps users know what to expect.
- CTA microcopy reduces risk ("Use for free").
- Fixed CTA in the header keeps the action available.

### Semrush (patterns)

- Outcome-driven headline.
- Single, focused conversion path (enter domain/keyword -> start now).
- Social proof logos placed close to the hero to establish trust.

