---
name: remotion-resemble-ai
description: Create professional AI-narrated videos with Remotion and Resemble.ai - from educational tutorials to product launches
metadata:
  tags: remotion, video, react, resemble, tts, text-to-speech, voiceover, audio, ai-voice, motion-graphics, tutorial, demo, social-media, promo, kinetic-typography
---

## When to use

Use this skill when the user wants to create:

1. **Educational Tutorial Videos** - Research a topic and create an animated explainer
   - Example: "Create a tutorial about the lifecycle of a butterfly for grade 3 students"

2. **SaaS Walkthrough Demos** - Showcase software features with animated UI
   - Example: "Create a demo video showing how to use Notion's database feature"

3. **Product Launch Announcements** - Marketing videos with motion graphics
   - Example: "Create a launch video announcing our new AI-powered search feature"

4. **Tutorial / Walkthrough Videos** - Step-by-step guides with cursor animations
   - Example: "Create a tutorial showing how to set up a project in our app"

5. **Social Media Promo Videos** - Short, punchy kinetic text videos for ads
   - Example: "Create a 15-second Instagram ad for our fitness app"

6. **App/Product Showcase Videos** - Kinetic text combined with floating UI mockups
   - Example: "Create a promo showing our crypto exchange interface"

7. **Landing Page Reveal Videos** - Design-tool aesthetic with webpage animations
   - Example: "Create a video showcasing our new SaaS landing page design"

---

## Video Production Workflow

Follow this pipeline for all video types:

```
1. UNDERSTAND → 2. RESEARCH → 3. SCRIPT → 4. SCENES → 5. AUDIO → 6. ANIMATE
```

### Step 1: Understand the Request

Identify:
- **Video type:** Educational tutorial, SaaS demo, product launch, tutorial/walkthrough, social promo, app showcase, landing page reveal, or AI explainer?
- **Target audience:** Age, expertise level, context
- **Tone:** Educational, professional, energetic, playful, dramatic, minimal
- **Duration:** Ultra-short (5-15s), short (30-60s), medium (1-3min), or long (3-5min)
- **Format:** Widescreen 16:9 (1920x1080), square 1:1 (1080x1080), or vertical 9:16 (1080x1920)
- **Visual style:** Dark dramatic, soft gradient, clean minimal, or design tool aesthetic

### Step 2: Research (for tutorials and demos)

For educational content:
- Search for accurate, up-to-date information
- Use reliable sources (official docs, educational sites)
- Gather key facts, statistics, or steps to explain

For SaaS demos:
- Explore the product to understand features
- Capture screenshots or note UI patterns
- Identify the key workflow to demonstrate

### Step 3: Write the Script

Write a complete voiceover script BEFORE generating audio. Structure varies by video type (see below).

### Step 4: Plan Scenes

Break the script into visual segments:
- Each scene = one key idea or step
- Note what visuals accompany each line
- Plan transitions between scenes

### Step 5: Generate Audio

Use Resemble.ai to generate the voiceover (see setup below).

### Step 6: Create Animations

Build the Remotion composition with animations synchronized to the audio.

---

## Video Type: Educational Tutorial

**Goal:** Explain a concept clearly for a specific audience level.

### Script Structure

```
HOOK (5-10s)
"Have you ever wondered how a caterpillar becomes a butterfly?"

INTRODUCTION (10-15s)
Set context and preview what they'll learn.

BODY (main content, broken into 3-5 key points)
- Point 1: Explain with visual metaphor
- Point 2: Build on previous point
- Point 3: Add detail or example
- ...

RECAP (10-15s)
Summarize the key takeaways.

OUTRO (5s)
Call to action or closing thought.
```

### Audience Adaptation

| Audience | Language Style | Visuals |
|----------|---------------|---------|
| Grade K-2 | Very simple, playful, 5-word sentences | Bright colors, cute characters, big shapes |
| Grade 3-5 | Simple but informative, analogies | Clear diagrams, step-by-step, moderate pace |
| Grade 6-8 | More vocabulary, cause-effect | Charts, labeled diagrams, faster pace |
| High School+ | Technical terms OK, nuance | Data viz, detailed graphics |
| Adults | Professional, concise | Clean design, infographics |

### Animation Patterns for Tutorials

- **Reveals:** Fade in elements as narrator mentions them
- **Transformations:** Morph shapes to show change (caterpillar → butterfly)
- **Diagrams:** Animated labels, arrows pointing to parts
- **Timelines:** Progress bars, step indicators
- **Comparisons:** Side-by-side with highlighting

### Example Scene Plan

```
Script: "First, the butterfly lays tiny eggs on a leaf."

Scene 1:
- Visual: Leaf appears (slide in from bottom, spring animation)
- Visual: Small eggs fade in on leaf
- Timing: Sync "eggs" word with eggs appearing
- Duration: 4 seconds
```

---

## Video Type: SaaS Walkthrough Demo

**Goal:** Show users how to accomplish a task in software.

### Script Structure

```
HOOK (5-10s)
"Let me show you how to [accomplish goal] in [Product]."

CONTEXT (10s)
Why this feature matters, what problem it solves.

WALKTHROUGH (main content)
- Step 1: Navigate to X
- Step 2: Click on Y
- Step 3: Configure Z
- ...

RESULT (10s)
Show the outcome, the finished state.

OUTRO (5-10s)
Recap benefit, suggest next steps.
```

### Visual Elements

- **UI Mockups:** Stylized representations of the interface
- **Cursor animations:** Animated pointer moving to click targets
- **Highlights:** Glowing borders around buttons/fields being discussed
- **Zoom effects:** Focus on specific areas of the UI
- **Callouts:** Text labels pointing to UI elements

### Animation Patterns for Demos

- **Cursor movement:** Smooth bezier curves, slight pause before click
- **Click effect:** Ripple or pulse on click
- **Field focus:** Highlight border, slight scale up
- **Typing animation:** Characters appearing in input fields
- **Transition:** Slide or fade between screens
- **Callout arrows:** Animate in, point to element, fade out

### Example Scene Plan

```
Script: "Click the blue 'New Database' button in the sidebar."

Scene:
- Visual: UI mockup of sidebar
- Animation: Cursor moves to button (0.8s ease-out)
- Animation: Button highlights with glow
- Animation: Click ripple effect
- Animation: New panel slides in from right
- Duration: 3 seconds
```

---

## Video Type: Product Launch Announcement

**Goal:** Generate excitement about a new product or feature.

### Script Structure

```
HOOK (5-10s)
Bold statement or question that grabs attention.

PROBLEM (10-15s)
What pain point does this solve?

SOLUTION REVEAL (10-15s)
Introduce the product/feature dramatically.

KEY FEATURES (20-40s)
3-5 punchy feature highlights with visuals.

SOCIAL PROOF (optional, 10s)
Stats, testimonials, or credibility markers.

CALL TO ACTION (5-10s)
What should viewers do next?
```

### Visual Style

- **Bold typography:** Large text, kinetic type animations
- **Brand colors:** Use product's color palette consistently
- **Icons and graphics:** Abstract shapes, feature icons
- **High energy:** Faster cuts, dynamic movement
- **Logo reveal:** Animated logo at end

### Animation Patterns for Launches

- **Text slams:** Words slam in with impact
- **Kinetic typography:** Words that move, scale, rotate
- **Counter animations:** Numbers counting up (users, revenue, etc.)
- **Icon sequences:** Features appearing with bounce/spring
- **Gradient backgrounds:** Slowly shifting color gradients
- **Particle effects:** Subtle sparkles, floating shapes
- **Logo reveal:** Scale up, fade in, or assemble from pieces

### Example Scene Plan

```
Script: "Introducing Smart Search — find anything in milliseconds."

Scene:
- Visual: Dark background with gradient
- Animation: "Introducing" fades in (0.5s)
- Animation: "Smart Search" slams in large, bold (0.3s, with shake)
- Animation: Tagline types out below (typewriter, 1.5s)
- Animation: Search icon pulses
- Duration: 4 seconds
```

---

## Video Type: Tutorial / Walkthrough

**Goal:** Teach users how to accomplish a task with clear step-by-step visual guidance.

### Script Structure

```
INTRO (3-5s)
"Here's how to [accomplish goal] in [Product]."

STEP 1 (10-20s)
First action with clear visual demonstration.

STEP 2 (10-20s)
Second action, building on previous step.

STEP 3+ (10-20s each)
Continue through workflow...

SUCCESS STATE (5-10s)
Show completion, celebrate the outcome.

RECAP (optional, 5s)
Quick summary of what was accomplished.
```

### Visual Style

- **Light, clean backgrounds:** Off-white (#fafafa), cream, or light gray
- **Full UI context:** Show the complete interface, not just fragments
- **Progress indicators:** Step breadcrumbs, numbered stages (1 → 2 → 3)
- **Cursor as guide:** Smooth cursor movement leads the viewer's eye
- **Success celebration:** Green checkmarks, confetti, or branded success screens
- **Minimal distractions:** Focus on the task, avoid decorative elements

### Animation Patterns for Tutorials

- **Cursor choreography:** Smooth bezier paths with slight pause before clicks
- **Click feedback:** Subtle ripple or highlight on click
- **Form field focus:** Border glow when field is active
- **Typing simulation:** Text appears character-by-character in inputs
- **Step transitions:** Gentle crossfade or slide between screens
- **Progress updates:** Breadcrumb/step indicator animates forward
- **Success burst:** Checkmark scales in with bounce, optional confetti
- **Panel reveals:** Sidebars or dropdowns slide in smoothly

### Visual Elements

- **Breadcrumb navigation:** "← 1. Intent → 2. Seed Idea → 3. Sketchpad"
- **Form inputs:** Placeholder text, labels, validation states
- **Buttons:** Clear CTAs with hover/active states shown
- **Sidebars/panels:** AI suggestions, settings, or tool palettes
- **Success screens:** Full-color background with icon + message

### Example Scene Plan

```
Script: "First, enter what your lesson is about."

Scene 1 - Setup (2s):
- Visual: Full app interface, light background
- Visual: Breadcrumb shows "2. Seed Idea" active
- Animation: Screen fades in

Scene 2 - Interaction (4s):
- Visual: Form with "Enter a concept or theme:" label
- Animation: Cursor moves to input field (0.6s ease-out)
- Animation: Field border highlights blue
- Animation: "The Secret Lives of Mushrooms" types in (2s)
- Animation: Cursor moves to "Continue" button

Scene 3 - Transition (2s):
- Animation: Button highlights on hover
- Animation: Click ripple effect
- Animation: Screen slides left, new panel slides in

Scene 4 - Result (3s):
- Visual: Sketchpad view with AI suggestions panel
- Animation: Suggestion cards stagger in (0.15s delay each)
- Animation: "Lesson Flow" section populates

Scene 5 - Success (3s):
- Visual: Green full-screen background
- Animation: White circle scales in (spring)
- Animation: Checkmark draws inside circle
- Animation: "Your lesson is live!" fades in below
- Animation: Subtitle "Ready to inspire wonder and discovery" fades in
```

### Tutorial Pacing Guidelines

| Step Complexity | Duration | Notes |
|-----------------|----------|-------|
| Simple click | 2-3s | Click and immediate result |
| Form input | 4-6s | Type + submit |
| Multi-field form | 8-12s | Multiple inputs |
| Complex workflow | 15-20s | Several sub-steps |
| Success state | 3-5s | Let it breathe |

### Tips for Effective Tutorials

1. **One action per scene** — Don't rush multiple clicks together
2. **Pause on results** — Let viewers see the outcome before moving on
3. **Highlight what changes** — Use subtle glow or scale on new elements
4. **Match narration to action** — Click happens as narrator says "click"
5. **Show the whole UI** — Context helps users orient themselves
6. **End with celebration** — Success states reinforce completion

---

## Video Type: Social Media Promo

**Goal:** Grab attention fast with bold kinetic text for ads and social content.

### Script Structure

```
HOOK (1-3s)
Single powerful word or phrase that stops the scroll.

VALUE PROP (3-5s)
What's in it for them? One punchy sentence.

FEATURE FLASH (5-10s)
2-3 key benefits, rapid fire.

CTA (2-3s)
Clear action: "Download now", "Try free", URL
```

### Visual Style

- **Minimal backgrounds:** Solid colors or simple gradients
- **Maximum contrast:** Dark bg + white text OR colored bg + white text
- **Word-by-word reveals:** Each word gets its own moment
- **Color transitions:** Background color shifts between scenes
- **Square format:** 1080x1080 for Instagram/social feeds

### Animation Patterns for Social Promos

- **Word slam:** Single words appear with impact (scale 1.2→1 + slight shake)
- **Background flash:** Instant color changes between words/phrases
- **Text scaling:** Words grow large then shrink to make room for next
- **Minimal motion:** Let bold typography do the work
- **Fast cuts:** 0.5-1s per word/phrase maximum

### Example Scene Plan

```
Script: "We are ready."

Scene sequence (4 seconds total):
- Frame 1: Black bg, "WE" slams in white (0.8s)
- Frame 2: White bg, "A" appears black, centered (0.8s)
- Frame 3: Red bg, "R" types out, becomes "READY" (1.6s)
- Frame 4: Hold final frame (0.8s)
```

### Duration Guidelines

| Platform | Ideal Length | Max Length |
|----------|--------------|------------|
| Instagram Reels | 15-30s | 90s |
| TikTok | 15-60s | 3min |
| Twitter/X | 15-45s | 2min 20s |
| LinkedIn | 30s-1min | 10min |
| YouTube Shorts | 15-60s | 60s |

---

## Video Type: App/Product Showcase

**Goal:** Demonstrate a product's interface with cinematic flair, combining text and UI.

### Script Structure

```
HOOK (3-5s)
Problem statement or intriguing question.

INTRODUCE PRODUCT (5-10s)
Show the product name/logo, establish brand.

FEATURE TOUR (20-40s)
Walk through 3-5 key features with UI demonstrations.

BENEFIT SUMMARY (5-10s)
Recap what makes it special.

CTA (5s)
URL, app store badge, or next step.
```

### Visual Style

- **Dark gradient backgrounds:** Black to purple/blue for tech products
- **Soft gradient backgrounds:** Pastels (pink, lavender, mint) for friendly apps
- **Floating UI mockups:** App screens at slight angles with shadows
- **Kinetic text alongside UI:** Text appears next to or above interface
- **Cursor interactions:** Show clicks, scrolls, typing within the UI

### Animation Patterns for App Showcases

- **URL bar typing:** Browser address bar with typewriter effect
- **UI slide-in:** App mockups slide in from bottom or side with spring
- **Perspective tilt:** UI has subtle 3D rotation (5-10 degrees)
- **Glow effects:** Subtle glow/bloom around UI elements
- **Cursor choreography:** Smooth bezier movement with click ripples
- **List reveals:** Items in lists appear with stagger (0.1s delay each)
- **Token/icon grids:** App icons or crypto tokens arranged in grid

### Example Scene Plan

```
Script: "Earn the best yields on your crypto."

Scene 1 (3s):
- Visual: Soft purple gradient background
- Animation: Text "Earn the best" fades in, "yields" appears in accent color
- Timing: Words sync with voiceover

Scene 2 (4s):
- Visual: Browser URL bar appears (rounded rectangle)
- Animation: "jumper.exchange/" types out character by character
- Animation: Cursor blinks at end

Scene 3 (5s):
- Visual: App UI mockup slides up from bottom
- Animation: Token list (USDC, ETH, LINK) reveals with stagger
- Animation: Cursor moves to highlight token row
```

---

## Video Type: Landing Page Reveal

**Goal:** Showcase a website design with dramatic designer-tool aesthetics.

### Script Structure

```
INTRO (3-5s)
Establish the problem or context.

DESIGN REVEAL (10-20s)
Dramatic entrance of the landing page.

FEATURE CALLOUTS (15-30s)
Highlight specific sections of the page.

CTA (5-10s)
"Book a demo", "Get started", with URL.
```

### Visual Style

- **Design tool aesthetic:** Grid lines, guides, rulers visible
- **Neutral backgrounds:** Light gray (#f5f5f5) or dark charcoal (#1a1a1a)
- **Full webpage mockups:** Complete landing page in browser frame
- **Light beams/lens flares:** Dramatic reveal lighting
- **Bento grid layouts:** UI components arranged in grid formation

### Animation Patterns for Landing Page Reveals

- **Grid appearance:** Dotted guide lines fade in first
- **Element construction:** Blue rectangles represent elements before they "become" real UI
- **Light sweep:** Diagonal light beam crosses the design
- **Zoom and pan:** Camera movement across the page
- **Component highlights:** Sections glow or lift when discussed
- **Browser frame:** Chrome/Safari browser chrome for context

### Example Scene Plan

```
Script: "Achieve team harmony with TeamFusion."

Scene 1 (2s):
- Visual: Dark background, grid lines appear (dashed, gray)
- Animation: Blue rectangle placeholder at center
- Animation: Cursor enters frame

Scene 2 (3s):
- Visual: Light beam sweeps diagonally
- Animation: Blue rectangle transforms/morphs into webpage mockup
- Animation: Glow effect around the design

Scene 3 (5s):
- Visual: Full landing page visible with bento-style feature cards
- Animation: Cards lift slightly with shadow on hover simulation
- Animation: Text callout points to CTA button
```

---

## Video Type: AI/Tech Product Explainer

**Goal:** Explain complex AI or tech products with text and interface demonstrations.

### Script Structure

```
MEET THE PRODUCT (5-10s)
"Meet [Product] — the [category] that [key benefit]."

PROBLEM (10-15s)
What frustration does this solve?

HOW IT WORKS (20-40s)
Show the interface, demonstrate the magic.

INTEGRATIONS (10-15s)
What does it connect with?

CTA (5-10s)
Try it, sign up, learn more.
```

### Visual Style

- **Dark mode UI:** Dark backgrounds with vibrant accent colors
- **Neon accents:** Purple, cyan, magenta glows
- **Voice/AI indicators:** Waveforms, recording buttons, chat bubbles
- **App icon grids:** Show integrations with recognizable logos
- **Side-by-side layout:** Text on one side, UI on the other

### Animation Patterns for AI Explainers

- **Voice waveform:** Animated dots or bars showing "listening"
- **Recording indicator:** Pulsing red dot with "Stop" button
- **Chat message typing:** Messages appear with typing indicator first
- **Model selector:** Dropdown showing AI model options
- **Integration icons:** App logos slide in from edges with stagger
- **Glow pulses:** Elements glow when being discussed

### Example Scene Plan

```
Script: "Meet the AI assistant that lets you talk to all your apps."

Scene 1 (3s):
- Visual: Dark purple gradient background
- Animation: "Meet" fades in gray, holds

Scene 2 (5s):
- Visual: App mockup slides in from right
- Visual: Voice recording UI with waveform animation
- Animation: Red recording dot pulses
- Animation: Text "that lets you talk to all your apps" appears left

Scene 3 (4s):
- Visual: Dropdown opens showing model options (GPT-4, Claude, etc.)
- Animation: List items stagger in (0.1s delay)
- Animation: Cursor hovers, selection highlights
```

---

## Visual Styles Reference

Choose a visual style based on the product type and tone:

### Dark Dramatic (Tech, AI, Fintech, Crypto)
- **Background:** Black to purple/blue gradient, or solid dark (#0a0a0a)
- **Text:** White or light gray, with colored accents
- **Accents:** Neon purple (#8b5cf6), cyan (#06b6d4), magenta (#ec4899)
- **Effects:** Glows, light beams, subtle particles

### Soft Gradient (Consumer Apps, Lifestyle)
- **Background:** Pastel gradients (lavender→pink, mint→blue)
- **Text:** Dark purple or navy for contrast
- **Accents:** Complementary pastels
- **Effects:** Soft shadows, rounded corners, friendly motion

### Clean Minimal (SaaS, Productivity, B2B)
- **Background:** White (#ffffff) or light gray (#f8fafc)
- **Text:** Dark gray (#1f2937) or black
- **Accents:** Brand color for buttons/highlights
- **Effects:** Subtle shadows, clean transitions

### Design Tool (Landing Pages, Design Showcases)
- **Background:** Neutral gray with visible grid
- **Elements:** Construction indicators (blue rectangles, guides)
- **Effects:** Light sweeps, element reveals
- **Frame:** Browser chrome for context

---

## Animation Vocabulary

Use these terms when describing animations:

### Basic Animations

| Term | Effect | Best For |
|------|--------|----------|
| **Fade** | Opacity 0→1 or 1→0 | Subtle entrances, transitions |
| **Slide** | Move from off-screen | UI elements, list items |
| **Scale** | Grow or shrink | Emphasis, entrances |
| **Spring** | Bouncy with overshoot | Playful, energetic feel |
| **Ease-out** | Starts fast, slows at end | Natural movement |
| **Ease-in-out** | Slow start and end | Smooth, polished |
| **Typewriter** | Characters appear one by one | Text reveals, URLs, code |
| **Stagger** | Sequential delay between items | Lists, multiple elements |
| **Morph** | Shape transforms into another | Transformations, transitions |
| **Pulse** | Scale up/down rhythmically | Drawing attention |
| **Shake** | Quick horizontal vibration | Impact, emphasis |
| **Wipe** | Reveal with moving edge | Scene transitions |

### Advanced Animations (from examples)

| Term | Effect | Best For |
|------|--------|----------|
| **Word slam** | Word appears with scale overshoot + shake | Bold statements, social videos |
| **Background flash** | Instant background color change | Scene transitions, energy |
| **Light sweep** | Diagonal light beam across frame | Dramatic reveals |
| **Glow/bloom** | Soft light halo around element | Focus, premium feel |
| **Perspective tilt** | 3D rotation (5-10°) on UI | App mockups, depth |
| **Cursor trail** | Smooth bezier path for pointer | UI demonstrations |
| **Click ripple** | Circular pulse on click | Button interactions |
| **Countdown** | Numbers ticking down | Urgency, timers |
| **Grid reveal** | Guide lines appear before content | Design tool aesthetic |
| **Logo assemble** | Logo pieces come together | Brand reveals |

### Timing Guidelines

- **Ultra-fast:** 0.1-0.2s — Word slams, color flashes
- **Fast:** 0.2-0.3s — Snappy, energetic
- **Medium:** 0.4-0.6s — Balanced, professional
- **Slow:** 0.8-1.2s — Dramatic, elegant
- **Stagger delay:** 0.1-0.2s between items
- **Hold time:** 0.5-1s — Let important text breathe

---

## Scene Planning Template

For each scene, document:

```
SCENE [number]: [title]
Script: "[exact voiceover text]"
Duration: [X seconds]
Visuals:
  - [element]: [description]
  - [element]: [description]
Animations:
  - [timing]: [element] [animation type] ([duration], [easing])
  - [timing]: [element] [animation type] ([duration], [easing])
Transition to next: [type]
```

---

## Required Setup - Resemble.ai

Before generating voiceovers, verify the user has credentials configured.

### Check for existing configuration

Check if `.env` file exists with:
- `RESEMBLE_API_KEY` - The Resemble.ai API token
- `RESEMBLE_VOICE_UUID` - Voice ID (optional, defaults to `7213a9ea`)

### Prompt for missing credentials

**If RESEMBLE_API_KEY is missing:**
Ask: "I need your Resemble.ai API key to generate voiceovers. You can get one from https://app.resemble.ai/account/api — please paste your API key:"

**If RESEMBLE_VOICE_UUID is missing:**
Use the default voice UUID `7213a9ea`. Only ask if they want a different voice.

### Save credentials

1. Create or update `.env` with the provided values
2. Ensure `.env` is in `.gitignore`
3. Confirm setup before proceeding

### Credential Security

- NEVER commit API keys to version control
- NEVER display the full API key back to the user
- ALWAYS ensure `.env` is in `.gitignore`
- Store credentials only in `.env`, never hardcoded

---

## Captions Behavior

**Captions are DISABLED by default.** Only generate word-level timestamps and caption components when explicitly requested.

### Default (no captions):
- Generate audio file only
- Save basic metadata (duration, fps, durationInFrames)
- Do NOT process timestamps into words

### When user requests captions:
- User must explicitly ask for "captions", "subtitles", or "word highlighting"
- Process `audio_timestamps` into word-level data
- Include caption components in composition

---

## Rule Files

Read these for detailed implementation:

- [rules/resemble-setup.md](rules/resemble-setup.md) - API credentials and configuration
- [rules/resemble-sync-tts.md](rules/resemble-sync-tts.md) - Synchronous TTS generation
- [rules/resemble-streaming-tts.md](rules/resemble-streaming-tts.md) - Streaming for longer scripts
- [rules/resemble-voices.md](rules/resemble-voices.md) - Voice selection and management
- [rules/resemble-remotion-integration.md](rules/resemble-remotion-integration.md) - Audio integration with Remotion
- [rules/resemble-captions.md](rules/resemble-captions.md) - Synchronized captions
- [rules/visual-animations.md](rules/visual-animations.md) - Animation patterns and Remotion primitives

---

## Quick Reference

### For Educational Tutorial:
1. Research the topic thoroughly
2. Adapt language to audience level
3. Use reveal animations synced to narration
4. Include visual metaphors and diagrams

### For SaaS Demo:
1. Understand the feature workflow
2. Create UI mockups or capture screenshots
3. Use cursor animations and highlights
4. Show the result/outcome clearly

### For Product Launch:
1. Focus on the problem → solution narrative
2. Use bold typography and brand colors
3. Keep it punchy — short sentences, fast cuts
4. End with clear call to action

### For Tutorial / Walkthrough:
1. Light, clean UI aesthetic
2. One action per scene — don't rush
3. Cursor guides the viewer's attention
4. Show step progress (breadcrumbs, numbers)
5. Pause on results before moving on
6. End with success state celebration

### For Social Media Promo:
1. Lead with one powerful word/phrase
2. Use word-by-word reveals with impact
3. Background color transitions add energy
4. Keep total duration under 30s for best engagement
5. Square (1080x1080) format for feeds

### For App/Product Showcase:
1. Choose gradient style (dark dramatic vs soft pastel)
2. Show UI mockups with slight perspective/tilt
3. Combine kinetic text with interface demos
4. Use URL bar typing for web products
5. Cursor choreography for click demonstrations

### For Landing Page Reveal:
1. Start with design tool aesthetic (grids, guides)
2. Use light sweep for dramatic reveal
3. Show full webpage in browser frame
4. Highlight specific sections with callouts
5. End with clear CTA and URL

### For AI/Tech Explainer:
1. Dark mode aesthetic with neon accents
2. Show voice/chat UI interactions
3. Demonstrate integrations with app icon grid
4. Side-by-side layout: text + interface
5. Use waveforms and typing indicators for AI feel
