# Advanced Elicitation Methods

50 analysis methods for deep trend and news analysis. Select based on context.

---

## COLLABORATION METHODS (Multi-Perspective Analysis)

### 1. Stakeholder Round Table
**Use:** Requirements gathering, finding balanced solutions across competing interests
**Pattern:** perspectives → synthesis → alignment
**Best for:** News affecting multiple groups, policy changes, platform updates

### 2. Expert Panel Review  
**Use:** Deep specialized analysis, peer review quality needed
**Pattern:** expert views → consensus → recommendations
**Best for:** Technical announcements, scientific breakthroughs, industry reports

### 3. Debate Club Showdown
**Use:** Exploring controversial decisions, finding middle ground
**Pattern:** thesis → antithesis → synthesis
**Best for:** Polarizing topics, regulatory debates, ethical dilemmas

### 4. User Persona Focus Group
**Use:** Validating features, discovering unmet needs
**Pattern:** reactions → concerns → priorities
**Best for:** Product launches, service changes, consumer-facing news

### 5. Time Traveler Council
**Use:** Gaining perspective on long-term consequences vs short-term pressures
**Pattern:** past wisdom → present choice → future impact
**Best for:** Strategic decisions, technology adoption, cultural shifts

### 6. Cross-Functional War Room
**Use:** Reveals trade-offs between feasibility, desirability, and viability
**Pattern:** constraints → trade-offs → balanced solution
**Best for:** Product strategy, startup news, enterprise decisions

### 7. Mentor and Apprentice
**Use:** Surfaces hidden assumptions through teaching
**Pattern:** explanation → questions → deeper understanding
**Best for:** Complex technical topics, explaining to broader audience

### 8. Good Cop Bad Cop
**Use:** Finding both strengths to build on and weaknesses to address
**Pattern:** encouragement → criticism → balanced view
**Best for:** Evaluating new products, company strategies, market moves

### 9. Improv Yes-And
**Use:** Generates unexpected creative directions
**Pattern:** idea → build → build → surprising result
**Best for:** Brainstorming implications, creative applications

### 10. Customer Support Theater
**Use:** Reveals real user frustrations and service gaps
**Pattern:** complaint → investigation → resolution → prevention
**Best for:** Service disruptions, product failures, consumer complaints

---

## ADVANCED REASONING METHODS

### 11. Tree of Thoughts
**Use:** Complex problems with multiple valid approaches
**Pattern:** paths → evaluation → selection
**Best for:** Strategic decisions, multi-factor analysis

### 12. Graph of Thoughts
**Use:** Systems thinking, discovering emergent patterns
**Pattern:** nodes → connections → patterns
**Best for:** Interconnected trends, ecosystem analysis

### 13. Thread of Thought
**Use:** Maintaining coherent reasoning across long contexts
**Pattern:** context → thread → synthesis
**Best for:** Long-form analysis, connecting multiple sources

### 14. Self-Consistency Validation
**Use:** High-stakes decisions where verification matters
**Pattern:** approaches → comparison → consensus
**Best for:** Fact-checking, verifying claims, critical analysis

### 15. Meta-Prompting Analysis
**Use:** Optimizing approach and methodology
**Pattern:** current → analysis → optimization
**Best for:** Improving analysis quality, methodology review

### 16. Reasoning via Planning
**Use:** Strategic planning, sequential decision-making
**Pattern:** model → planning → strategy
**Best for:** Future predictions, roadmap analysis

---

## COMPETITIVE ANALYSIS METHODS

### 17. Red Team vs Blue Team
**Use:** Finding vulnerabilities, building robust solutions
**Pattern:** defense → attack → hardening
**Best for:** Security news, risk assessment, competitive threats

### 18. Shark Tank Pitch
**Use:** Stress-testing business viability, clarifying value proposition
**Pattern:** pitch → challenges → refinement
**Best for:** Startup news, funding announcements, business models

### 19. Code Review Gauntlet
**Use:** Finding consensus on best practices
**Pattern:** reviews → debates → standards
**Best for:** Technical standards, methodology debates

---

## TECHNICAL ANALYSIS METHODS

### 20. Architecture Decision Records
**Use:** Ensures decisions are well-reasoned and documented
**Pattern:** options → trade-offs → decision → rationale
**Best for:** Technical decisions, platform choices, infrastructure

### 21. Rubber Duck Debugging Evolved
**Use:** Forces clarity at multiple abstraction levels
**Pattern:** simple → detailed → technical → aha
**Best for:** Understanding complex systems, debugging claims

### 22. Algorithm Olympics
**Use:** Finding optimal solution through direct comparison
**Pattern:** implementations → benchmarks → winner
**Best for:** Technology comparisons, performance claims

### 23. Security Audit Personas
**Use:** Comprehensive security review from multiple angles
**Pattern:** vulnerabilities → defenses → compliance
**Best for:** Security incidents, data breaches, privacy news

### 24. Performance Profiler Panel
**Use:** Finding bottlenecks across the full stack
**Pattern:** symptoms → analysis → optimizations
**Best for:** Performance issues, scaling challenges

---

## CREATIVE METHODS

### 25. SCAMPER Method
**Use:** Systematic ideation for product innovation
**Pattern:** Substitute → Combine → Adapt → Modify → Put → Eliminate → Reverse
**Best for:** Innovation opportunities, product evolution

### 26. Reverse Engineering
**Use:** Understanding endpoints, goal achievement
**Pattern:** end state → steps backward → path forward
**Best for:** Understanding strategy, competitive analysis

### 27. What If Scenarios
**Use:** Contingency planning, exploring possibilities
**Pattern:** scenarios → implications → insights
**Best for:** Future projections, risk scenarios

### 28. Random Input Stimulus
**Use:** Breaking creative blocks through lateral thinking
**Pattern:** random word → associations → novel ideas
**Best for:** Finding unexpected angles, creative analysis

### 29. Exquisite Corpse Brainstorm
**Use:** Generates surprising combinations
**Pattern:** contribution → handoff → contribution → surprise
**Best for:** Creative synthesis, unexpected connections

### 30. Genre Mashup
**Use:** Innovation through cross-pollination
**Pattern:** domain A + domain B → hybrid insights
**Best for:** Cross-industry analysis, convergence trends

---

## RESEARCH METHODS

### 31. Literature Review Personas
**Use:** Balanced assessment of evidence quality
**Pattern:** sources → critiques → synthesis
**Best for:** Research news, scientific claims, study analysis

### 32. Thesis Defense Simulation
**Use:** Stress-testing methodology and conclusions
**Pattern:** thesis → challenges → defense → refinements
**Best for:** Validating claims, challenging assumptions

### 33. Comparative Analysis Matrix
**Use:** Structured decision-making with explicit scoring
**Pattern:** options → criteria → scores → recommendation
**Best for:** Product comparisons, market analysis

---

## RISK ANALYSIS METHODS

### 34. Pre-mortem Analysis
**Use:** Risk mitigation before major launches
**Pattern:** failure scenario → causes → prevention
**Best for:** Launch risks, project failures, market entry

### 35. Failure Mode Analysis
**Use:** Reliability engineering, safety-critical systems
**Pattern:** components → failures → prevention
**Best for:** Technical failures, system risks

### 36. Challenge from Critical Perspective
**Use:** Overcoming groupthink, stress-testing ideas
**Pattern:** assumptions → challenges → strengthening
**Best for:** Challenging narratives, finding weaknesses

### 37. Identify Potential Risks
**Use:** Project planning, deployment preparation
**Pattern:** categories → risks → mitigations
**Best for:** Risk assessment, due diligence

### 38. Chaos Monkey Scenarios
**Use:** Testing resilience and recovery
**Pattern:** break → observe → harden
**Best for:** System reliability, disaster planning

---

## CORE ANALYTICAL METHODS

### 39. First Principles Analysis
**Use:** Breakthrough technique for innovation, solving impossible problems
**Pattern:** assumptions → truths → new approach
**Best for:** Paradigm shifts, fundamental changes

### 40. 5 Whys Deep Dive
**Use:** Understanding failures, drilling to root causes
**Pattern:** why chain → root cause → solution
**Best for:** Incident analysis, understanding causes

### 41. Socratic Questioning
**Use:** Revealing hidden assumptions, guiding discovery
**Pattern:** questions → revelations → understanding
**Best for:** Deep analysis, challenging claims

### 42. Critique and Refine
**Use:** Quality check for drafts and analysis
**Pattern:** strengths/weaknesses → improvements → refined
**Best for:** Iterating on analysis, improving quality

### 43. Explain Reasoning
**Use:** Transparency, showing how conclusions reached
**Pattern:** steps → logic → conclusion
**Best for:** Building trust, clear communication

### 44. Expand or Contract for Audience
**Use:** Matching content to reader capabilities
**Pattern:** audience → adjustments → refined content
**Best for:** Adapting analysis depth, targeting audience

---

## LEARNING METHODS

### 45. Feynman Technique
**Use:** Testing true understanding
**Pattern:** complex → simple → gaps → mastery
**Best for:** Explaining complex topics simply

### 46. Active Recall Testing
**Use:** Identifying knowledge gaps
**Pattern:** test → gaps → reinforcement
**Best for:** Verifying understanding, fact-checking

---

## PHILOSOPHICAL METHODS

### 47. Occam's Razor Application
**Use:** Finding simplest sufficient explanation
**Pattern:** options → simplification → selection
**Best for:** Cutting through complexity, debugging narratives

### 48. Trolley Problem Variations
**Use:** Understanding values through moral dilemmas
**Pattern:** dilemma → analysis → decision
**Best for:** Ethical analysis, value trade-offs

---

## RETROSPECTIVE METHODS

### 49. Hindsight Reflection
**Use:** Gaining perspective from imagined future
**Pattern:** future view → insights → application
**Best for:** Strategic analysis, project reviews

### 50. Lessons Learned Extraction
**Use:** Continuous improvement, actionable takeaways
**Pattern:** experience → lessons → actions
**Best for:** Post-incident analysis, learning from events

---

## Method Selection Quick Guide

| Analysis Need | Top 3 Methods |
|---------------|---------------|
| Understanding root cause | 5 Whys, First Principles, Socratic |
| Predicting future impact | Time Traveler, What If, Pre-mortem |
| Finding risks/weaknesses | Red Team, Failure Mode, Devil's Advocate |
| Multiple stakeholder views | Stakeholder Round Table, Debate Club, Expert Panel |
| Innovation opportunities | SCAMPER, Genre Mashup, Reverse Engineering |
| Validating claims | Self-Consistency, Thesis Defense, Literature Review |
| Complex system analysis | Graph of Thoughts, Tree of Thoughts, Cross-Functional |
| Consumer behavior | User Persona, Customer Support, Good Cop Bad Cop |
