---
name: creative-copywriting
description: >
  Master persuasive writing for social media with proven hooks, storytelling frameworks, and 
  psychological triggers. Includes CSV databases with 150+ hooks, power words, carousel 
  structures, and emotional triggers specifically optimized for Instagram swipes and X/Twitter 
  "Read more" clicks. Works with creative-copywriter subagent for intelligent content generation.
---

# Creative Copywriting (2025)

Transform words into scroll-stopping, swipe-inducing, click-compelling content using psychology-backed copywriting techniques.

## What This Skill Solves

**The Attention Economy Problem:**
- Average attention span: 8 seconds (less than a goldfish)
- 47% scroll past content without engaging
- Visual hooks now outperform verbal hooks (2025 shift)
- Storytelling builds 22x more memorable content than facts alone

**This skill provides:**
1. **Hook formulas** - First 3 seconds that stop the scroll
2. **Power word databases** - 200+ emotional trigger words by category
3. **Carousel storytelling** - Structures that maximize swipe-through rate
4. **Psychological triggers** - Evidence-backed persuasion techniques
5. **Read more optimization** - X/Twitter-specific expansion triggers

## When to Use This Skill

**Trigger patterns:**
- "Write a hook for my Instagram carousel"
- "Make this caption more engaging"
- "Create swipe-worthy content"
- "Power words for [emotion/goal]"
- "Storytelling framework for [topic]"
- "Make people click Read more"
- "Hook variations for A/B testing"

**Use with creative-copywriter subagent** for intelligent generation with database queries.

## Core Methodology

### The Hook-Story-Action Framework

Every piece of social content follows this arc:

```
HOOK (0-3 sec) → STORY (3-30 sec) → ACTION (final moment)
    ↓               ↓                  ↓
Stop scroll    Build emotion      Drive behavior
```

### 1. Hooks: The First 3 Seconds

**Hook Categories (2025 Effectiveness Ranking):**

| Type | Description | Best For | Avg Stop Rate |
|------|-------------|----------|---------------|
| Visual Hook | Movement, contrast, unexpected visual | Reels, Carousels | 12.3% |
| Curiosity Gap | Incomplete information, open loop | All platforms | 9.8% |
| Controversy | Bold opinion, myth-busting | X/Twitter, Threads | 9.2% |
| Personal Story | "I failed...", vulnerability | Instagram, LinkedIn | 8.7% |
| Data Shock | Surprising statistic | Educational content | 8.1% |
| Question Hook | Thought-provoking question | All platforms | 7.4% |

**Hook Anatomy:**
```
[Emotion Trigger] + [Specificity] + [Open Loop]

Example: "I lost 10k followers (emotion) in 7 days (specific) doing this one thing... (open loop)"
```

### 2. Power Words: Emotional Triggers

Words that bypass logic and hit emotions directly.

**Categories:**
- **Urgency**: Now, Limited, Ending, Today, Before
- **Exclusivity**: Secret, Insider, Hidden, Rare, Private
- **Curiosity**: Discover, Reveal, Uncover, Finally, Truth
- **Fear**: Warning, Mistake, Avoid, Risk, Don't
- **Desire**: Ultimate, Perfect, Dream, Transform, Unlock
- **Trust**: Proven, Guaranteed, Authentic, Real, Tested
- **Anger/Agitation**: Sick of, Fed up, Frustrating, Enough, Stop

**Usage Rule:** 1-2 power words per hook (more = manipulation feel)

### 3. Carousel Storytelling: Swipe Architecture

**The 7-Slide Narrative Arc:**

```
Slide 1: HOOK - Stop the scroll (bold visual + curiosity)
Slide 2: SETUP - Establish the problem/context
Slide 3: TENSION - Agitate (why this matters)
Slide 4: BRIDGE - Hint at solution
Slide 5: VALUE - Core insight/transformation
Slide 6: PROOF - Evidence, example, or story
Slide 7: CTA - Clear next step
```

**Swipe Triggers Between Slides:**
- End slide mid-sentence: "But here's where it gets..."
- Visual continuation: Arrow, numbered sequence
- Pattern interrupt: Change color, introduce character
- Cliffhanger: "The result surprised everyone..."

**Carousel Types by Goal:**

| Type | Structure | Swipe Rate | Best For |
|------|-----------|------------|----------|
| Educational | Problem → Steps → Result | 65% | Authority building |
| Story | Setup → Conflict → Resolution | 72% | Connection |
| List/Ranking | Intro → Items → Summary | 58% | Saves, shares |
| Transformation | Before → Process → After | 78% | Proof, inspiration |
| Myth-Busting | Myth → Truth → Evidence | 61% | Engagement, shares |

### 4. Read More Triggers (X/Twitter)

**First 280 Characters Must:**
1. Front-load the hook (first 50 chars)
2. Create incomplete pattern
3. Promise value continuation
4. Use strategic line breaks

**Expansion Triggers:**
- Numbers: "7 things I learned..." (brain wants to complete the set)
- Lists: "Here's what changed: 1." (incomplete list)
- Story start: "Last week something happened..." (narrative gap)
- Contradiction: "Everyone says X. They're wrong." (curiosity)

### 5. Psychological Principles

**Core Triggers (Backed by Research):**

| Trigger | Psychology | Usage |
|---------|------------|-------|
| Curiosity Gap | Brain needs closure | Open loops, incomplete info |
| Social Proof | Herd behavior | Numbers, testimonials |
| Scarcity | Loss aversion | Limited time/quantity |
| Reciprocity | Give before ask | Free value first |
| Authority | Expert trust | Credentials, data |
| FOMO | Fear of missing | Trends, urgency |
| Specificity | Credibility | Exact numbers, details |
| Story | Memory formation | Narrative structure |

## How to Use The Databases

### Available Databases

**P0 (Core):**
- `hook-formulas.csv` - 50+ hooks by type, platform, emotion
- `power-words.csv` - 200+ words by emotion category

**P1 (Advanced):**
- `carousel-structures.csv` - 15+ storytelling frameworks
- `swipe-triggers.csv` - 30+ between-slide transitions
- `psychological-triggers.csv` - 20+ persuasion techniques

**P2 (Intelligence):**
- `read-more-patterns.csv` - 25+ X/Twitter expansion patterns
- `emotional-arcs.csv` - 10+ complete emotional journeys

### Query Pattern

**Manual Search:**
1. Identify goal: Hook? Story? Emotion?
2. Filter by: platform, emotion_trigger, effectiveness
3. Select 2-3 patterns
4. Adapt to your content/voice

**With creative-copywriter subagent:**
```
User: "Hook for Instagram carousel about productivity"
→ Subagent queries: platform=instagram, content_type=carousel, topic=productivity
→ Returns: Top 3 hooks with emotion triggers
→ Generates: 3 customized variations with reasoning
```

## Quick Start Guide

### For Instagram Carousels

1. **Slide 1 Hook Formula:**
   ```
   [Power Word] + [Specific Outcome] + [Time Frame]
   "The hidden technique that 10x'd my reach in 7 days"
   ```

2. **Swipe momentum:**
   - Each slide ends with incomplete thought
   - Visual consistency (same template, colors)
   - Text size: readable in 2 seconds
   - Maximum 3 ideas per slide

3. **Final slide:**
   - Clear CTA (save, follow, comment)
   - Recap value delivered
   - Easy to screenshot/share

### For X/Twitter Threads

1. **Tweet 1 formula:**
   ```
   [Hook] + [Promise] + [Specificity]
   "I analyzed 1,000 viral tweets. Here's the pattern nobody talks about: 🧵"
   ```

2. **Thread structure:**
   - Tweet 1: Hook + promise
   - Tweets 2-8: Deliver value (one idea per tweet)
   - Tweet 9: Summary/key takeaway
   - Tweet 10: CTA + retweet request

3. **Read more triggers:**
   - Strategic truncation (let algorithm cut at curiosity point)
   - First tweet hooks continuation
   - Numbers create completion drive

### For Stories/Reels Scripts

1. **First 3 seconds:**
   - Movement > Static
   - Face > No face
   - Text hook + verbal hook

2. **Story arc:**
   ```
   0-3s: Pattern interrupt (visual hook)
   3-10s: Promise setup
   10-30s: Value delivery
   30-45s: Proof/example
   45-60s: CTA
   ```

## Integration with creative-copywriter Subagent

The **creative-copywriter subagent** provides intelligent orchestration:

**Capabilities:**
1. Multi-database querying (hooks + power words + triggers)
2. Emotion-based generation (match intent to triggers)
3. Platform-specific adaptation
4. A/B variation generation (different emotional angles)
5. Storytelling framework recommendations

**Example workflow:**
```
User: "Create carousel about overcoming imposter syndrome"

creative-copywriter:
1. Identifies: emotional topic → story-driven approach
2. Queries carousel-structures.csv: type=transformation
3. Queries hook-formulas.csv: emotion=vulnerability
4. Queries power-words.csv: category=empowerment
5. Generates: Complete 7-slide narrative with hooks and transitions
```

## Best Practices

**Hooks:**
- ✅ Lead with emotion, follow with logic
- ✅ Be specific (numbers, time frames)
- ✅ Create incomplete patterns
- ❌ Don't clickbait (promise must match delivery)
- ❌ Don't use more than 2 power words per hook

**Storytelling:**
- ✅ One idea per slide/tweet
- ✅ End each unit with forward momentum
- ✅ Include yourself in the story (relatability)
- ❌ Don't info-dump
- ❌ Don't break the narrative flow

**Power Words:**
- ✅ Use strategically (scarcity, not abundance)
- ✅ Match emotion to content intent
- ✅ Test variations
- ❌ Don't overuse (manipulation feel)
- ❌ Don't mismatch emotion (urgency for evergreen content)

**Psychology:**
- ✅ Give value before asking
- ✅ Be authentic (fake triggers backfire)
- ✅ Respect audience intelligence
- ❌ Don't manipulate (ethical persuasion only)
- ❌ Don't use fear without offering solution

## Notes and Limitations

**Authenticity First:**
- These techniques amplify good content, not replace it
- Manipulation without value = audience erosion
- Building trust > Short-term engagement

**Platform Evolution:**
- Visual hooks rising (2025 trend)
- Verbal hooks declining effectiveness
- Story > Tips format shift
- Minimalist editing preferred

**Cultural Context:**
- Power words vary by language/culture
- Test with your specific audience
- Localize emotion triggers

## References

**Detailed Guides:**
- `references/hook-anatomy.md` - Deep dive into hook construction
- `references/carousel-psychology.md` - Why carousels work
- `references/power-word-science.md` - Psychology behind trigger words
- `references/storytelling-frameworks.md` - Complete narrative structures

**CSV Databases:**
- `databases/hook-formulas.csv`
- `databases/power-words.csv`
- `databases/carousel-structures.csv`
- `databases/swipe-triggers.csv`
- `databases/psychological-triggers.csv`
- `databases/read-more-patterns.csv`
- `databases/emotional-arcs.csv`
