# Corporate Memphis Style Guide for AI Image Generation

## Overview: The Style That Ate the Corporate World

Corporate Memphis (also known as "Alegria art" or "Big Tech Art Style") is a flat, minimalist illustration style that dominated corporate design from 2017-2024. Originally created by Buck Studios as "Alegria" for Facebook's ecosystem, it became the ubiquitous visual language of tech companies, startups, and digital-first brands.

**Core aesthetic DNA:**
- Flat 2D vector graphics with zero depth or shading
- Abstract human figures with exaggerated, disproportionate features
- Vibrant primary colors (red, blue, yellow, green) or soft pastels
- Non-representational skin tones (blues, purples, oranges) for "universal" appeal
- Geometric shapes as compositional elements
- Minimal or absent facial features
- Characters perpetually in motion/action

**Design Philosophy:**
Corporate Memphis represents "friendly capitalism"—sanitizing corporate communication through playful, optimistic visuals. It's intentionally bland, inoffensive, and infinitely scalable. The style communicates: approachable, inclusive, modern, and "human-centered" without actual human complexity.

---

## Historical Context & Influences

### The Memphis Group Legacy (1980s)

Corporate Memphis inherits its name from the Memphis Group, an Italian design collective (1980-1987) led by Ettore Sottsass. The original Memphis Design featured:
- Bold geometric shapes (circles, triangles, squares, squiggles)
- Bright primary and pastel colors
- Pattern clashing and "anti-design" aesthetic
- Rejection of minimalism and "good taste"
- Influenced by Art Deco, Pop Art, and Atomic Age futurism

**Connection to Corporate Memphis:**
Geometric shapes, bright colors, and playful patterns—but Corporate Memphis strips away Memphis Group's rebellious edge, converting it into safe, mass-produced corporate branding.

### Evolution Timeline

| Era | Development |
|-----|-------------|
| **2010-2015** | Flat design movement emerges (rejection of skeuomorphism), Mary Blair and Charley Harper minimalism influences rise |
| **2017** | Buck Studios creates "Alegria" for Facebook—the definitive Corporate Memphis template |
| **2017-2020** | Mass adoption across tech (Google, Airbnb, Slack, Hinge, Uber) and stock libraries (Humaaans by Pablo Stanley, Open Peeps) |
| **2020-2024** | Peak saturation leads to backlash, parody, and meme status; style begins declining but persists in web UI |

### Key Design Influences

**Mary Blair (Disney concept artist):**
- Simplified, whimsical character designs
- Flat color blocks without gradients
- Childlike optimism and joy

**Charley Harper (wildlife illustrator):**
- "Count the wings, not the feathers" philosophy
- Minimal realism—reducing subjects to geometric essentials
- Bold, flat color application

**Millennial Aesthetic (2010s):**
- Clean white backgrounds
- Sans-serif typography
- Pastel colors (millennial pink, houseplant green)
- "Instagrammable" aesthetic

---

## Core Visual Characteristics

### 1. Human Figure Design

**Proportions (The Signature Distortion):**
- **Small heads** relative to body (often 1:5-1:8 head-to-body ratio vs realistic 1:7-1:8)
- **Oversized torsos** creating blocky, geometric body shapes
- **Long, bendy "noodle" limbs** that bend impossibly (no joints, rubber-like)
- **Tiny or absent feet** (often just rounded stumps)
- **Simplified hands** (mittens, paddles, or basic 3-4 finger shapes)

**Facial Features:**
- **Minimal or absent:** Many figures have NO face at all—blank ovals
- **When present:** Simple dots for eyes, curved line for smile, no nose
- **No detail:** No eyebrows, no pupils, no individual characteristics
- **Universal emotion:** Always neutral-positive or happy, never complex

**Skin Tones (Non-Representational Colors):**
Facebook's Alegria pioneered non-realistic skin colors to avoid racial representation issues:
- Blue (#4A90E2, #5B9BD5)
- Purple (#A855F7, #9B59B6)
- Orange (#FF6B6B, #FF8C42)
- Pink (#FF69B4, #EC4899)
- Yellow (#FFC857, #F4D03F)
- Teal (#00B2A9, #0CB2C0)

**Alternative:** Some designers use realistic skin tones but simplified (flat peach, tan, brown without shading)

**Body Language:**
- Perpetually in action (walking, jumping, gesturing, carrying objects)
- Dynamic poses suggesting movement
- Often interacting with oversized UI elements, devices, or symbolic objects
- Collaborative scenes (multiple figures working together)

---

### 2. Color Theory & Palettes

**Primary Corporate Memphis Palette:**
The style centers on basic color theory—primary and secondary colors at high saturation.

| Color | Hex Codes (Examples) | Usage |
|-------|---------------------|-------|
| **Red** | #E74C3C, #FF6B6B, #D32F2F | Energy, action, passion |
| **Blue** | #3498DB, #4A90E2, #2196F3 | Trust, professionalism, calm |
| **Yellow** | #F1C40F, #FFC857, #FFEB3B | Optimism, happiness, warmth |
| **Green** | #2ECC71, #14C88C, #4CAF50 | Growth, success, health |
| **Purple** | #9B59B6, #A855F7, #673AB7 | Creativity, innovation |
| **Orange** | #FF8C42, #FF6347, #FF9800 | Enthusiasm, friendliness |
| **Pink** | #FF69B4, #EC4899, #E91E63 | Playfulness, approachability |
| **Teal** | #00B2A9, #0CB2C0, #009688 | Modern, fresh, tech |

**Pastel Alternative Palette:**
Used for softer, "friendly" applications (healthcare, education, lifestyle brands):
- Soft pink: #FFB3BA, #F8B4D9
- Pastel blue: #BAE1FF, #A8DADC
- Mint green: #B4E7CE, #C7EFCF
- Pale yellow: #FFFFBA, #FFF4A3
- Lavender: #D5AAFF, #E0BBE4

**Background Colors:**
- **White (#FFFFFF):** 95% of Corporate Memphis uses pure white backgrounds
- **Light gray (#F5F5F5, #FAFAFA):** Subtle alternative
- **Solid color blocks:** Sometimes vibrant color backgrounds with white/contrasting figures

**Color Application Rules:**
- **NO gradients** (flat color only—this is critical)
- **NO shading or highlights** (zero dimensionality)
- **High contrast:** Figures must pop against backgrounds
- **Limited palette per composition:** Typically 3-5 colors maximum
- **Color blocking:** Each element is a single flat color

---

### 3. Geometric Shapes & Compositional Elements

Corporate Memphis uses geometric primitives as decorative and compositional elements:

**Shape Vocabulary:**
- **Circles/dots:** Floating accents, decorative elements, planets
- **Rectangles/squares:** Structural elements, screens, windows
- **Triangles:** Directional arrows, mountains, abstract forms
- **Irregular blobs:** Organic shapes suggesting clouds, water, abstract background elements
- **Squiggly lines:** Memphis Group heritage—decorative wavy lines
- **Grid patterns:** Subtle background texture (rarely)

**Composition Principles:**
- **Flat spatial arrangement:** No perspective, no depth cues
- **Overlap for hierarchy:** Closer = in front (simple layering)
- **Negative space:** Generous white space around elements
- **Asymmetric balance:** Playful, not rigidly symmetrical
- **Floating elements:** Shapes hover without grounding (defying physics)

---

### 4. Technical Execution (Vector Graphics)

**Why Vector?**
Corporate Memphis exists because of Adobe Illustrator and vector workflows:
- Infinitely scalable without quality loss
- Easy to replicate and modify (corporate efficiency)
- Fast to produce (copy, paste, recolor)
- Simple to animate (flat shapes = easy motion graphics)
- Small file sizes for web

**Vector Construction:**
- **Bezier curves:** Smooth, rounded organic shapes (no hard angles unless geometric)
- **Compound paths:** Layered shapes creating figures
- **Clean edges:** No texture, no roughness
- **Uniform line weight:** When outlines exist (rare), consistent thickness

**What to AVOID:**
- Texture overlays
- Brush strokes
- Pencil/crayon effects
- Shadows (drop shadows, inner shadows)
- Gradients (absolutely forbidden)
- Transparency effects
- Blur
- Grain/noise

---

## Subject Matter & Scenarios

### Common Themes

**Technology & Digital Life:**
- Figures interacting with oversized smartphones, laptops, tablets
- Cloud storage metaphors (figures on clouds with data)
- Social media concepts (chat bubbles, likes, shares)
- E-commerce (shopping carts, packages, payment)

**Collaboration & Teamwork:**
- Multiple figures working together
- Passing objects between characters
- Assembling puzzles or building blocks
- Group celebrations (high-fives, thumbs up)

**Productivity & Success:**
- Figures climbing stairs, ladders, or mountains
- Checkmarks, goals, targets
- Charts trending upward
- Figures carrying briefcases, documents

**Lifestyle & Wellness:**
- Yoga poses, meditation
- Healthy food (salads, smoothies)
- Plants and nature elements
- Exercise and movement

**Education & Learning:**
- Books, graduation caps, lightbulbs (ideas)
- Figures teaching or presenting
- Puzzle pieces (problem-solving)

**Diversity & Inclusion:**
- Multiple figures with varied skin tones (non-representational colors)
- Mixed activities suggesting different demographics
- Wheelchair users, different body types (rare but increasing)

---

## AI Prompting Strategies for Corporate Memphis

### Core Prompt Structure

```
[STYLE ANCHOR] + [SUBJECT] + [PROPORTIONS] + [COLOR PALETTE] + [BACKGROUND] + [TECHNICAL SPECS]
```

### Essential Style Anchors

**Primary triggers:**
- `Corporate Memphis style`
- `Alegria illustration style`
- `flat 2D vector illustration`
- `Big Tech art style`
- `Facebook Alegria aesthetic`

**Supporting descriptors:**
- `flat geometric shapes`
- `minimalist vector art`
- `no shading, no gradients`
- `simplified character design`
- `abstract human figures`

---

### Character Design Prompts

**Format:**
```
Corporate Memphis style illustration of [character], [proportions], [features], [pose], [skin color], flat 2D vector art, no shading
```

**Examples:**

**Simple character:**
```
Corporate Memphis style illustration of a person waving, small head with tiny dot eyes and smile, oversized blocky torso, long bendy noodle arms, simplified mitten hands, short stumpy legs, non-representational purple skin tone, flat 2D vector art, no gradients, no shading, minimal facial features, clean geometric shapes
```

**Active character:**
```
Alegria illustration style character jumping with joy, disproportionate small head, large geometric torso, impossibly long elastic limbs bending smoothly, simplified 3-finger hands, blue non-representational skin color, no facial features except curved smile line, dynamic energetic pose, flat vector art, no shadows, no depth
```

**Multiple characters:**
```
Corporate Memphis illustration of three diverse figures collaborating, varied non-representational skin tones (orange, teal, purple), small heads with minimal dot eyes, oversized blocky bodies, long bendy limbs interacting, passing objects between them, flat 2D vector aesthetic, vibrant primary colors, white background, no shading
```

---

### Scene Composition Prompts

**Technology scene:**
```
Corporate Memphis style illustration, flat 2D vector art. Figure with small head and long noodle arms holding oversized smartphone, geometric shapes floating around (circles, triangles), vibrant color palette (blue figure, yellow phone, red accent shapes), white background, no gradients or shadows, minimalist clean design
```

**Collaboration scene:**
```
Alegria illustration of teamwork, multiple abstract figures with disproportionate features working together building geometric puzzle pieces, varied bright colors (purple, orange, green, blue skin tones), small simplified heads, long elastic limbs, flat vector style, no depth or shading, white background, positive energetic mood
```

**Success/achievement scene:**
```
Corporate Memphis illustration, figure climbing geometric staircase toward floating checkmark, small head, oversized torso, bendy noodle legs, non-representational teal skin, vibrant yellow stairs, red checkmark, flat 2D vector aesthetic, no shadows, clean shapes, white background, optimistic corporate theme
```

---

### Web Component Specific Prompts

For UI/web design elements (hero sections, empty states, loading screens):

**Hero section illustration:**
```
Corporate Memphis style hero illustration for tech website, flat 2D vector art. Central figure with small head and long bendy arms interacting with oversized laptop, geometric decorative shapes (circles, triangles) floating around, vibrant blue and yellow color scheme, white background, no gradients, clean minimalist aesthetic, 16:9 landscape composition suitable for web banner
```

**Empty state illustration:**
```
Alegria illustration for empty state UI, single simplified figure with disproportionate features holding magnifying glass looking confused, small head with question mark above, geometric search icons floating, soft pastel color palette (lavender, mint, pale pink), flat vector style, white background, friendly approachable mood, square composition
```

**Loading/processing state:**
```
Corporate Memphis loading illustration, abstract figure with small head and long noodle arms juggling geometric shapes (circles, squares), vibrant primary colors, dynamic movement pose, flat 2D vector art, no shading, white background, playful energetic feeling, suitable for animation
```

**404/error page:**
```
Alegria style 404 illustration, simplified figure with oversized head looking at broken puzzle pieces, non-representational orange skin tone, geometric scattered shapes, minimalist facial features (surprised expression), flat vector aesthetic, bright color accents on white, friendly error message vibe
```

---

### Color Palette Specification

**In prompts, specify colors explicitly:**

```
...vibrant Corporate Memphis color palette: primary red (#E74C3C), bright blue (#3498DB), sunny yellow (#F1C40F), no gradients, flat color blocks only...
```

**Or use color mood:**

```
...energetic Corporate Memphis colors (red, orange, yellow), high saturation, flat application...
```

```
...soft pastel Corporate Memphis palette (pink, lavender, mint green), friendly approachable mood...
```

---

### Technical Quality Specifications

**Essential technical terms:**
- `flat 2D vector illustration`
- `no shading, no shadows, no gradients`
- `clean geometric shapes`
- `Adobe Illustrator style`
- `scalable vector graphics aesthetic`
- `minimal line work` or `no outlines`
- `solid color fills only`

**Aspect ratios for web components:**
- Hero sections: `16:9 landscape composition`
- Square tiles: `1:1 square composition`
- Mobile UI: `9:16 portrait composition`
- Wide banners: `3:1 or 4:1 ultrawide composition`

---

## Complete Example Prompts

### Example 1: Tech Startup Hero Illustration
```
Corporate Memphis style hero illustration for tech startup website, flat 2D vector art. Central figure with small simplified head, oversized blocky torso, long bendy noodle arms enthusiastically gesturing toward floating oversized smartphone screen, non-representational purple skin tone, minimal dot eyes and curved smile. Geometric decorative elements floating around: yellow circles, blue triangles, red rectangles. Vibrant primary color palette (purple figure, yellow phone, blue and red accents), pure white background, no gradients, no shading, no shadows, clean minimalist aesthetic, positive energetic mood, 16:9 landscape composition for web banner.
```

### Example 2: Collaboration Dashboard Illustration
```
Alegria illustration style for team collaboration dashboard, flat vector aesthetic. Three abstract figures with disproportionate features (small heads, large geometric torsos, long elastic limbs) working together assembling oversized puzzle pieces. Varied non-representational skin tones: orange, teal, and pink. Minimal facial features (simple dot eyes, curved smiles). Geometric shapes floating in composition (circles, squares). Bright optimistic color palette, white background, no depth or shadows, clean 2D design, suitable for web application interface, square 1:1 composition.
```

### Example 3: Mobile App Empty State
```
Corporate Memphis empty state illustration for mobile app, portrait orientation. Single simplified figure with tiny head, oversized body, long bendy arms holding magnifying glass, looking slightly confused. Non-representational lavender skin color, minimal facial features (dots for eyes, small line mouth). Floating geometric search icons around figure (simplified magnifying glasses, document shapes). Soft pastel color palette (lavender figure, mint green accents, pale pink background shapes on white), flat 2D vector style, no shading, friendly approachable mood, 9:16 portrait composition for mobile screen.
```

### Example 4: Loading Animation Frame
```
Alegria style loading illustration, flat 2D vector art. Abstract figure with small head and impossibly long noodle arms juggling multiple geometric shapes (red circle, blue square, yellow triangle, green pentagon). Dynamic mid-action pose showing movement and energy. Non-representational orange skin tone, minimal facial features (simple smile). Vibrant primary colors on pure white background, no gradients or shadows, clean vector aesthetic, playful energetic feeling, designed for animation loop, square composition.
```

### Example 5: Success/Achievement Illustration
```
Corporate Memphis success illustration for SaaS product. Figure with disproportionate features (small simplified head, large blocky torso, long elastic legs) climbing geometric staircase toward floating oversized checkmark. Non-representational teal skin color, minimal dot eyes, curved smile. Staircase in vibrant yellow, checkmark in bold green, decorative circles floating around in red and blue. Flat 2D vector style, no shading or depth, white background, optimistic corporate achievement theme, clean minimalist execution, suitable for marketing materials.
```

---

## Advanced Techniques & Variations

### Adding Movement/Energy

**Static pose → Dynamic pose:**
- Emphasize "bendy" limbs mid-motion
- Tilted body angles suggesting momentum
- Legs in running/jumping positions
- Arms outstretched or gesturing broadly
- "Frozen frame" of action

**Prompt modification:**
```
...dynamic energetic pose, limbs in mid-motion, body tilted suggesting movement, jumping/running action...
```

### Varying Facial Expression Complexity

**Minimal (most common):**
```
...no facial features, blank oval head...
```

**Simple (Alegria standard):**
```
...minimal dot eyes, curved smile line, no other features...
```

**Moderate (less common):**
```
...simple dot eyes, curved smile, tiny circle nose, minimal but expressive...
```

### Background Variations

**Standard white:**
```
...pure white background, maximum negative space...
```

**Subtle shapes:**
```
...white background with subtle floating geometric shapes in corners, minimal decoration...
```

**Color block:**
```
...solid pastel blue background, figure and elements in contrasting colors...
```

**Split background:**
```
...half white, half vibrant color background, figure bridging the division...
```

---

## Style Variations & Sub-styles

### Alegria for Business (AFB)
Facebook's enterprise-focused variant:
- Slightly more restrained colors
- More professional scenarios (meetings, presentations)
- Less exaggerated proportions (still stylized but closer to realistic)

**Prompt adjustment:**
```
Corporate Memphis Alegria for Business style, slightly restrained proportions, professional business scenario...
```

### Alegria for Consumer Marketing (ACM)
More playful, emotional variant:
- Higher energy, more dynamic poses
- Brighter, more saturated colors
- More expressive scenarios (joy, surprise, celebration)

**Prompt adjustment:**
```
Corporate Memphis ACM style, high energy dynamic poses, bright saturated colors, celebratory joyful mood...
```

### Stock Library Variants

**Humaaans style (Pablo Stanley):**
- Mix-and-match modular components
- More detailed than basic Corporate Memphis
- Slightly more realistic proportions

**Open Peeps style:**
- Squatter, rounder figures
- More customization options
- Slightly more cartoonish

---

## What NOT to Do (Anti-Patterns)

**Avoid these elements that break Corporate Memphis:**

❌ **Shading or gradients**
- No soft shadows, no light sources, no dimensionality

❌ **Realistic proportions**
- Figures must be disproportionate (small heads, long limbs)

❌ **Complex facial features**
- No detailed eyes, noses, eyebrows, or expressions

❌ **Texture**
- No paper texture, grain, brush strokes

❌ **Depth cues**
- No perspective grids, no vanishing points, no size variation for depth

❌ **Outlines/strokes**
- Most Corporate Memphis has NO outlines (pure shape fills)
- If outlines exist, uniform thickness, never variable

❌ **Photorealistic elements**
- No photo backgrounds, no realistic objects mixed with flat figures

❌ **Sad/negative emotions**
- Corporate Memphis is relentlessly optimistic (never shows struggle, pain, or complexity)

---

## Prompting for Different Use Cases

### Landing Page Hero
```
Corporate Memphis hero illustration, [describe scene], flat 2D vector, vibrant colors on white, no shading, 16:9 landscape, web-optimized composition
```

### Icon/Button Graphics
```
Simplified Corporate Memphis icon, [object], minimal geometric shapes, single bright color, tiny scale, flat vector, white background, suitable for UI button
```

### Email Header
```
Corporate Memphis email header illustration, [scene], horizontal composition, flat vector style, bright friendly colors, white background, 3:1 wide format
```

### Social Media Post
```
Corporate Memphis Instagram post illustration, [concept], square 1:1 composition, vibrant colors, flat 2D vector, white background, eye-catching for social feed
```

### Presentation Slide
```
Corporate Memphis slide illustration, [topic], flat vector style, simple composition, primary colors, white background, supporting text-heavy slide, unobtrusive design
```

---

## Technical Vocabulary Quick Reference

**Style Anchors:**
`Corporate Memphis` | `Alegria illustration` | `flat 2D vector art` | `Big Tech art style` | `minimalist vector illustration` | `geometric flat design`

**Character Descriptors:**
`small head` | `oversized torso` | `long bendy noodle limbs` | `disproportionate features` | `simplified abstract figure` | `minimal facial features` | `dot eyes, curved smile` | `non-representational skin colors` | `elastic rubber-like limbs`

**Color Terms:**
`vibrant primary colors` | `flat color blocks` | `no gradients` | `no shading` | `bright saturated palette` | `soft pastel tones` | `high contrast colors` | `pure white background`

**Technical Specs:**
`flat 2D vector illustration` | `Adobe Illustrator aesthetic` | `clean geometric shapes` | `no shadows, no depth` | `scalable vector graphics` | `minimal line work` | `solid color fills only` | `zero dimensionality`

**Composition Terms:**
`floating geometric shapes` | `negative white space` | `asymmetric balance` | `layered flat elements` | `decorative circles and triangles` | `oversized objects` | `dynamic energetic pose`

**Mood Descriptors:**
`friendly approachable` | `optimistic corporate` | `playful energetic` | `clean minimalist` | `professional yet casual` | `positive upbeat mood`

---

## Consistency Tips for Multiple Generations

1. **Lock style anchor**: Always start with "Corporate Memphis style" or "Alegria illustration"
2. **Specify proportions explicitly**: "small head, oversized torso, long bendy limbs" in every prompt
3. **Enforce flatness**: "no shading, no gradients, flat 2D vector" mandatory
4. **Define color palette**: Name specific colors or color moods consistently
5. **Maintain simplicity**: Corporate Memphis succeeds through reduction—less is more
6. **White background default**: Unless specific need, always use white
7. **Aspect ratio consistency**: Match your use case (16:9 web, 1:1 social, 9:16 mobile)

---

## Final Notes: Understanding the Backlash

Corporate Memphis became so ubiquitous (2017-2022) that it sparked significant criticism:

**Criticisms:**
- **Over-saturation**: Everywhere, all at once, visually exhausting
- **Soulless/generic**: Copy-paste aesthetic with no brand differentiation
- **Insincere**: "Friendly" veneer over exploitative corporations
- **Tokenistic diversity**: Non-representational colors avoid actual representation
- **Sanitizing capitalism**: Utopian optimism masking real problems
- **Easy/lazy**: Too simple to create, floods market with mediocre work

**Why it still matters:**
Despite backlash, Corporate Memphis remains dominant in:
- Web UI empty states and loading screens
- SaaS onboarding flows
- Tech company marketing materials
- App store screenshots
- Educational platforms

**For your use case (web components):**
Corporate Memphis is still highly effective for functional UI illustrations because it's:
- Instantly recognizable
- Doesn't compete with content
- Fast to produce and iterate
- Universally understandable
- Scalable and responsive-friendly

---

## Summary: Core Principles

1. **Flatness is law**: Zero depth, zero shading, zero gradients
2. **Disproportionate characters**: Small heads, big bodies, noodle limbs
3. **Vibrant primary colors**: Red, blue, yellow, green base
4. **Minimal features**: Less is more—reduce to geometric essentials
5. **Non-representational skin**: Blues, purples, oranges for "universal" feel
6. **Vector construction**: Clean Bezier curves, solid fills, scalable
7. **Optimistic energy**: Always positive, never complex or dark
8. **White space dominance**: Generous negative space, uncluttered
9. **Action poses**: Figures in motion, dynamic, collaborative
10. **Geometric decoration**: Circles, triangles, rectangles as accents

**The one-sentence essence:**
Corporate Memphis is the visual equivalent of corporate elevator music—inoffensive, forgettable, infinitely replicable, and designed to make you feel comfortable while asking nothing of you.
