# Social Media Analytics Guide

Data-driven approach to tracking, measuring, and optimizing social media SEO performance.

## Core Principle

**What Gets Measured Gets Improved:**
- Track the right metrics (not vanity metrics)
- Establish baselines
- Test iterations
- Double down on winners

## Platform-Specific Metrics

### Instagram Insights

**Primary Metrics:**
1. **Accounts Reached (Non-Followers)** - Discovery effectiveness
2. **Profile Visits from Search** - SEO working
3. **Saves** - Strongest ranking signal (users find content valuable)
4. **Shares** - Content shareability
5. **Engagement Rate** - (Likes + Comments + Saves + Shares) / Reach

**How to Access:**
- Instagram app → Profile → Insights
- View by post or overall account

**What to Track:**
- Which caption styles get highest saves?
- Which hashtags drive non-follower reach?
- Which topics generate most profile visits?
- Best posting times for YOUR audience

**Red Flags:**
- High reach, low engagement = content not resonating
- High follower count, low reach = engagement rate killed algo
- Lots of likes, few saves = entertainment but not valuable

### X/Twitter Analytics

**Primary Metrics:**
1. **Impressions** - How many saw your tweet
2. **Engagement Rate** - (Total Engagements / Impressions) × 100
3. **Profile Clicks** - Interest in you
4. **Link Clicks** - If monetizing/driving traffic
5. **Retweets** - Amplification signal

**How to Access:**
- twitter.com/analytics (desktop)
- Tweet Analytics (click on any tweet → View Analytics)

**What to Track:**
- Which thread structures get most engagement?
- Which hooks drive highest impressions?
- Optimal posting times
- Tweet types with best engagement rate

**Benchmarks:**
- 1-3% engagement rate = average
- 3-5% = good
- 5%+ = excellent

### Threads Insights

**Primary Metrics:**
1. **Views** - Post reach
2. **Replies** - Conversation quality (heavily weighted)
3. **Reposts** - Share signal
4. **Quotes** - Engagement + amplification

**How to Access:**
- Threads app → Post → View insights

**What to Track:**
- Which topics generate most replies?
- Reply-to-view ratio (higher = better)
- Growth in unconnected reach
- Best times for YOUR audience

**Note:** Threads analytics less developed than IG/X (as of Dec 2025)

## Key Performance Indicators (KPIs)

### Discovery KPIs

**Track Monthly:**
1. **Non-Follower Reach %** - What % of reach comes from discovery?
   - Instagram: Accounts Reached (Non-Followers) / Total Reach
   - Goal: 30%+ from non-followers

2. **Search-Driven Profile Visits** - Are keywords working?
   - Instagram: Profile Visits from Search
   - Goal: Increase month-over-month

3. **Hashtag Performance** - Which hashtags drive discovery?
   - Track reach per hashtag used
   - Iterate: Keep winners, drop losers

### Engagement KPIs

**Track Per Post:**
1. **Engagement Rate** - Quality signal
   - Formula: (Engagements / Reach) × 100
   - Benchmark: 3-5% = healthy

2. **Save Rate** (Instagram) - Ranking signal
   - Formula: (Saves / Reach) × 100
   - Benchmark: 1-2% = good, 3%+ = excellent

3. **Reply Rate** (Threads/X) - Conversation quality
   - Formula: (Replies / Views) × 100
   - Benchmark: 0.5-1% = good, 2%+ = excellent

### Growth KPIs

**Track Weekly:**
1. **Follower Growth Rate**
   - Formula: (New Followers / Total Followers) × 100
   - Benchmark: 5-10% monthly = healthy growth

2. **Follower Quality** - Are they engaged?
   - Look at: Engagement rate as you grow
   - Red flag: Followers ↑ but engagement rate ↓

3. **Conversion Rate** - If monetizing
   - Track: Link clicks, DM requests, sales
   - Varies by goal

## Content Performance Analysis

### A/B Testing Framework

**Test One Variable at a Time:**
1. **Caption Style** - Educational vs Story vs Data
2. **Hook Type** - Question vs Bold claim vs Data
3. **Hashtag Strategy** - 3 vs 5, niche vs broad
4. **Posting Time** - Morning vs afternoon vs evening
5. **Post Format** - Carousel vs single vs Reel

**Method:**
```
Week 1: Test Variable A (all else constant)
Week 2: Analyze results
Week 3: Test Variable B (all else constant)
Week 4: Combine winners
```

**Document:**
- What you tested
- Results (with metrics)
- Winner → Add to your playbook

### Content Audit

**Monthly Review:**
1. Export top 10 performing posts
2. Identify patterns:
   - Common caption style?
   - Common hook type?
   - Common topic?
   - Common posting time?
3. Create "winner template"
4. Replicate success patterns

**Tool:**
- Spreadsheet: Date | Caption Style | Hook Type | Topic | Engagement Rate | Saves | Reach

### Competitive Analysis

**Track 3-5 Competitors:**
1. What caption styles do they use?
2. Which posts get highest engagement?
3. What topics resonate?
4. What can you adapt (not copy)?

**Don't:**
- Copy verbatim
- Blindly follow their strategy
- Assume their audience = your audience

**Do:**
- Learn patterns
- Adapt to your voice
- Find gaps they're missing

## Tools and Resources

### Native Analytics (Free)
- **Instagram Insights** - Built into app
- **Twitter Analytics** - twitter.com/analytics
- **Threads Insights** - Built into app

### Third-Party Tools

**For Tracking:**
- **Metricool** - Multi-platform analytics
- **Iconosquare** - Instagram deep dive
- **Hootsuite** - Cross-platform tracking

**For Content Performance:**
- **Later** - Instagram analytics + planning
- **Buffer** - Multi-platform scheduling + analytics
- **Sprout Social** - Enterprise-level insights

**For Competitor Analysis:**
- **Social Blade** - Growth tracking
- **Phlanx** - Engagement rate calculator

## Reporting Framework

### Weekly Quick Check (5 min)
- Total reach (up or down?)
- Engagement rate (improving?)
- Top performing post (why did it work?)

### Monthly Deep Dive (30 min)
1. **Growth Metrics**
   - Follower growth
   - Reach trends
   - Engagement rate trends

2. **Content Analysis**
   - Top 5 posts (what worked?)
   - Bottom 5 posts (what failed?)
   - Patterns identified

3. **SEO Performance**
   - Non-follower reach %
   - Search-driven visits
   - Hashtag performance

4. **Action Items**
   - What to double down on
   - What to stop doing
   - What to test next month

### Quarterly Strategy Review (2 hours)
1. Did you hit goals?
2. What major shifts happened?
3. Platform algorithm changes?
4. Strategy adjustments needed?
5. Set next quarter goals

## Data-Driven Decisions

### Iteration Framework

**1. Baseline** (Week 1-2)
- Track current performance
- Document current strategy

**2. Hypothesis** (Week 2)
- "If I [change X], then [Y metric] will improve"
- Example: "If I use educational hooks, saves will increase"

**3. Test** (Week 3-4)
- Implement change
- Keep everything else constant
- Track results

**4. Analyze** (Week 5)
- Did hypothesis hold?
- Statistical significance? (need 10+ posts minimum)
- Winner or back to baseline?

**5. Iterate** (Week 6+)
- If winner: Make it standard practice
- If loser: Try different approach
- Document learnings

## Red Flags to Watch

**Warning Signs:**
1. **Declining Engagement Rate** - Content not resonating
2. **Reach Plateau** - Algorithm categorized you (topic too narrow?)
3. **High Unfollow Rate** - Content doesn't match expectations
4. **Low Save Rate** (Instagram) - Not providing value
5. **Low Reply Rate** (Threads/X) - Not sparking conversation

**Action When Red Flags Appear:**
- Review last 10 posts for patterns
- Check for algorithm changes
- Survey audience (Stories poll/tweet)
- Content audit: What changed?

## Success Metrics by Goal

**Goal: Awareness**
- Track: Reach, Impressions, Profile Visits
- Optimize: Discovery (non-follower reach)

**Goal: Engagement**
- Track: Engagement Rate, Replies, Saves
- Optimize: Content quality, conversation starters

**Goal: Community**
- Track: Active followers %, Reply rate, DMs
- Optimize: Consistent engagement, authentic connection

**Goal: Conversion**
- Track: Link clicks, DM rate, Sales (if applicable)
- Optimize: Clear CTAs, valuable offers

## Final Checklist

Weekly:
- [ ] Check engagement rate trend
- [ ] Identify top performing post
- [ ] Note any algorithm changes

Monthly:
- [ ] Export top 10 posts
- [ ] Content performance analysis
- [ ] Test one new variable
- [ ] Update winning formulas in CSVs

Quarterly:
- [ ] Goal review (hit targets?)
- [ ] Strategy adjustments
- [ ] Competitor analysis
- [ ] Set next quarter objectives
