# Transformation Methodology

## Detailed Step-by-Step Process

This document provides the complete methodology for transforming metaphorical/theatrical narrative into concrete visual scenes.

---

## Phase 1: Deconstruction

### 1.1 Read for Emotional Truth
Read the source material asking: "What does this FEEL like?"

**Questions to ask:**
- What emotion would make someone write this?
- If I felt this way, what would I actually DO?
- What is the physical reality behind this poetry?

### 1.2 Identify Metaphor Types
Categorize the metaphors present:

| Type | Example | Extraction Method |
|------|---------|-------------------|
| **Identity Metaphor** | "Aku menjadi laut yang membeku" | Identify the element (sea, fire, ice) → look for behavioral parallels |
| **Relationship Metaphor** | "Kau adalah satu-satunya tuhanku" | Identify power dynamic → translate to visible positioning/behavior |
| **State Metaphor** | "Seprai yang membeku" | Identify the sensory quality → translate to visual/environmental detail |
| **Action Metaphor** | "Berpaling dari surga" | Identify the implied action → make it literal or parallel |

### 1.3 Extract Key Emotional Beats
List the emotional progression in the source:

```
Beat 1: [Emotion] - "..."
Beat 2: [Emotion] - "..."
Beat 3: [Emotion] - "..."
```

Each beat becomes the basis for one or more scenes.

---

## Phase 2: Visual Translation

### 2.1 The "What Would They Actually Do?" Test

For each metaphor, ask: "If someone felt this way, what would I see them doing?"

**Example Transformation:**

```
METAPHOR: "Aku terbangun di atas seprai yang membeku"

Literal meaning: Bedsheets are cold
Emotional meaning: Emptiness, absence of warmth (both physical and emotional)

"What would they actually do?"
- Wake up reaching for empty space beside them
- Pull sheets tight around themselves
- Lie still, not wanting to disturb the bed
- Keep to one side of the bed (the other "belongs" to someone)

VISUAL CHOICE: Woman wakes, hand reaches across empty pillow. 
She pulls the sheet to her nose, inhales. It no longer smells like him.
She curls into fetal position on her side of the bed.
```

### 2.2 Object Selection

Choose props/objects that carry symbolic weight:

**High-Value Visual Objects:**
- Items belonging to absent person (clothing, watch, book)
- Shared items (photos, gifts, household objects)
- Communication devices (phone, letters, messages)
- Environmental markers (empty chair, untouched plate, unmade side of bed)

**Object Placement Rules:**
- Objects should be shown in USE or RELATION to character
- First appearance: establish the object
- Later appearances: show changed relationship to object
- Final appearance: resolve the object's meaning

### 2.3 Location Selection

Choose locations that amplify emotion:

| Emotion | Location Types |
|---------|----------------|
| Intimacy/Loss | Bedroom, kitchen, shared spaces |
| Waiting/Longing | Windows, doorways, transit points (stations, airports) |
| Worship/Devotion | Elevated spaces, light-filled areas, places of ritual |
| Isolation | Empty rooms, vast landscapes, enclosed spaces |
| Memory | Places associated with "before" (first date spot, etc.) |

---

## Phase 3: Scene Construction

### 3.1 Scene Purpose Template

Each scene needs clear purpose:

```
SCENE PURPOSE WORKSHEET
=======================
Scene Number: [X]
Primary Emotional Beat: [What audience should feel]
Source Metaphor/Line: "..."
Visual Translation: [What happens on screen]
Scene Function: [Setup / Development / Climax / Resolution]
Transition From: [Previous emotional state]
Transition To: [Next emotional state]
```

### 3.2 Time Progression Strategy

For short films, time management is critical:

**Linear Time:**
- Morning → Night (single day)
- Best for: Immediate emotional journey

**Compressed Time (Montage):**
- Days/weeks shown through visual markers
- Best for: Showing waiting, deterioration, obsession building

**Parallel Time:**
- Past and Present intercut
- Best for: Showing contrast between "before" and "after"

**Frozen Moment:**
- Single moment expanded
- Best for: Climactic emotional revelation

### 3.3 Building the Scene Sequence

Arrange scenes following short film structure:

```
OPENING (1-2 scenes): Establish situation and emotion
  - Show character in current state
  - Hint at absence/problem

DEVELOPMENT (3-5 scenes): Deepen understanding
  - Show repeated behaviors
  - Reveal relationship to absent person/thing
  - Build emotional intensity

TURNING POINT (1-2 scenes): Something shifts
  - Decision, realization, or external event
  - Emotional peak

RESOLUTION (1-2 scenes): Show change or acceptance
  - Final action that resolves or complicates
  - Emotional landing
```

---

## Worked Example

### Source Material (from diverse-content-gen sample)

**IDE 4: "LAUT YANG MEMBEKU"**
```
"Kau datang seperti pelaut yang tidak takut dosa maupun badai..."
"Dan aku menyerahkan diri sebagai laut itu sendiri..."
"Tapi sekarang kau menghilang. Dan aku—laut yang tadinya hidup—kini membeku."
```

### Phase 1: Deconstruction

**Emotional Beats:**
1. Surrender/devotion ("menyerahkan diri")
2. Fullness when together ("menopang kapalmu")
3. Frozen emptiness now ("laut yang membeku")
4. Desperate hope ("kembalilah")

**Metaphor Types:**
- Identity: "Aku menjadi laut" → Show her relationship with water/sea
- Relationship: "Pelaut/Laut" → Power dynamic of sea serving sailor
- State: "Membeku" → Visual coldness, stillness, waiting

### Phase 2: Visual Translation

**"What Would They Actually Do?"**

For "laut yang membeku" (frozen sea waiting for sailor):
- Return to the sea/beach repeatedly
- Stand at water's edge staring at horizon
- Keep something of his at the water
- Physical stillness, almost frozen herself

**Object Selection:**
- His jacket (warmth, presence, something she can hold)
- The horizon (where he disappeared, where she looks)
- The shoreline (boundary between her world and where he went)

**Location Selection:**
- Beach at dawn (cold, waiting, liminal time)
- Her room (contrast: warmth vs. cold beach)

### Phase 3: Scene Construction

```
SCENE 1: THE FROZEN MORNING
Location: Beach, dawn
Time: Early morning, cold
Action: Woman walks to shoreline, wearing oversized jacket (his). 
        Stands at water's edge, perfectly still. Stares at horizon.
Key Visuals: Gray sea, pale dawn light, her breath visible, his jacket
Emotional Beat: Established waiting, established cold/frozen state
Story Logic: "Laut yang membeku" = she is frozen at the sea, waiting

SCENE 2: THE RITUAL
Location: Beach, dawn (different day - slightly different light)
Time: Another morning
Action: Same woman, same spot. This time she brings a thermos.
        Pours coffee. Leaves a cup at the water's edge. 
        The tide takes it.
Key Visuals: Two cups, one for her, one offered to the sea
Emotional Beat: Ritual worship, offering to absent beloved
Story Logic: "Altar pribadi" translated to literal offering ritual

SCENE 3: THE COLLECTION
Location: Her room, evening
Time: After beach visits
Action: Camera reveals objects on windowsill: shells, sea glass, 
        a piece of driftwood. Each collected from the shore.
        She adds today's find. Looks out window toward unseen sea.
Key Visuals: Shrine-like arrangement, window facing sea direction
Emotional Beat: Obsession visualized, devotion continuing at home
Story Logic: "Menjadikanmu satu-satunya pusat semesta" = altar at home

SCENE 4: TIME PASSES
Location: Beach, various times
Time: Montage - different weather, light
Action: Quick cuts: Her at the same spot. Rain. Sun. Fog. 
        Always the same position. Always waiting.
Key Visuals: Same framing, changing conditions, unchanging devotion
Emotional Beat: Time's passage doesn't change her; she's frozen
Story Logic: "Menunggu pelaut yang tidak kembali" = time means nothing

SCENE 5: THE JACKET
Location: Beach, dawn
Time: Morning
Action: She arrives. Removes the jacket. Folds it carefully. 
        Places it on the sand above tide line. 
        Steps back. Waits.
Key Visuals: Jacket alone on sand, her standing further back
Emotional Beat: Offering more of herself, or letting go?
Story Logic: "Dengan tulang yang patah pun tidak apa-apa" = 
             she'd accept anything, she's releasing claim

SCENE 6: RESOLUTION
Location: Beach, dawn
Time: Same morning, later
Action: She looks back once at the jacket. 
        Turns. Walks away. 
        We hold on the jacket and the sea.
Key Visuals: Empty jacket, empty frame, only sea and sand
Emotional Beat: Ambiguous ending - release or defeat?
Story Logic: "Kembalilah" - invitation left, she cannot wait forever
             but she cannot truly leave either
```

### Story Logic Map

| Original Metaphor | Emotional Core | Visual Translation | Why It Works |
|-------------------|----------------|-------------------|--------------|
| "Laut yang membeku" | Frozen in waiting | Woman stands motionless at shore daily | Stillness shows internal paralysis |
| "Pelaut yang tidak kembali" | Waiting for return | Looking at horizon where ship would appear | Universal image of waiting for sailors |
| "Altar pribadi" | Worship/devotion | Shrine arrangement + offering ritual | Religious imagery made literal |
| "Kembalilah" | Desperate invitation | Leaving jacket as "come back to this" | Physical artifact of hope left behind |

---

## Common Transformation Patterns

### Pattern: Daily Ritual = Devotion
Use repeated actions in same location to show obsessive devotion

### Pattern: Empty Space = Absence
Frame shots to emphasize where person SHOULD be but isn't

### Pattern: Object as Proxy = Continued Connection
Character interacts with object belonging to absent person as if person is present

### Pattern: Weather = Emotional State
Match environmental conditions to internal state (frozen beach = frozen heart)

### Pattern: Threshold = Decision Point
Doorways, shorelines, windows = character at point of change
