# Visual Vocabulary Reference

Quick-reference guide for common metaphor→visual translations.

---

## Emotion → Action Mappings

### LONGING / WAITING

| Metaphor Pattern | Visual Action |
|------------------|---------------|
| "Waiting for return" | Character looks out window/door repeatedly |
| "Counting the days" | Calendar marked, objects accumulated by time |
| "Life paused" | Frozen activities (meal untouched, book open, task incomplete) |
| "Only half alive" | Character in dim lighting, minimal movement |

**Props:** Windows, doors, watches/clocks, phones, empty chairs

### GRIEF / LOSS

| Metaphor Pattern | Visual Action |
|------------------|---------------|
| "Empty without you" | Character in spaces too large for them |
| "Presence lingers" | Untouched belongings, unused objects |
| "Cannot move on" | Character unable to change environment |
| "Ghost of memory" | Character speaks to empty space, sets extra place |

**Props:** Photos, clothing, shared items, empty spaces at tables

### DEVOTION / WORSHIP

| Metaphor Pattern | Visual Action |
|------------------|---------------|
| "You are my god" | Character positions lower, looks up at other |
| "I worship you" | Ritual behaviors, shrine-like arrangements |
| "My whole world" | Other person center-framed, character at edges |
| "I live for you" | Character's space reflects other's preferences |

**Props:** Candles, arranged objects, elevated positions, lighting

### OBSESSION

| Metaphor Pattern | Visual Action |
|------------------|---------------|
| "Cannot stop thinking" | Repetitive actions, checking behaviors |
| "Consumed by you" | Deteriorating self-care, focus only on other |
| "You're everywhere" | Multiple images of person, constant reminders |
| "I collect pieces of you" | Gathering objects, hoarding mementos |

**Props:** Collections, repeated images, neglected personal items

### ABANDONMENT / FEAR

| Metaphor Pattern | Visual Action |
|------------------|---------------|
| "Afraid you'll leave" | Character keeps checking, startles at sounds |
| "Alone in darkness" | Character in shadows, reaching toward light |
| "No one to hold me" | Self-comforting gestures, pillow-clutching |
| "Left behind" | Character in empty spaces, doors closing |

**Props:** Lights left on, doors, empty hands, self-embrace

---

## Element Metaphors → Visual Settings

### SEA / WATER

| Metaphor | Visual Translation |
|----------|---------------------|
| "I am the sea" | Character at shoreline, immersed in water |
| "Drowning in you" | Character submerged, overwhelmed |
| "Frozen sea" | Winter beach, ice, stillness at water |
| "Waiting for ship" | Horizon-gazing, lighthouse imagery |
| "Storm of emotion" | Turbulent water, wind, rain at coast |

**Best locations:** Beach, harbor, pier, lakeside, bathroom (intimate water)

### FIRE / HEAT

| Metaphor | Visual Translation |
|----------|---------------------|
| "Burning for you" | Character near flames, warm lighting |
| "Consumed by passion" | Fire imagery, destructive heat |
| "Warmth of love" | Candlelight, fireplace, warm colors |
| "Ashes of love" | Cold hearth, burned objects, gray aftermath |

**Best locations:** Fireplace, candle-lit rooms, burned spaces

### ICE / COLD

| Metaphor | Visual Translation |
|----------|---------------------|
| "Heart frozen" | Character in cold environment, breath visible |
| "Cold without you" | Empty bed, character shivering |
| "Thaw of feeling" | Ice melting, warm light entering |
| "Numb" | Character still, unresponsive to environment |

**Best locations:** Winter exteriors, cold interiors, empty beds

### EARTH / GROUND

| Metaphor | Visual Translation |
|----------|---------------------|
| "Grounded in you" | Character rooted, stable when together |
| "World crumbling" | Unstable surfaces, things falling |
| "Buried feelings" | Character digging, covering things |
| "Taking root" | Character staying in place, growing around |

**Best locations:** Gardens, graves, foundations, earthy interiors

---

## Time-Based Metaphors

| Metaphor | Visual Technique |
|----------|------------------|
| "Time stopped" | Frozen frame, clock imagery, unchanged scene |
| "Days blur together" | Montage of similar actions, overlapping days |
| "Living in the past" | Flashbacks, sepia tones, old photographs |
| "Future without you" | Empty spaces, unpopulated futures |
| "Every second" | Close-ups on clock, counting actions |

---

## Body-Based Metaphors

| Metaphor | Visual Action |
|----------|---------------|
| "Cannot breathe" | Character gasping, hand to chest |
| "Heart breaking" | Hand over heart, physical pain response |
| "Tears I hide" | Wiping eyes quickly, turned away |
| "Heavy burden" | Slouched posture, weighted movement |
| "Cannot stand" | Sitting, leaning, collapsing |
| "Reaching for you" | Outstretched hand to empty space |

---

## Spatial Metaphors

| Metaphor | Visual Framing |
|----------|----------------|
| "Distance between us" | Wide shot, characters at frame edges |
| "You fill my world" | Close-up of other person, cramped framing |
| "Empty space" | Character small in large frame |
| "Trapped" | Tight framing, enclosed spaces |
| "Free" | Open spaces, wide horizons |
| "Looking down/up at you" | Camera angle reflecting power dynamic |

---

## Quick Translation Checklist

When converting metaphor to visual:

1. **What emotion?** (longing, grief, devotion, obsession, fear)
2. **What element?** (sea, fire, ice, earth, air)
3. **What action?** (waiting, worshipping, searching, preserving)
4. **What object?** (belonging, shared item, barrier, connection)
5. **What setting?** (where would this emotion be felt most?)
6. **What time?** (dawn for hope, night for fear, dusk for endings)

---

## Indonesian-Specific Metaphors

Common patterns in Indonesian emotional expression:

| Pattern | Visual Approach |
|---------|-----------------|
| "Seprai yang membeku" | Empty bed, cold morning light |
| "Altar pribadi" | Shrine-like arrangement of belongings |
| "Pelaut dan laut" | Shore waiting, horizon gazing |
| "Pusat semesta" | Other person center-framed, light source |
| "Tidak bisa bernapas" | Closed spaces, gasping, window-seeking |
| "Pulang" | Door-watching, path to home imagery |
