---
name: thread-pro
description: |
  Transform boring AI writing into viral threads with strong hooks and relatable voice.
  USE WHEN: User asks to write threads, create viral content, transform content into threads,
  or mentions "thread about [topic]". Target platforms: X/Twitter and Threads.
  TRIGGERS: write thread, create thread, thread about, viral thread, make this a thread, thread-pro
---

# Thread Pro: From Boring AI to Viral Relatability

Transform generic AI writing into threads that people actually want to read.

## Core Philosophy

**The Problem:** AI writes like a polite robot. Perfect grammar, smooth transitions, zero personality.

**The Solution:** Inject humanity through specificity, tension, and imperfect authenticity.

## Transformation Process

### Step 1: Identify the Core Value

Before writing, answer:
- What's the ONE thing readers will take away?
- Why should they care RIGHT NOW?
- What would make them screenshot this?

### Step 2: Apply the Hook Formula

Choose from these proven hook types (see `references/hook-formulas.md`):

| Hook Type | When to Use | Example |
|-----------|-------------|---------|
| **Specificity** | Numbers, results | "I gained 12,847 followers in 63 days" |
| **Bold Claim** | Contrarian take | "Most Twitter advice will kill your growth" |
| **Curiosity Gap** | Hidden secrets | "The real reason VCs rejected me 47 times" |
| **Story** | Personal journey | "A year ago I was broke. Today I sold my company" |
| **Mistake** | Learning from failure | "I lost $50K because of one stupid assumption" |

### Step 3: Kill AI Patterns

**NEVER use these (instant AI detection):**
- "Delve", "dive into", "unpack"
- "In today's fast-paced world"
- "It's important to note that"
- "Moreover", "Furthermore", "Additionally" (at start)
- "Robust", "leverage", "synergy"
- "Let's explore", "Let me share"
- Perfect parallel structure in every list
- Generic examples ("a local coffee shop")

**REPLACE with:**
- Specific names, dates, places
- Conversational fragments
- Occasional grammatical "imperfections"
- First-person opinions
- Real numbers (even if messy: "$47.3K" not "$50K")

Full list: `references/anti-ai-patterns.md`

### Step 4: Structure the Thread

**Tweet 1: Hook** (most important)
- Pattern interrupt
- Specific promise
- Curiosity gap
- End with "🧵" or "Thread:"

**Tweet 2-3: Context/Credibility**
- Why should they trust you?
- Brief background
- Set up the tension

**Tweet 4-8: Value Delivery**
- One idea per tweet
- Short sentences
- Line breaks for mobile
- Mix lengths (burstiness)

**Tweet 9-10: Payoff + CTA**
- Deliver the promise
- Summarize key takeaway
- Clear call-to-action

### Step 5: Voice Injection

Make it sound human by adding:

**Specificity over generality:**
- ❌ "I worked at a tech company"
- ✅ "I worked at Stripe. 3rd floor. Desk by the window"

**Emotional honesty:**
- ❌ "It was challenging"
- ✅ "I cried in my car. Twice"

**Casual connectors:**
- "Here's the thing—"
- "But wait."
- "Plot twist:"
- "Real talk:"
- "Honestly?"

**Imperfect structure:**
- One-word sentences. Yes.
- Incomplete thoughts that—
- Questions that make you think?

Full guide: `references/voice-injection.md`

## Thread Templates

### Template A: Transformation Story
```
[Hook: Where you are now vs then]
[Context: The struggle]
[Turning point: What changed]
[3-5 lessons learned]
[Payoff: The result]
[CTA: Follow for more]
```

### Template B: Listicle with Tension
```
[Hook: Surprising number + promise]
[Why this matters]
[Items 1-7 with micro-hooks]
[The unexpected one]
[Summary + CTA]
```

### Template C: Contrarian Take
```
[Hook: Bold disagreement]
[Why everyone is wrong]
[Your alternative view]
[Evidence/story]
[The real lesson]
[CTA]
```

More templates: `references/thread-structures.md`

## Quick Checklist

Before publishing, verify:
- [ ] Hook stops the scroll in 3 seconds?
- [ ] Zero AI buzzwords?
- [ ] At least ONE specific detail (name, number, place)?
- [ ] Sentence length varies (burstiness)?
- [ ] Mobile-friendly (short lines)?
- [ ] Clear CTA at the end?
- [ ] Would YOU screenshot this?

## Resources

- `references/hook-formulas.md` - 10 detailed hook templates with examples
- `references/anti-ai-patterns.md` - Complete list of words/phrases to avoid
- `references/thread-structures.md` - Full thread templates for different content types
- `references/voice-injection.md` - Humanization techniques and persona guidelines
