# Anti-AI Patterns: What to Avoid

Words and phrases that instantly flag content as AI-generated.

**Contents:**
- [Tier 1: Instant Detection](#tier-1-instant-detection-never-use)
- [Tier 2: High Suspicion](#tier-2-high-suspicion-use-sparingly)
- [Tier 3: Structural Red Flags](#tier-3-structural-red-flags)
- [Replacement Guide](#replacement-guide)
- [The 3-Second Test](#the-3-second-test)

## Tier 1: Instant Detection (Never Use)

### Transition Words at Sentence Start
- "Moreover"
- "Furthermore"
- "Additionally"
- "Subsequently"
- "Consequently"
- "Nevertheless"
- "Nonetheless"

### Corporate Buzzwords
- "Delve" / "delve into"
- "Robust"
- "Leverage"
- "Synergy" / "synergize"
- "Innovative" / "innovation"
- "Cutting-edge"
- "Game-changer"
- "Best-in-class"
- "Holistic approach"

### AI Opener Clichés
- "In today's fast-paced world"
- "In the ever-evolving landscape"
- "In this digital age"
- "It's important to note that"
- "It's worth mentioning that"
- "Let's dive in" / "Let's explore"
- "Let me share"
- "I'd be happy to help"

### Hedging Language
- "It could be said that"
- "One might argue"
- "Perhaps it's worth considering"
- "It seems that"
- "Arguably"

## Tier 2: High Suspicion (Use Sparingly)

### Overly Formal Connectors
- "Therefore"
- "Thus"
- "Hence"
- "Accordingly"
- "In conclusion"
- "To summarize"

### Vague Intensifiers
- "Very"
- "Really"
- "Extremely"
- "Incredibly"
- "Absolutely"

### Generic Phrases
- "A wide range of"
- "Various aspects of"
- "Numerous factors"
- "A multitude of"
- "Myriad"

## Tier 3: Structural Red Flags

### Perfect Parallelism
AI loves perfectly parallel lists:
- ❌ "Increase productivity. Boost creativity. Enhance efficiency."
- ✅ "You'll get more done. Ideas come easier. And yeah, less burnout."

### Uniform Paragraph Length
AI generates paragraphs of similar length. Mix it up:
- One-liner paragraphs
- Then maybe 3 sentences
- Followed by something longer when needed

### Flawless Grammar
Perfect grammar = suspicious. Real people:
- Start sentences with "And" or "But"
- Use fragments. Like this.
- End sentences with prepositions if they want to

### Generic Examples
- ❌ "a local coffee shop"
- ❌ "a tech startup"
- ❌ "a small business owner"
- ✅ "that café on 5th Street with the weird cat paintings"
- ✅ "when I was at Stripe"
- ✅ "my friend Sarah who runs a bakery in Austin"

## Replacement Guide

| Instead of... | Write... |
|---------------|----------|
| "It's important to note" | Just state it directly |
| "Moreover" | "And" or "Plus" or nothing |
| "Leverage" | "Use" |
| "Robust" | "Strong" or "solid" |
| "In conclusion" | "So here's the thing:" |
| "Various" | Specific number |
| "Delve into" | "Look at" or just dive in |
| "Innovative" | Show, don't tell |

## The 3-Second Test

Read your thread aloud. If it sounds like:
- A LinkedIn corporate post → Rewrite
- A Wikipedia article → Rewrite
- Something your friend would text you → Ship it
