# Hook Formulas That Stop the Scroll

10 proven hook templates based on analysis of 1000+ viral threads.

**Contents:**
1. [Specificity Hook](#1-the-specificity-hook)
2. [Bold Claim Hook](#2-the-bold-claim-hook)
3. [Curiosity Gap Hook](#3-the-curiosity-gap-hook)
4. [Story Hook](#4-the-story-hook)
5. [Mistake Hook](#5-the-mistake-hook)
6. [List Promise Hook](#6-the-list-promise-hook)
7. [Pattern Interrupt Hook](#7-the-pattern-interrupt-hook)
8. [How-To Promise Hook](#8-the-how-to-promise-hook)
9. [Authority Hook](#9-the-authority-hook)
10. [Most People Wrong Hook](#10-the-most-people-get-this-wrong-hook)

## 1. The Specificity Hook

**Formula:** "I [achieved specific result with exact numbers] in [precise timeframe]. Here's the [X]-step system:"

**Examples:**
- "I gained 12,847 followers in 63 days. Here's the 5-step system:"
- "I went from $0 to $127K MRR in 9 months. Here's how:"
- "I read 147 books this year. These 7 changed everything:"

**Why it works:** Specific numbers = credibility. Vague claims get ignored.

## 2. The Bold Claim Hook

**Formula:** "[Controversial statement that challenges conventional wisdom]. Here's the proof:"

**Examples:**
- "Most Twitter advice will kill your growth. Here's the proof:"
- "College is a waste of time for 80% of students. Fight me."
- "Cold email is dead. Here's what's replacing it:"

**Why it works:** Controversy triggers emotional response. People need to agree or disagree.

## 3. The Curiosity Gap Hook

**Formula:** "The [hidden/secret/real] reason [unexpected outcome]. [Tease without revealing]:"

**Examples:**
- "The real reason VCs rejected me 47 times (it wasn't my product):"
- "Why I turned down a $2M offer. Most people think I'm insane:"
- "The secret behind every viral thread (nobody talks about this):"

**Why it works:** Incomplete information creates tension. Brain wants resolution.

## 4. The Story Hook

**Formula:** "[Time ago], I was [bad situation]. Today, [good situation]. Here's what happened:"

**Examples:**
- "A year ago I was broke, living on my friend's couch. Today I run a 7-figure business."
- "6 months ago I couldn't run a mile. Yesterday I finished my first marathon."
- "In 2019 I got fired. Best thing that ever happened to me. Here's why:"

**Why it works:** Transformation creates hope. People want the blueprint.

## 5. The Mistake Hook

**Formula:** "I [lost/failed/wasted] [specific thing] because of [one stupid reason]. Don't make my mistake:"

**Examples:**
- "I lost $50K because of one stupid assumption. Don't make my mistake:"
- "I wasted 2 years building the wrong product. Here's the sign I ignored:"
- "I got fired for a Tweet. Here's what I learned:"

**Why it works:** Failure = relatability. Success stories feel distant. Failures feel human.

## 6. The List Promise Hook

**Formula:** "[Number] [things] that will [specific benefit]. (Save this):"

**Examples:**
- "7 tools that will 10x your productivity. (Bookmark this):"
- "12 books that made me $1M. Thread:"
- "5 skills that took me 10 years to learn. Master them in 10 minutes:"

**Why it works:** Lists are skimmable. Bookmarks = algorithmic signal.

## 7. The Pattern Interrupt Hook

**Formula:** "[Unexpected opening that breaks normal scroll pattern]"

**Examples:**
- "Stop." (single word)
- "Delete LinkedIn. Hear me out:"
- "🚨 This might get me cancelled but:"
- "I'm about to share something I've never told anyone:"

**Why it works:** Breaks expected patterns. Brain pays attention to anomalies.

## 8. The How-To Promise Hook

**Formula:** "How to [achieve desirable outcome] without [common pain point]:"

**Examples:**
- "How to build a $10K/month business without quitting your job:"
- "How to get 10,000 followers without posting every day:"
- "How to learn any skill in 30 days (step-by-step):"

**Why it works:** Removes objection upfront. Shows you understand their resistance.

## 9. The Authority Hook

**Formula:** "I [did impressive thing that establishes credibility]. Here's what I learned:"

**Examples:**
- "I spent 10 years as a Netflix algorithm engineer. Here's how recommendations actually work:"
- "I've interviewed 500+ candidates at Google. These 3 things get you rejected instantly:"
- "I built 7 startups (4 failed, 3 exited). Here's the pattern I noticed:"

**Why it works:** Credibility first, then value. People trust experience over theory.

## 10. The "Most People Get This Wrong" Hook

**Formula:** "Most people think [common belief]. They're wrong. Here's why:"

**Examples:**
- "Most people think luck is random. They're wrong. Here's the formula:"
- "Everyone says 'follow your passion.' Terrible advice. Here's what to do instead:"
- "The productivity hack everyone uses? It's destroying your focus. Here's proof:"

**Why it works:** Positions you as having insider knowledge. Creates "wait, what?" moment.

---

## Quick Reference: Hook Selection

| Goal | Best Hook Types |
|------|-----------------|
| Share a lesson | Story, Mistake |
| Establish authority | Authority, Specificity |
| Share tips/tools | List Promise, How-To |
| Challenge status quo | Bold Claim, "Most People Wrong" |
| Create intrigue | Curiosity Gap, Pattern Interrupt |
