# Thread Structures: Templates for Every Content Type

Copy-paste frameworks for different thread goals.

**Contents:**
- [Structure 1: Transformation Story](#structure-1-transformation-story-8-10-tweets)
- [Structure 2: Listicle](#structure-2-listicle-7-12-tweets)
- [Structure 3: Contrarian Take](#structure-3-contrarian-take-6-8-tweets)
- [Structure 4: How-To Guide](#structure-4-how-to-guide-8-10-tweets)
- [Structure 5: Mistake/Failure Story](#structure-5-mistakefailure-story-7-9-tweets)
- [Structure 6: Framework/Model](#structure-6-frameworkmodel-6-8-tweets)
- [Quick Selection Guide](#quick-selection-guide)

## Structure 1: Transformation Story (8-10 tweets)

Best for: Personal journeys, before/after, lessons learned

```
TWEET 1 (Hook)
[Time ago] I was [bad situation].
Today, [impressive result].
Here's what changed: 🧵

TWEET 2 (Context)
[Set the scene with specific detail]
[Make reader feel the pain]

TWEET 3 (Rock bottom)
The worst moment:
[Specific story with emotion]

TWEET 4 (Turning point)
Then [something changed].
[What/who triggered it]

TWEET 5-7 (Lessons)
Lesson 1: [Actionable insight]
[Brief explanation]

TWEET 8 (Payoff)
Now?
[Current state with proof]

TWEET 9 (CTA)
If this helped, repost the first tweet.
Follow @handle for more.
```

---

## Structure 2: Listicle (7-12 tweets)

Best for: Tools, tips, resources, frameworks

```
TWEET 1 (Hook)
[Number] [things] that [benefit].
(Bookmark this): 🧵

TWEET 2 (Why it matters)
[Brief context on why this list is valuable]

TWEET 3-9 (Items)
[Number]. [Item name]

[What it does]
[Why it's special]
[Specific example or stat]

TWEET 10 (Surprise item)
Bonus: [Unexpected addition]
This one's underrated.

TWEET 11 (Summary)
Quick recap:
• Item 1
• Item 2
• ...

TWEET 12 (CTA)
Found this useful?
Repost to help others.
Follow for more [topic].
```

---

## Structure 3: Contrarian Take (6-8 tweets)

Best for: Hot takes, challenging conventions, thought leadership

```
TWEET 1 (Hook)
[Popular belief] is wrong.
Here's why: 🧵

TWEET 2 (Acknowledge the norm)
Everyone says [common advice].
I believed it too.

TWEET 3 (The problem)
But here's what they don't tell you:
[Counterpoint with evidence]

TWEET 4-5 (Your alternative)
What actually works:
[Your approach]
[Why it's better]

TWEET 6 (Proof)
The results?
[Specific outcome]

TWEET 7 (Nuance)
Caveat: [When the old advice IS valid]
Context matters.

TWEET 8 (CTA)
Agree? Disagree?
Reply with your take.
Follow for more unconventional advice.
```

---

## Structure 4: How-To Guide (8-10 tweets)

Best for: Tutorials, step-by-step processes, skill building

```
TWEET 1 (Hook)
How to [achieve result] without [pain point]:
(Step-by-step) 🧵

TWEET 2 (Pre-step)
Before we start:
[One prerequisite or mindset shift]

TWEET 3-8 (Steps)
Step [N]: [Action]

[How to do it]
[Common mistake to avoid]
[Pro tip]

TWEET 9 (Results preview)
If you follow this:
[Expected outcome with timeframe]

TWEET 10 (CTA)
Save this for later.
Follow @handle for more [topic] guides.
```

---

## Structure 5: Mistake/Failure Story (7-9 tweets)

Best for: Cautionary tales, building trust, relatability

```
TWEET 1 (Hook)
I [lost/failed at] [specific thing].
Cost me [money/time/opportunity].
Here's what went wrong: 🧵

TWEET 2 (The setup)
[Context before the mistake]
Everything seemed fine.

TWEET 3 (The mistake)
My error:
[What you did wrong]
[Why you thought it was right]

TWEET 4-5 (The fallout)
What happened next:
[Consequences with specific details]

TWEET 6-7 (The lessons)
What I learned:
[Actionable takeaway]
[How to avoid this]

TWEET 8 (Recovery)
Now I [what you do differently].
Results: [outcome]

TWEET 9 (CTA)
Don't make my mistake.
Repost to warn others.
```

---

## Structure 6: Framework/Model (6-8 tweets)

Best for: Mental models, decision frameworks, methodologies

```
TWEET 1 (Hook)
The [framework name] that changed how I [benefit]:
🧵

TWEET 2 (Problem it solves)
Most people [common struggle].
This framework fixes that.

TWEET 3 (Overview)
The model:
[Visual or simple breakdown]

TWEET 4-6 (Components)
Part [N]: [Component name]
[What it means]
[How to apply it]

TWEET 7 (Example)
Real example:
[How you used this framework]
[Result]

TWEET 8 (CTA)
Try it this week.
Let me know how it goes.
Follow for more frameworks.
```

---

## Quick Selection Guide

| Content Type | Best Structure |
|--------------|----------------|
| Personal story | Transformation, Mistake |
| Tips/Tools | Listicle |
| Opinion piece | Contrarian |
| Tutorial | How-To Guide |
| Concept explanation | Framework |
| Case study | Transformation |
