# Voice Injection: Making AI Sound Human

Techniques to transform robotic text into relatable content.

**Contents:**
- [The Voice Spectrum](#the-voice-spectrum)
- [Technique 1: Specificity Injection](#technique-1-specificity-injection)
- [Technique 2: Emotional Honesty](#technique-2-emotional-honesty)
- [Technique 3: Sentence Rhythm](#technique-3-sentence-rhythm-burstiness)
- [Technique 4: Casual Connectors](#technique-4-casual-connectors)
- [Technique 5: Direct Address](#technique-5-direct-address)
- [Technique 6: Imperfect Grammar](#technique-6-imperfect-grammar)
- [Technique 7: The Friend Test](#technique-7-the-friend-test)

## The Voice Spectrum

```
ROBOTIC ←────────────────────────→ HUMAN

Corporate    Professional    Casual    Raw
LinkedIn     Newsletter      Twitter   DMs
```

For viral threads, aim for **Casual to Raw**.

## Technique 1: Specificity Injection

Replace vague with vivid.

| Vague (AI) | Specific (Human) |
|------------|------------------|
| "a tech company" | "Stripe, 3rd floor, desk by the fire exit" |
| "recently" | "last Tuesday at 2am" |
| "a lot of money" | "$47,832 (I still have the receipt)" |
| "many people" | "347 people (I counted)" |
| "for a while" | "for 3 years, 2 months, and 4 days" |

## Technique 2: Emotional Honesty

Say what you actually felt.

| Sanitized (AI) | Honest (Human) |
|----------------|----------------|
| "It was challenging" | "I cried in my car. Twice." |
| "I was nervous" | "My hands were shaking so bad I spilled coffee on my laptop" |
| "I felt proud" | "I screamed so loud my neighbor called the cops" |
| "I was uncertain" | "I had no fucking clue what I was doing" |

**Note:** Swearing is optional but adds authenticity when appropriate for your audience.

## Technique 3: Sentence Rhythm (Burstiness)

AI writes uniform sentences. Humans don't.

**AI Pattern:**
> "I started my business in 2019. I faced many challenges along the way. I learned valuable lessons from each experience. Today I run a successful company."

**Human Pattern:**
> "Started the business in 2019. Chaos. Absolute chaos. But I learned more in those first 6 months than in 4 years of college. Now? We're doing $2M ARR. Wild."

Mix:
- One-word sentences
- Fragments
- Long, flowing thoughts
- Questions?
- Exclamations!

## Technique 4: Casual Connectors

Replace formal transitions with conversational ones.

| Formal (AI) | Casual (Human) |
|-------------|----------------|
| "However" | "But here's the thing—" |
| "Therefore" | "So" |
| "Additionally" | "Oh, and" |
| "In conclusion" | "Bottom line?" |
| "For example" | "Like this:" |
| "It should be noted" | "Real talk:" |

## Technique 5: Direct Address

Talk TO the reader, not AT them.

| Distant (AI) | Direct (Human) |
|--------------|----------------|
| "One might consider" | "You need to try this" |
| "Users can benefit from" | "This will save you hours" |
| "It is advisable to" | "Do this. Seriously." |
| "Readers should note" | "Here's what most people miss:" |

## Technique 6: Imperfect Grammar

Perfect grammar = AI flag. Real people:

- Start sentences with "And" or "But"
- Use fragments. Often.
- End with prepositions (who cares)
- Skip articles sometimes ("Started company in 2019")
- Use run-on sentences when excited about something because honestly who stops to punctuate when they're on a roll

## Technique 7: The "Friend Test"

Before posting, ask:
> "Would I text this to a friend?"

If no → too formal
If yes → ship it

## Voice Quick Reference

| Element | AI Default | Human Override |
|---------|------------|----------------|
| Numbers | Round ($50K) | Precise ($47.3K) |
| Examples | Generic | Named/specific |
| Emotions | Sanitized | Raw |
| Sentences | Uniform | Varied |
| Grammar | Perfect | Intentionally flawed |
| Transitions | Formal | Casual |
| Perspective | Third person | Second person (you) |

## The 30-Second Voice Check

Read your thread aloud. Check for:

1. **Sounds like a textbook?** → Add personality
2. **All same sentence length?** → Mix it up
3. **No specific details?** → Add names/numbers
4. **No emotion?** → What did you FEEL?
5. **Would feel weird texting this?** → Too formal
