# BusinessPlan Workflow

Create comprehensive, investor-ready business plans.

## Information Gathering

Before writing, establish:

### The Business
1. **What problem are you solving?** (Customer pain point)
2. **What's your solution?** (Product/service description)
3. **Who's your customer?** (Target segment, buyer persona)
4. **What's your business model?** (How you make money)
5. **What stage are you at?** (Idea, MVP, revenue, scaling)

### The Market
1. **Market size** (TAM/SAM/SOM)
2. **Growth rate** (Historical and projected)
3. **Key trends** (Tailwinds and headwinds)
4. **Competitive landscape** (Direct and indirect)

### The Financials
1. **Current revenue** (if any)
2. **Cost structure** (Fixed vs variable)
3. **Funding to date** (Sources and amounts)
4. **Funding needs** (Amount and use of proceeds)

## Business Plan Structure

### 1. Executive Summary (1 page)
- Problem statement (2-3 sentences)
- Solution overview (2-3 sentences)
- Target market and size
- Business model summary
- Traction to date
- Team highlights
- Funding ask and use

### 2. Problem & Opportunity (1-2 pages)
- Customer pain point with specifics
- Current alternatives and their shortcomings
- Market size with methodology
- Why now? (Timing factors)

### 3. Solution (1-2 pages)
- Product/service description
- Key features and benefits
- Technology or IP (if relevant)
- Development roadmap

### 4. Market Analysis (2-3 pages)
- TAM/SAM/SOM with calculations
- Customer segmentation
- Competitive landscape (matrix format)
- Positioning and differentiation

### 5. Business Model (1-2 pages)
- Revenue streams
- Pricing strategy with rationale
- Unit economics
- Sales and distribution channels

### 6. Go-to-Market Strategy (1-2 pages)
- Launch plan
- Customer acquisition strategy
- Marketing channels and tactics
- Partnership opportunities

### 7. Operations Plan (1-2 pages)
- Key activities and processes
- Technology requirements
- Supplier/vendor relationships
- Facilities and equipment

### 8. Team (1 page)
- Founder backgrounds
- Key hires needed
- Advisory board
- Org chart

### 9. Financial Projections (3-5 pages)
- Assumptions summary
- 3-5 year P&L projection
- Cash flow projection
- Balance sheet projection
- Key metrics dashboard
- Funding requirements and milestones

### 10. Risk Analysis (1 page)
- Key risks identified
- Mitigation strategies
- Scenario analysis summary

### 11. Appendices
- Detailed financial model
- Market research sources
- Technical specifications
- Letters of intent/customer testimonials

## Financial Projection Guidelines

### Revenue Build-Up
- Start with drivers (users, transactions, deals)
- Apply conversion rates
- Apply pricing
- Build monthly for Year 1, quarterly for Years 2-3

### Cost Structure
**Fixed Costs:**
- Salaries and benefits
- Rent and facilities
- Software and tools
- Insurance and professional fees

**Variable Costs:**
- COGS (direct costs of delivery)
- Sales commissions
- Payment processing
- Customer support (scaled)

### Key Metrics to Include
- Monthly Recurring Revenue (MRR) growth
- Customer Acquisition Cost (CAC)
- Lifetime Value (LTV)
- LTV:CAC ratio (target 3:1+)
- Payback period
- Gross margin
- Burn rate and runway

## Output Format

Deliver in sections that can be:
1. Combined into full document
2. Used individually for specific purposes
3. Exported to Word/PDF via MSOffice skill

## Quality Checklist

- [ ] Executive summary stands alone
- [ ] All claims backed by data or logic
- [ ] Financial projections internally consistent
- [ ] Competitive analysis is honest (not dismissive)
- [ ] Risks acknowledged with mitigations
- [ ] Clear ask and use of funds
- [ ] Team gaps acknowledged
