# MarketAnalysis Workflow

Comprehensive market sizing, competitive intelligence, and opportunity assessment.

## Market Sizing Framework

### TAM/SAM/SOM Methodology

**Total Addressable Market (TAM)**
- Everyone who could potentially buy your product
- Global or regional depending on scope
- Methods: Top-down (industry reports) or bottom-up (unit × price × buyers)

**Serviceable Addressable Market (SAM)**
- Portion of TAM you can realistically reach
- Constrained by: geography, segments, channels, capabilities
- Should be 10-40% of TAM typically

**Serviceable Obtainable Market (SOM)**
- What you can capture in 3-5 years
- Based on: competition, growth rate, sales capacity
- Should be 1-10% of SAM typically

### Calculation Approaches

**Top-Down**
```
Industry Revenue (from reports)
× % relevant segment
× % accessible geography
= TAM

TAM × % reachable segment = SAM
SAM × realistic market share = SOM
```

**Bottom-Up (More Credible)**
```
Number of potential customers
× Average contract value
× Purchase frequency
= TAM

Apply realistic constraints = SAM
Apply competitive dynamics = SOM
```

## Competitive Analysis Framework

### Competitor Identification

**Direct Competitors**
- Same product, same customer, same problem

**Indirect Competitors**
- Different product, same customer, same problem

**Substitutes**
- Customer could solve problem another way (including doing nothing)

### Competitive Matrix Template

| Criteria | Weight | You | Comp A | Comp B | Comp C |
|----------|--------|-----|--------|--------|--------|
| Price | 20% | | | | |
| Features | 25% | | | | |
| Ease of Use | 15% | | | | |
| Support | 10% | | | | |
| Brand | 15% | | | | |
| Integration | 15% | | | | |
| **Weighted Total** | 100% | | | | |

Score 1-5 for each, multiply by weight.

### Competitor Deep Dive Questions

For each key competitor:
1. **Positioning**: How do they describe themselves?
2. **Target Customer**: Who are they selling to?
3. **Pricing**: What do they charge? Model?
4. **Strengths**: What are they good at?
5. **Weaknesses**: Where do they fail?
6. **Trajectory**: Growing, flat, declining?
7. **Funding/Resources**: How well-resourced?
8. **Strategy**: Where are they heading?

## Porter's Five Forces Analysis

### 1. Competitive Rivalry (High/Medium/Low)
- Number of competitors
- Industry growth rate
- Product differentiation
- Exit barriers
- Fixed costs structure

### 2. Threat of New Entrants (High/Medium/Low)
- Capital requirements
- Economies of scale
- Access to distribution
- Regulatory barriers
- Brand loyalty

### 3. Bargaining Power of Suppliers (High/Medium/Low)
- Supplier concentration
- Switching costs
- Threat of forward integration
- Importance of volume to supplier

### 4. Bargaining Power of Buyers (High/Medium/Low)
- Buyer concentration
- Switching costs
- Price sensitivity
- Threat of backward integration

### 5. Threat of Substitutes (High/Medium/Low)
- Availability of substitutes
- Price-performance trade-off
- Switching costs
- Buyer propensity to switch

## Market Trends Analysis

### PESTEL Framework

| Factor | Current State | Future Direction | Impact |
|--------|---------------|------------------|--------|
| **P**olitical | | | |
| **E**conomic | | | |
| **S**ocial | | | |
| **T**echnological | | | |
| **E**nvironmental | | | |
| **L**egal | | | |

### Trend Categories to Research

1. **Demand Drivers**: What's increasing need for this solution?
2. **Technology Shifts**: What's enabling new approaches?
3. **Regulatory Changes**: What's required or restricted?
4. **Customer Behavior**: How are buying patterns changing?
5. **Competitive Dynamics**: Market consolidation? New entrants?

## Research Sources

### Primary Sources
- Customer interviews
- Expert calls (GLG, AlphaSights)
- Industry events and conferences
- Sales team feedback

### Secondary Sources
- Industry reports (IBISWorld, Statista, Gartner)
- Company filings (SEC, Companies House)
- News and press releases
- Academic research
- Government statistics

### Competitor Intelligence
- Website and product analysis
- Pricing pages (use Wayback Machine for history)
- Job postings (indicate strategy)
- LinkedIn for team/hiring
- Review sites (G2, Capterra, Trustpilot)
- App Store reviews
- Patent filings

## Output Template

```
📈 MARKET ANALYSIS: [Market/Industry]
Date: [Analysis Date]

═══════════════════════════════════════
MARKET SIZE
═══════════════════════════════════════
TAM: £X.XB - [Methodology and sources]
SAM: £X.XM - [Constraints applied]
SOM: £X.XM - [Assumptions]

Growth Rate: X% CAGR (20XX-20XX)

═══════════════════════════════════════
MARKET DYNAMICS
═══════════════════════════════════════
Key Drivers:
• [Driver 1]
• [Driver 2]

Key Headwinds:
• [Headwind 1]
• [Headwind 2]

═══════════════════════════════════════
COMPETITIVE LANDSCAPE
═══════════════════════════════════════
Market Structure: [Fragmented/Consolidated/Oligopoly]

Key Players:
1. [Company] - X% share - [Positioning]
2. [Company] - X% share - [Positioning]
3. [Company] - X% share - [Positioning]

═══════════════════════════════════════
PORTER'S FIVE FORCES
═══════════════════════════════════════
Competitive Rivalry:    [High/Med/Low] - [Why]
New Entrant Threat:     [High/Med/Low] - [Why]
Supplier Power:         [High/Med/Low] - [Why]
Buyer Power:            [High/Med/Low] - [Why]
Substitute Threat:      [High/Med/Low] - [Why]

Overall Industry Attractiveness: [Assessment]

═══════════════════════════════════════
OPPORTUNITIES
═══════════════════════════════════════
1. [Opportunity with sizing]
2. [Opportunity with sizing]

═══════════════════════════════════════
THREATS
═══════════════════════════════════════
1. [Threat with probability/impact]
2. [Threat with probability/impact]

═══════════════════════════════════════
STRATEGIC IMPLICATIONS
═══════════════════════════════════════
[Recommendations for positioning/strategy]
```

## Quality Checklist

- [ ] Market sizing uses multiple methods for triangulation
- [ ] All numbers sourced and dated
- [ ] Competitor list is comprehensive
- [ ] Analysis is honest (not just supporting a narrative)
- [ ] Trends backed by evidence
- [ ] Clear implications for strategy
