# PitchDeck Workflow

Create compelling investor presentations that tell a story and drive to action.

## Pitch Deck Philosophy

### The Story Arc
A great pitch deck follows a narrative structure:
1. **Hook**: Capture attention with the problem
2. **Build**: Show the opportunity and your solution
3. **Prove**: Demonstrate traction and team capability
4. **Ask**: Clear funding request and use

### Key Principles
- **10-15 slides maximum** (12 is ideal)
- **One idea per slide**
- **Visual over text** (minimize bullet points)
- **Numbers speak louder** than adjectives
- **Honesty wins** - sophisticated investors see through spin

## Slide Structure

### Slide 1: Title
- Company name and tagline
- Your name and contact
- Date and version

### Slide 2: Problem (The Hook)
**Goal:** Make them feel the pain

- Specific, relatable problem statement
- Quantify the pain (cost, time, frustration)
- Show who has this problem
- Why existing solutions fail

**Format:** Customer quote or scenario + supporting data

### Slide 3: Solution
**Goal:** "Aha!" moment

- Clear, simple explanation
- Show don't tell (screenshot, demo, visual)
- Core value proposition in one sentence
- How it solves the problem from Slide 2

### Slide 4: Why Now
**Goal:** Create urgency

- Market timing factors
- Technology enablers
- Regulatory changes
- Behavioral shifts
- Why this couldn't have worked 5 years ago

### Slide 5: Market Opportunity
**Goal:** Show the prize is worth chasing

- TAM/SAM/SOM with methodology
- Growth rate and direction
- Bottom-up sizing is more credible
- Address obvious "but what about..." questions

### Slide 6: Business Model
**Goal:** Show how you make money

- Revenue streams
- Pricing model and rationale
- Unit economics (CAC, LTV, margins)
- Path to profitability

### Slide 7: Traction
**Goal:** Prove it's working

- Key metrics (revenue, users, growth rate)
- Customer logos (with permission)
- Month-over-month progression
- Highlight inflection points

**No traction yet?** Show:
- LOIs, pilot agreements
- Waitlist numbers
- Advisor commitments
- Early user feedback

### Slide 8: Product
**Goal:** Make it tangible

- Screenshots or demo
- Key features (max 3-4)
- Technology differentiation
- Roadmap highlights

### Slide 9: Competition
**Goal:** Show you understand the landscape

- Competitive matrix (you in top-right)
- Honest about competitors' strengths
- Clear differentiation
- Why you win

**Never say:** "We have no competition"

### Slide 10: Go-to-Market
**Goal:** Show you can sell

- Customer acquisition strategy
- Sales motion (self-serve, inside sales, enterprise)
- Key channels
- Early wins and learnings

### Slide 11: Team
**Goal:** Build confidence in execution

- Founders with relevant experience
- Key hires and advisors
- Why this team for this problem
- What gaps exist and plan to fill

**Include:**
- Photos
- Previous company logos
- Relevant credentials

### Slide 12: Financials
**Goal:** Show path to returns

- 3-year projection (Revenue, Gross Margin, EBITDA)
- Key assumptions
- Path to profitability or next milestone
- Keep it high-level (details in appendix)

### Slide 13: The Ask
**Goal:** Clear call to action

- Amount raising
- Use of funds (pie chart or table)
- Key milestones this enables
- Current round details (lead, terms if set)

### Slide 14: Closing
- Company name and tagline
- Contact information
- Thank you

## Appendix Slides (As Needed)

- Detailed financial model
- Full competitive analysis
- Technical architecture
- Customer case studies
- Team bios
- Patent/IP summary
- Market research sources

## Visual Design Guidelines

### Typography
- Sans-serif fonts (clean, modern)
- Max 2 font sizes per slide
- Minimum 24pt for body text
- Title should be readable from back of room

### Color
- 2-3 colors maximum
- High contrast for readability
- Consistent with brand
- Charts should be easy to read

### Layout
- Plenty of white space
- Left-to-right reading flow
- One focal point per slide
- Consistent margins and alignment

### Data Visualization
- Simple charts (bar, line, pie)
- Label data points directly
- Remove chart junk (gridlines, legends when obvious)
- Make the point obvious

## Delivery Tips

### Know Your Numbers
- Memorize key metrics
- Know customer counts, growth rates, unit economics
- Have financial details ready for Q&A

### Anticipate Questions
- Why now?
- Why you?
- What's the moat?
- How do you acquire customers?
- What keeps you up at night?
- Why this valuation?

### Demo Readiness
- Have backup screenshots if demo fails
- Know the happy path
- Don't show bugs or unfinished features

## Output Format

Provide deck as:
1. **Outline**: Slide-by-slide content guide
2. **Key Messages**: What each slide must communicate
3. **Suggested Visuals**: Charts, images, screenshots needed
4. **Talking Points**: What to say on each slide

Can be exported via MSOffice skill for PowerPoint creation.

## Quality Checklist

- [ ] Tells a clear story from problem to solution
- [ ] Every claim backed by data
- [ ] Competitive analysis is honest
- [ ] Financials are defensible
- [ ] Clear ask with use of funds
- [ ] Team slide inspires confidence
- [ ] Visual design is clean and consistent
- [ ] Under 15 slides (excluding appendix)
