# StrategicReview Workflow

Comprehensive strategic assessment including SWOT analysis, competitive positioning, and strategic options evaluation.

## SWOT Analysis Framework

### Internal Factors

**Strengths** (Internal, Positive)
- What do we do better than competitors?
- What unique resources do we have?
- What do customers say we're good at?
- What's our unfair advantage?

Key questions:
1. Core competencies that drive value
2. Proprietary technology or IP
3. Strong customer relationships
4. Talented team or unique expertise
5. Efficient operations or cost structure
6. Brand reputation or market position

**Weaknesses** (Internal, Negative)
- Where do we underperform?
- What resources are we lacking?
- What do customers complain about?
- Where are we vulnerable?

Key questions:
1. Capability gaps vs competitors
2. Resource constraints (cash, people, tech)
3. Operational inefficiencies
4. Product/service limitations
5. Customer experience issues
6. Cultural or organizational problems

### External Factors

**Opportunities** (External, Positive)
- What market trends benefit us?
- What competitor weaknesses can we exploit?
- What unmet needs exist?
- What regulatory or technology changes help us?

Key questions:
1. Growing market segments
2. Underserved customer needs
3. Competitor missteps or exits
4. Technology enablers
5. Partnership possibilities
6. Geographic expansion potential

**Threats** (External, Negative)
- What market trends hurt us?
- What are competitors doing?
- What could disrupt our business?
- What regulatory or economic risks exist?

Key questions:
1. New or strengthening competitors
2. Changing customer preferences
3. Technology disruption
4. Regulatory changes
5. Economic headwinds
6. Supply chain vulnerabilities

## SWOT Matrix Template

```
┌─────────────────────────────────────────────────────────────────┐
│                        SWOT ANALYSIS                            │
├────────────────────────────┬────────────────────────────────────┤
│       STRENGTHS            │         WEAKNESSES                 │
│                            │                                    │
│  • S1: [Description]       │  • W1: [Description]               │
│  • S2: [Description]       │  • W2: [Description]               │
│  • S3: [Description]       │  • W3: [Description]               │
│  • S4: [Description]       │  • W4: [Description]               │
│                            │                                    │
├────────────────────────────┼────────────────────────────────────┤
│       OPPORTUNITIES        │           THREATS                  │
│                            │                                    │
│  • O1: [Description]       │  • T1: [Description]               │
│  • O2: [Description]       │  • T2: [Description]               │
│  • O3: [Description]       │  • T3: [Description]               │
│  • O4: [Description]       │  • T4: [Description]               │
│                            │                                    │
└────────────────────────────┴────────────────────────────────────┘
```

## TOWS Strategic Options Matrix

Combine SWOT factors to generate strategic options:

| | Strengths (S) | Weaknesses (W) |
|---|---|---|
| **Opportunities (O)** | **SO Strategies** (Maxi-Maxi): Use strengths to capture opportunities | **WO Strategies** (Mini-Maxi): Address weaknesses to capture opportunities |
| **Threats (T)** | **ST Strategies** (Maxi-Mini): Use strengths to mitigate threats | **WT Strategies** (Mini-Mini): Defensive - minimize weaknesses and threats |

### Strategy Generation Questions

**SO (Aggressive/Growth)**
- How can we use [strength] to exploit [opportunity]?
- Which opportunities best match our capabilities?

**WO (Developmental)**
- What weaknesses prevent us from capturing [opportunity]?
- Can we acquire capabilities to exploit opportunities?

**ST (Defensive)**
- How can we use [strength] to defend against [threat]?
- Can our strengths create barriers to threats?

**WT (Survival)**
- What must we fix to survive [threat]?
- Should we exit, pivot, or find a partner?

## Competitive Positioning Analysis

### Positioning Map

Plot competitors on key dimensions:

```
                    HIGH PRICE
                        │
                        │
    Premium             │            Luxury
    (High value,        │     (Exclusivity,
     fair price)        │      brand premium)
                        │
    ────────────────────┼────────────────────
                        │
    Economy             │            Overpriced
    (Basic needs,       │     (Low value,
     low cost)          │      high price)
                        │
                    LOW PRICE

            LOW VALUE ←───────→ HIGH VALUE
```

### Differentiation Assessment

| Dimension | Our Position | Market Leader | Gap | Priority |
|-----------|-------------|---------------|-----|----------|
| Price | | | | |
| Quality | | | | |
| Features | | | | |
| Service | | | | |
| Brand | | | | |
| Innovation | | | | |
| Convenience | | | | |

### Sustainable Competitive Advantage (Moat Analysis)

**Types of Moats:**

1. **Network Effects** - Value increases with users
   - Strong: Marketplace, social network
   - Weak: Content platform, community

2. **Switching Costs** - Pain to change providers
   - High: Enterprise software, banking
   - Low: Consumer apps, commodities

3. **Cost Advantages** - Structural cost benefits
   - Scale economies
   - Process innovation
   - Favorable access to inputs

4. **Intangible Assets** - Hard to replicate
   - Brand recognition
   - Patents and IP
   - Regulatory licenses
   - Proprietary data

5. **Efficient Scale** - Market too small for competition
   - Niche dominance
   - Geographic monopoly

### Moat Assessment Template

| Moat Type | Presence | Strength | Durability | Evidence |
|-----------|----------|----------|------------|----------|
| Network Effects | Y/N | 1-5 | Years | |
| Switching Costs | Y/N | 1-5 | Years | |
| Cost Advantages | Y/N | 1-5 | Years | |
| Intangible Assets | Y/N | 1-5 | Years | |
| Efficient Scale | Y/N | 1-5 | Years | |

## Strategic Options Evaluation

### Option Scoring Framework

For each strategic option:

| Criteria | Weight | Score (1-5) | Weighted |
|----------|--------|-------------|----------|
| Strategic Fit | 20% | | |
| Financial Return | 25% | | |
| Risk Level | 20% | | |
| Feasibility | 20% | | |
| Time to Value | 15% | | |
| **Total** | 100% | | |

### Strategic Fit Questions
- Does this align with our vision/mission?
- Does it leverage our strengths?
- Does it fit our risk appetite?
- Do we have the capabilities?

### Risk Assessment Matrix

```
                    HIGH IMPACT
                        │
    Monitor             │         Mitigate
    (Watch closely,     │    (Develop contingency,
     prepare response)  │     reduce probability)
                        │
    ────────────────────┼────────────────────
                        │
    Accept              │         Transfer
    (Proceed with       │    (Insurance, hedging,
     awareness)         │     partnerships)
                        │
                    LOW IMPACT

         LOW PROBABILITY ←───→ HIGH PROBABILITY
```

## Strategic Review Process

### Phase 1: Situation Assessment
1. Review mission, vision, values
2. Analyze current performance vs goals
3. Document key assumptions
4. Identify strategic questions

### Phase 2: External Analysis
1. Market trends (PESTEL)
2. Industry dynamics (Porter's Five Forces)
3. Competitive landscape
4. Customer insights

### Phase 3: Internal Analysis
1. Financial performance
2. Operational capabilities
3. Resource assessment
4. Culture and organization

### Phase 4: SWOT Synthesis
1. Compile SWOT factors
2. Prioritize by impact
3. Generate TOWS strategies
4. Identify strategic options

### Phase 5: Strategy Selection
1. Evaluate options
2. Assess risks
3. Define success metrics
4. Build implementation roadmap

## Output Template

```
🎯 STRATEGIC REVIEW: [Company/Business Unit]
Date: [Review Date]
Period: [Time horizon]

═══════════════════════════════════════
EXECUTIVE SUMMARY
═══════════════════════════════════════
Strategic Position: [Strong/Moderate/Weak]
Primary Challenge: [One sentence]
Recommended Focus: [One sentence]

═══════════════════════════════════════
SWOT ANALYSIS
═══════════════════════════════════════
TOP STRENGTHS                    TOP WEAKNESSES
• S1: [Impact: H/M/L]           • W1: [Impact: H/M/L]
• S2: [Impact: H/M/L]           • W2: [Impact: H/M/L]
• S3: [Impact: H/M/L]           • W3: [Impact: H/M/L]

TOP OPPORTUNITIES                TOP THREATS
• O1: [Timing: S/M/L]           • T1: [Probability: H/M/L]
• O2: [Timing: S/M/L]           • T2: [Probability: H/M/L]
• O3: [Timing: S/M/L]           • T3: [Probability: H/M/L]

═══════════════════════════════════════
COMPETITIVE POSITION
═══════════════════════════════════════
Market Position: [Leader/Challenger/Follower/Nicher]
Primary Differentiation: [What sets us apart]
Moat Strength: [Strong/Moderate/Weak/None]

vs Key Competitors:
• [Competitor A]: [Advantage/Parity/Disadvantage] - [Why]
• [Competitor B]: [Advantage/Parity/Disadvantage] - [Why]

═══════════════════════════════════════
STRATEGIC OPTIONS
═══════════════════════════════════════
OPTION A: [Name]
- Description: [What we would do]
- Rationale: [Why this makes sense]
- Investment: [£X over Y years]
- Risk: [High/Medium/Low]
- Score: [X/5]

OPTION B: [Name]
- Description: [What we would do]
- Rationale: [Why this makes sense]
- Investment: [£X over Y years]
- Risk: [High/Medium/Low]
- Score: [X/5]

OPTION C: [Name]
- Description: [What we would do]
- Rationale: [Why this makes sense]
- Investment: [£X over Y years]
- Risk: [High/Medium/Low]
- Score: [X/5]

═══════════════════════════════════════
RECOMMENDATION
═══════════════════════════════════════
Recommended Strategy: [Option X]

Rationale:
[2-3 sentences on why this is the best path]

Key Success Factors:
1. [Critical requirement]
2. [Critical requirement]
3. [Critical requirement]

Key Risks & Mitigations:
1. [Risk] → [Mitigation]
2. [Risk] → [Mitigation]

═══════════════════════════════════════
IMPLEMENTATION PRIORITIES
═══════════════════════════════════════
Immediate (0-3 months):
• [Action 1]
• [Action 2]

Short-term (3-12 months):
• [Action 3]
• [Action 4]

Medium-term (1-3 years):
• [Action 5]
• [Action 6]

═══════════════════════════════════════
SUCCESS METRICS
═══════════════════════════════════════
| Metric | Current | Target | Timeline |
|--------|---------|--------|----------|
| [KPI 1] | X | Y | [Date] |
| [KPI 2] | X | Y | [Date] |
| [KPI 3] | X | Y | [Date] |
```

## Quality Checklist

- [ ] SWOT factors are specific and actionable (not generic)
- [ ] Each factor has evidence/data supporting it
- [ ] Competitive analysis based on research, not assumptions
- [ ] Strategic options are genuinely different (not variations)
- [ ] Recommendations tied clearly to analysis
- [ ] Risks identified with realistic mitigations
- [ ] Implementation priorities are concrete and achievable
- [ ] Success metrics are measurable and time-bound
