# Review Response Writer

Write professional, empathetic responses to App Store reviews that build trust and turn critics into fans.

## When to Use

- User needs to respond to negative reviews
- User wants templates for common review types
- User asks about review management strategy
- User wants to improve customer relationships

## Response Philosophy

### Why Respond?

1. **Shows you care** - Active developer = trustworthy app
2. **Helps others** - Future users read responses
3. **Converts critics** - Can change rating with good response
4. **Provides feedback** - Reviews reveal real issues
5. **Builds community** - Creates loyal users

### When to Respond

| Review Type | Respond? | Priority |
|-------------|----------|----------|
| 1-2 stars with feedback | **Yes** | High |
| 3 stars with suggestions | Yes | Medium |
| Bug reports (any rating) | **Yes** | High |
| 4-5 stars with content | Yes | Low |
| 4-5 stars generic praise | Optional | Low |
| Abusive/inappropriate | Report, don't respond | - |
| Competitor spam | Report, don't respond | - |

### Response Timing

- **Negative reviews:** Within 24-48 hours
- **Bug reports:** ASAP (shows responsiveness)
- **Positive reviews:** Weekly batch is fine
- **After fixing issues:** Follow up to notify

## Response Framework

### The A.C.T. Formula

```
A - Acknowledge their experience
C - Clarify or provide solution
T - Thank them and invite continued feedback
```

### Template Structure

```
[Greeting - use their name if signed]

[Acknowledge their frustration/praise]

[Address specific points they raised]

[Provide solution, workaround, or update info]

[Thank + future-focused closing]

[Sign-off with name/team]
```

## Response Templates

### Negative Review: Bug Report

**Review:** "App crashes every time I try to export. Waste of money. 1 star."

**Response:**
```
Hi [Name],

I'm really sorry about the export crashes — that's frustrating,
especially when you're trying to get work done.

We identified this issue and it's fixed in version X.X, which is
now available. If you update and still experience problems, please
reach out to support@yourapp.com and we'll help you directly.

Thank you for taking the time to report this. It helps us improve.

— [Your Name], [App] Team
```

### Negative Review: Missing Feature

**Review:** "No dark mode? In 2024? Uninstalled."

**Response:**
```
Hi there,

You're absolutely right — dark mode is important, and we hear you.

Good news: dark mode is in active development and planned for our
next major update. If you'd like to be notified when it's ready,
drop us a note at support@yourapp.com.

Thanks for the feedback. We hope to welcome you back soon!

— [Your Name], [App] Team
```

### Negative Review: User Error (Diplomatic)

**Review:** "Can't figure out how to do X. Bad design."

**Response:**
```
Hi [Name],

Thanks for reaching out. I can see how [X] might not be obvious
at first — we could definitely make it clearer.

Quick tip: you can access [X] by [simple instructions]. We're also
adding an in-app tutorial in our next update to help with this.

If you're still stuck, email us at support@yourapp.com and we'll
walk you through it.

— [Your Name], [App] Team
```

### Negative Review: Pricing Complaint

**Review:** "Too expensive for what it does."

**Response:**
```
Hi [Name],

Thanks for sharing your thoughts on pricing. I understand — value
is important.

A few things that might help:
• We offer a free trial so you can test before committing
• The subscription includes [key benefits]
• We regularly run promotions — follow us @handle for updates

We're always working to add more value. If there's a specific
feature you'd find worth the price, we'd love to hear about it.

— [Your Name], [App] Team
```

### Negative Review: Generic/Vague

**Review:** "Doesn't work. Terrible app."

**Response:**
```
Hi there,

I'm sorry to hear you're having trouble. We'd really like to help,
but need a bit more info to figure out what's going wrong.

Could you email us at support@yourapp.com with:
• What you were trying to do
• What happened instead
• Your device and iOS version

We respond quickly and will do our best to get you sorted.

— [Your Name], [App] Team
```

### Positive Review: With Feature Request

**Review:** "Love this app! Would be perfect if it had X."

**Response:**
```
Thank you so much for the kind words! 🙏

Great suggestion on [X] — you're not the first to ask, and it's
on our roadmap. Can't promise exact timing, but it's coming.

If you have other ideas, we're all ears at feedback@yourapp.com.

Thanks for being a [App] user!

— [Your Name]
```

### Positive Review: Simple Thanks

**Review:** "Great app, use it every day. 5 stars!"

**Response:**
```
Thank you! Reviews like this make our day. We're glad [App] is
helping you. If you ever need anything, we're here!

— The [App] Team
```

### After Fixing a Bug

**Review:** [Previously reported bug]

**Follow-up Response:**
```
Hi [Name],

Quick update: the [issue] you reported has been fixed in version
X.X, now available in the App Store.

Thank you again for letting us know — you helped us make [App]
better for everyone.

If you get a chance to try the update, we'd love to know if it
resolved things for you.

— [Your Name], [App] Team
```

## Tone Guidelines

### Always

- Be genuinely helpful
- Stay professional but warm
- Take responsibility (never blame user)
- Be specific (not generic)
- Keep it concise

### Never

- Be defensive or argumentative
- Make excuses
- Ignore valid criticism
- Use corporate jargon
- Copy-paste identical responses
- Promise specific timelines you can't keep

### Tone by Situation

| Situation | Tone |
|-----------|------|
| Bug report | Apologetic, solution-focused |
| Feature request | Appreciative, forward-looking |
| Confusion | Helpful, educational |
| Angry review | Calm, empathetic |
| Positive review | Grateful, personable |

## Difficult Situations

### Abusive Reviews

**Don't respond.** Report to Apple if it:
- Contains profanity/hate speech
- Includes personal attacks
- Is clearly spam
- Violates App Store guidelines

### Competitor Attacks

Signs of competitor spam:
- Multiple similar reviews at once
- No specific details
- Account has reviewed many competing apps
- Unrealistic claims

**Action:** Report to Apple, don't engage.

### Impossible to Satisfy

Some users can't be pleased. After one genuine attempt:
- Don't keep responding
- Document for your records
- Move on

### Legal Threats

If a review contains legal threats:
- Don't respond publicly
- Consult with legal
- Document everything

## Metrics to Track

### Response Metrics
- Response rate (aim for 100% of actionable)
- Response time (aim for <48 hours)
- Follow-up conversion (ratings changed after response)

### Review Health
- Average rating trend
- Review volume
- Sentiment analysis
- Common themes

## Workflow

### Daily (5 minutes)
1. Check for new reviews
2. Flag urgent issues (bugs, crashes)
3. Respond to critical reviews

### Weekly (15 minutes)
1. Respond to remaining reviews
2. Track themes and patterns
3. Share feedback with team

### Monthly (30 minutes)
1. Analyze rating trends
2. Update response templates if needed
3. Report key feedback to product team

## Quick Reference

### Response Length
- **Ideal:** 50-100 words
- **Maximum:** 150 words
- **Never:** Wall of text

### Sign-off Options
- "— The [App] Team"
- "— [Name], [App] Support"
- "— [Name], Founder of [App]"

### Contact Options to Offer
- support@yourapp.com
- In-app support chat
- @TwitterHandle
- yourapp.com/help
