# Screenshot Planner

Plan compelling App Store screenshot sequences that showcase your app's value.

## When to Use

- User is preparing App Store assets
- User wants to improve screenshot conversion
- User asks about screenshot strategy or captions
- User is launching a new app or major update

## Information Gathering

Before planning, ask about:

1. **App Type**
   - What category? (Productivity, Games, Lifestyle, etc.)
   - Primary use case?
   - Visual style of the app?

2. **Key Selling Points**
   - What makes users choose this app?
   - Most impressive features visually?
   - Any unique UI elements?

3. **Target Audience**
   - Who downloads this app?
   - What problem are they trying to solve?
   - What matters most to them?

4. **Competitors**
   - What do competitor screenshots show?
   - How can you differentiate?

## Screenshot Strategy

### The 5-Screenshot Framework

Most users only see the first 2-3 screenshots. Order matters!

| Position | Purpose | Content |
|----------|---------|---------|
| **1** | Hero Shot | Value proposition + best visual |
| **2** | Core Feature | Primary use case in action |
| **3** | Key Differentiator | What makes you unique |
| **4** | Secondary Feature | Another compelling feature |
| **5** | Social Proof/CTA | Reviews, awards, or final push |

### Extended (10 Screenshots)

| Position | Purpose |
|----------|---------|
| 6 | Additional feature |
| 7 | Customization/settings |
| 8 | Integration/ecosystem |
| 9 | Before/after or workflow |
| 10 | Final CTA with app icon |

## Caption Writing

### Caption Formula

```
[Action Verb] + [Benefit] + [Optional Detail]
```

### Examples by Category

**Productivity:**
- "Capture ideas instantly"
- "Never miss a deadline"
- "Your tasks, beautifully organized"

**Health & Fitness:**
- "Track every workout"
- "See your progress over time"
- "Personalized plans that work"

**Photo & Video:**
- "Edit like a pro in seconds"
- "Filters that actually look good"
- "Share anywhere with one tap"

**Finance:**
- "Know where your money goes"
- "Budget without the stress"
- "Insights that save you money"

### Caption Rules

✅ **Do:**
- Keep under 8 words
- Start with action verbs
- Focus on user benefits
- Match the visual exactly
- Use sentence case

❌ **Don't:**
- Use technical jargon
- Include version numbers
- Mention prices
- Use "Our app does..."
- Write full sentences

## Visual Best Practices

### Device Frames

| Approach | When to Use |
|----------|-------------|
| **With frames** | When device context matters, lifestyle apps |
| **Without frames** | Maximizing screen real estate, content apps |
| **3D angles** | Standing out, premium feel |
| **Flat/straight** | Clean, professional, enterprise |

### Backgrounds

- **Solid colors:** Clean, professional, fast loading
- **Gradients:** Modern, dynamic, attention-grabbing
- **Lifestyle photos:** Context, emotion, aspiration
- **Abstract patterns:** Creative, unique, memorable

### Typography

- Use 2 fonts max (headline + body)
- Minimum 60pt for headlines (iPhone)
- Ensure readability on small thumbnails
- Match your app's brand fonts if possible

## Screenshot Storyboard Template

```
SCREENSHOT 1: HERO
━━━━━━━━━━━━━━━━━━
Caption: [Value proposition - max 6 words]
Visual: [Key screen showing main feature]
Background: [Color/gradient that pops]
Notes: [This is first impression - make it count]

SCREENSHOT 2: CORE FEATURE
━━━━━━━━━━━━━━━━━━━━━━━━━━
Caption: [What can user do?]
Visual: [App in action, primary workflow]
Background: [Consistent with #1]
Notes: [Show the "aha" moment]

SCREENSHOT 3: DIFFERENTIATOR
━━━━━━━━━━━━━━━━━━━━━━━━━━━
Caption: [What makes you unique?]
Visual: [Feature competitors don't have]
Background: [Can vary slightly]
Notes: [Answer "why this app?"]

SCREENSHOT 4: SECONDARY FEATURE
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
Caption: [Another key benefit]
Visual: [Compelling secondary feature]
Background: [Consistent theme]
Notes: [Add depth to value proposition]

SCREENSHOT 5: TRUST/CTA
━━━━━━━━━━━━━━━━━━━━━━
Caption: [Social proof or call to action]
Visual: [Reviews, stats, or final screen]
Background: [Strong finish]
Notes: [Close the deal]
```

## Size Requirements

### iPhone (Required)
| Size | Device | Dimensions |
|------|--------|------------|
| 6.7" | iPhone 15 Pro Max | 1290 × 2796 |
| 6.5" | iPhone 11 Pro Max | 1284 × 2778 |
| 5.5" | iPhone 8 Plus | 1242 × 2208 |

### iPad (If Universal)
| Size | Device | Dimensions |
|------|--------|------------|
| 12.9" | iPad Pro | 2048 × 2732 |

### macOS
| Display | Dimensions |
|---------|------------|
| Standard | 1280 × 800 (min) |
| Retina | 2880 × 1800 |

## App Preview Video

### When to Include
- Complex apps that need demonstration
- Games (almost always)
- Apps with unique interactions
- When screenshots can't show the experience

### Video Specs
- 15-30 seconds optimal
- First 3 seconds = hook
- No audio required (most watch muted)
- Show actual app (no external footage first 3s)
- 1080p or higher

### Video Storyboard
```
0:00-0:03  Hook - Most impressive moment
0:03-0:10  Core workflow demonstration
0:10-0:20  Key features montage
0:20-0:30  Final CTA with value prop
```

## Localization

### Considerations
- Captions must be localized
- Screenshots may need localization if they show text
- Consider using minimal in-app text in screenshots
- Some markets prefer different visual styles

### Priority Markets
1. English (US)
2. Chinese (Simplified)
3. Japanese
4. German
5. French
6. Spanish

## Tools

### Design Tools
- **Figma** - Free, collaborative
- **Sketch** - Mac-native, templates available
- **Photoshop** - Full control

### Screenshot Generators
- **Screenshots.pro** - Templates with device frames
- **Previewed** - 3D mockups
- **AppLaunchpad** - Quick and easy
- **Studio** - Mac app with templates

### Capture Tools
- **Xcode Simulator** - File → Screenshot
- **QuickTime** - Screen recording for video
- **ScreenFloat** - Organize captures

## Competitive Analysis

Before finalizing, check competitors:

1. Search your main keyword
2. Screenshot top 5 apps
3. Note patterns:
   - Frame style used
   - Caption placement
   - Color schemes
   - Number of screenshots
4. Differentiate while meeting expectations
