#!/bin/bash
# ci_post_clone.sh
# Xcode Cloud: Runs after the repository is cloned
#
# Use this script for:
# - Installing additional dependencies (Homebrew, etc.)
# - Setting up environment variables
# - Configuring build settings
#
# Available environment variables:
# - CI_WORKSPACE: Path to workspace
# - CI_XCODE_PROJECT: Project path
# - CI_XCODE_SCHEME: Scheme name
# - CI_BRANCH: Git branch name
# - CI_COMMIT: Commit SHA
# - CI_BUILD_NUMBER: Xcode Cloud build number

set -e  # Exit on error

echo "📦 Running post-clone script..."
echo "Branch: $CI_BRANCH"
echo "Commit: $CI_COMMIT"
echo "Build: $CI_BUILD_NUMBER"

# ============================================
# Install Homebrew dependencies (if needed)
# ============================================

# Uncomment to install Homebrew packages
# if command -v brew &> /dev/null; then
#     echo "Installing Homebrew dependencies..."
#     brew install swiftlint
#     brew install xcbeautify
# fi

# ============================================
# Install Ruby dependencies (if using fastlane)
# ============================================

# Uncomment if using fastlane
# if [ -f "Gemfile" ]; then
#     echo "Installing Ruby dependencies..."
#     bundle install
# fi

# ============================================
# Environment-specific configuration
# ============================================

# Configure based on branch
case "$CI_BRANCH" in
    "main" | "master")
        echo "Production build configuration"
        # Set production environment variables
        export APP_ENV="production"
        ;;
    "develop")
        echo "Staging build configuration"
        export APP_ENV="staging"
        ;;
    *)
        echo "Development build configuration"
        export APP_ENV="development"
        ;;
esac

# ============================================
# Generate build configuration file
# ============================================

# Example: Create a BuildConfig.swift with build info
# Uncomment and customize as needed

# cat > "$CI_WORKSPACE/BuildConfig.swift" << EOF
# // Auto-generated by CI
# import Foundation
#
# enum BuildConfig {
#     static let buildNumber = "$CI_BUILD_NUMBER"
#     static let commitHash = "$CI_COMMIT"
#     static let branch = "$CI_BRANCH"
#     static let environment = "$APP_ENV"
# }
# EOF

# ============================================
# Fetch secrets from environment
# ============================================

# Access custom environment variables set in Xcode Cloud workflow
# These are set in App Store Connect > Xcode Cloud > Workflow > Environment

# if [ -n "$API_BASE_URL" ]; then
#     echo "API Base URL configured"
# fi

# if [ -n "$SENTRY_DSN" ]; then
#     echo "Sentry DSN configured"
# fi

echo "✅ Post-clone script completed"
