---
name: prd-generator
description: Generates comprehensive Product Requirements Document from product plan. Creates PRD.md with features, user stories, acceptance criteria, and success metrics. Use when creating product requirements.
allowed-tools: [Read, Write, Glob, Grep, AskUserQuestion]
---

# PRD Generator Skill

Generate comprehensive Product Requirements Document from product development plan.

## Metadata
- **Name**: prd-generator
- **Version**: 1.0.0
- **Role**: Product Manager
- **Author**: ProductAgent Team

## Activation

This skill activates when the user says:
- "generate PRD"
- "create product requirements"
- "write product requirements document"
- "generate requirements doc"
- "create PRD from plan"

## Description

You are a Product Manager AI agent specializing in iOS/macOS app requirements. Your job is to transform a product development plan (generated by `product-agent run`) into a comprehensive, actionable Product Requirements Document (PRD).

## Prerequisites

Before activating this skill, ensure:
1. A product development plan exists (from `product-agent run` output)
2. The plan includes: problem analysis, MVP scope, positioning, and target audience
3. User has reviewed and approved the product development plan

## Input Sources

Read and extract information from:

1. **Product development plan markdown file** (typically saved as `product-plan-*.md`)
   - Problem statement and analysis
   - Target users and pain points
   - MVP scope and core features
   - Positioning and value proposition
   - Success criteria

2. **Competitive Analysis** (optional, if exists - from `competitive-analysis` skill)
   Look for: `competitive-analysis.md`, `docs/competitive-analysis.md`, or embedded in product plan
   - Competitor list with strengths/weaknesses
   - Feature matrix and gaps
   - Pricing analysis
   - Differentiation opportunities
   - Market positioning map

   **Integration**: Use competitive insights to:
   - Inform feature priorities (fill gaps competitors miss)
   - Validate positioning (differentiation)
   - Set pricing context
   - Identify unique value propositions

3. **Market Research** (optional, if exists - from `market-research` skill)
   Look for: `market-research.md`, `docs/market-research.md`, or embedded in product plan
   - TAM/SAM/SOM market sizing
   - Market growth trends
   - Entry barriers
   - Distribution channels
   - Revenue potential

   **Integration**: Use market research to:
   - Validate opportunity size
   - Inform success metrics (realistic targets based on market)
   - Identify risks (entry barriers)
   - Set revenue expectations

4. **User clarifications** (ask if needed):
   - Additional feature requirements
   - Specific user flows to prioritize
   - Timeline constraints
   - Platform-specific considerations

## Output

Generate `docs/PRD.md` with the following structure:

```markdown
# Product Requirements Document: [App Name]

**Version**: 1.0.0
**Last Updated**: [Date]
**Status**: Draft / In Review / Approved
**Owner**: Product Manager
**Platform**: iOS / macOS

---

## 1. Product Overview

### 1.1 Vision Statement
[One-paragraph vision for the product - what it aspires to achieve]

### 1.2 Target Audience
**Primary**: [Detailed description of primary users]
**Secondary**: [Secondary audience if applicable]

### 1.3 Success Metrics
- [Metric 1]: [Target value]
- [Metric 2]: [Target value]
- [Metric 3]: [Target value]

---

## 2. User Personas

### 2.1 Primary Persona: [Persona Name]

**Demographics**:
- Age: [Range]
- Occupation: [Description]
- Tech savviness: [Low/Medium/High]
- Location: [Geographic focus]

**Pain Points**:
1. [Pain point 1 - be specific]
2. [Pain point 2]
3. [Pain point 3]

**Goals**:
1. [Goal 1 - what they want to achieve]
2. [Goal 2]
3. [Goal 3]

**Typical Day**:
[Brief narrative of how this persona currently addresses the problem]

**Quote**: "[A quote that captures their frustration or need]"

### 2.2 User Journey Map

**Current State** (Before using the app):
1. [Step 1 of current workflow]
2. [Step 2 - highlight pain points]
3. [Step 3]
4. [Pain point or frustration]

**Future State** (With the app):
1. [Step 1 - how the app improves it]
2. [Step 2 - benefits]
3. [Step 3 - outcomes]

---

## 3. Features & Requirements

### 3.1 Core Features (MVP - Must Have)

#### Feature 1: [Feature Name]

**Priority**: P0 (Critical)
**Complexity**: Low / Medium / High
**Estimated Effort**: [X] weeks

**User Story**:
As a [user type], I want [action], so that [benefit].

**Acceptance Criteria**:
```gherkin
Given [precondition]
When [action]
Then [expected result]

Given [precondition 2]
When [action 2]
Then [expected result 2]
```

**Description**:
[Detailed description of what this feature does and why it's needed]

**Dependencies**:
- [Dependency 1]
- [Dependency 2]

**Success Metrics**:
- [Metric 1]: [How to measure success]
- [Metric 2]: [Target value]

**Edge Cases**:
- [Edge case 1 and how to handle]
- [Edge case 2]

---

#### Feature 2: [Feature Name]

[Repeat structure for each MVP feature]

---

### 3.2 Deferred Features (Post-MVP - Phase 2)

**Feature**: [Deferred Feature Name]
**Rationale for Deferral**: [Why this is not in MVP]
**Planned for**: Version 1.1 / Phase 2

[List all deferred features with brief descriptions]

---

## 4. User Flows

### 4.1 Onboarding Flow

**Goal**: Help new user understand value and start using core feature

**Steps**:
1. **Launch Screen**
   - Show: Value proposition and hero image
   - Actions: [Sign Up] [Sign In] [Skip]

2. **Registration** (if user chooses Sign Up)
   - Required: [Email, Name, ...]
   - Optional: [Profile photo, ...]
   - Validation: [Email format, password strength]

3. **Welcome Tutorial** (optional, skippable)
   - Screen 1: [Key feature highlight]
   - Screen 2: [How to use core functionality]
   - Screen 3: [Call to action]

4. **First Task**
   - Guide user to create/do [first meaningful action]
   - Show success state

**Success Criteria**: User completes first [action] within first session

---

### 4.2 Core Feature Flow: [Feature Name]

**Entry Points**:
- From: [Screen/Action]
- Trigger: [User action or event]

**Happy Path**:
1. [Step 1] → [Result]
2. [Step 2] → [Result]
3. [Step 3] → [Success state]

**Alternative Paths**:
- If [condition]: [Alternative flow]
- If [error]: [Error handling]

**Exit Points**:
- Success: Navigate to [Screen]
- Cancel: Return to [Screen]
- Error: Show [Error message] and stay

---

### 4.3 Error States & Edge Cases

| Scenario | User Experience | System Behavior |
|----------|----------------|-----------------|
| No network connection | "Can't connect. Using offline mode." | Show cached data, queue actions |
| API timeout | "Taking longer than usual. Please wait..." | Retry with exponential backoff |
| Invalid input | "Please check [field] and try again" | Highlight invalid field, show helper text |
| Permission denied | "We need [permission] to [reason]" | Link to Settings, graceful degradation |

---

## 5. Non-Functional Requirements

### 5.1 Performance

- **Launch Time**: App cold launch < 1.5 seconds
- **Screen Load**: Screens appear < 300ms
- **API Response**: 95th percentile < 2 seconds
- **Offline Support**: Core features work offline with sync when online

### 5.2 Security & Privacy

- **Data Encryption**: All sensitive data encrypted at rest (Keychain)
- **Communication**: All API calls over HTTPS with TLS 1.2+
- **Authentication**: [Auth method - OAuth, JWT, etc.]
- **Privacy Manifest**: Complete PrivacyInfo.xcprivacy included
- **Data Retention**: [Retention policy]

### 5.3 Accessibility

- **VoiceOver**: All interactive elements have labels
- **Dynamic Type**: Support system text size (from XS to Accessibility XXL)
- **Color Contrast**: Minimum 4.5:1 for text, 3:1 for UI elements
- **Keyboard Navigation**: Full keyboard support (iPad, macOS)
- **Reduced Motion**: Respect system setting, provide alternatives

### 5.4 Localization

- **Launch Languages**: [English (US), ...]
- **Future Languages**: [Planned for Phase 2]
- **Considerations**: RTL support, date/time formats, currency

### 5.5 Platform Requirements

- **iOS Version**: Minimum iOS 17.0
- **Devices**: iPhone (all sizes), iPad (if applicable)
- **Orientation**: Portrait (required), Landscape (optional)
- **Dark Mode**: Full support with dedicated assets
- **Size**: Target < 50MB download, < 100MB installed

---

## 6. Out of Scope

**Explicitly NOT included in MVP**:
- [Feature that was considered but excluded]
- [Integration that will come later]
- [Platform that won't be supported initially]

**Rationale**: [Brief explanation of why these are out of scope]

---

## 7. Technical Considerations

### 7.1 Third-Party Services / APIs

| Service | Purpose | Alternative Considered |
|---------|---------|----------------------|
| [Service name] | [What it does] | [Why this was chosen] |

### 7.2 Data Models (High-Level)

**Core Entities**:
- **[Entity 1]**: [Description, key fields]
- **[Entity 2]**: [Description, relationships]

**Relationships**:
- [Entity 1] has many [Entity 2]
- [Entity 3] belongs to [Entity 1]

### 7.3 API Requirements

**Endpoints Needed** (if backend required):
- `GET /api/v1/[resource]` - [Purpose]
- `POST /api/v1/[resource]` - [Purpose]
- `PUT /api/v1/[resource]/:id` - [Purpose]
- `DELETE /api/v1/[resource]/:id` - [Purpose]

---

## 8. Competitive Context

> **Note**: This section is populated from competitive analysis. If not available, include basic competitor awareness.

### 8.1 Key Competitors

| Competitor | Position | Key Strength | Key Weakness |
|------------|----------|--------------|--------------|
| [Competitor 1] | Market leader | [What they do well] | [Gap/opportunity] |
| [Competitor 2] | Challenger | [What they do well] | [Gap/opportunity] |
| [Competitor 3] | Niche | [What they do well] | [Gap/opportunity] |

### 8.2 Differentiation Strategy

**Our Positioning**: [How we're different - from positioning analysis]

**Key Differentiators**:
1. [Feature/approach competitors don't have]
2. [Unique value proposition element]
3. [Target audience we serve better]

### 8.3 Feature Gaps We're Filling

- [Gap 1]: [What competitors miss, how we address it]
- [Gap 2]: [What competitors miss, how we address it]

---

## 9. Market Context

> **Note**: This section is populated from market research. If not available, include high-level market awareness.

### 9.1 Market Sizing

- **TAM** (Total Addressable Market): [$ amount] - [Description]
- **SAM** (Serviceable Available Market): [$ amount] - [iOS/macOS segment]
- **SOM** (Serviceable Obtainable Market): [$ amount] - [Realistic 3-year capture]

### 9.2 Market Trends

**Growth Rate**: [X]% CAGR

**Tailwinds** (positive trends):
- [Trend 1 helping the market]
- [Trend 2 helping the market]

**Headwinds** (challenges):
- [Challenge 1]
- [Challenge 2]

### 9.3 Entry Barriers

| Barrier | Level | Our Strategy |
|---------|-------|--------------|
| [Barrier 1] | Low/Med/High | [How we'll overcome] |
| [Barrier 2] | Low/Med/High | [How we'll overcome] |

### 9.4 Revenue Expectations

- **Year 1 Target**: [$ range] - [User count] at [ARPU]
- **Year 3 Target**: [$ range] - Based on [growth assumptions]
- **Path to Scale**: [Key growth levers]

---

## 10. Open Questions & Decisions Needed

**Critical Decisions** (block development):
1. **[Question 1]**
   - Context: [Why this matters]
   - Options: [Option A / Option B]
   - Owner: [Who decides]
   - Deadline: [When needed]

**Nice-to-Clarify** (doesn't block):
2. **[Question 2]**
   - Context: [Background]
   - Current assumption: [What we're assuming]

---

## 11. Success Criteria & Metrics

### 11.1 MVP Success Criteria

**Launch Readiness**:
- [ ] All P0 features implemented and tested
- [ ] No P0 bugs in production
- [ ] App Store submission approved
- [ ] Performance benchmarks met

**User Success**:
- [ ] > 70% of users complete onboarding
- [ ] > 50% of users perform core action within first week
- [ ] Average session duration > 3 minutes
- [ ] < 2% crash rate

**Business Success**:
- [ ] [Download target] in first month
- [ ] [Active user target] in first 30 days
- [ ] [Retention target] Day 7 retention

### 11.2 Key Metrics to Track

**Acquisition**:
- App Store impressions → downloads conversion rate
- Organic vs paid downloads

**Activation**:
- Onboarding completion rate
- Time to first [core action]

**Engagement**:
- Daily/Weekly Active Users (DAU/WAU)
- Average session length
- Feature usage rates

**Retention**:
- Day 1, Day 7, Day 30 retention rates
- Churn rate and reasons

**Quality**:
- Crash-free rate (target: > 99.5%)
- App Store rating (target: > 4.5)
- Customer support ticket volume

---

## 12. Timeline & Milestones

**Phase 1: MVP Development** ([X] weeks)
- Week 1-2: Core infrastructure
- Week 3-4: Feature 1, Feature 2
- Week 5-6: Feature 3, Feature 4, Testing
- Week 7: Bug fixes, polish, TestFlight
- Week 8: App Store submission

**Phase 2: Iteration** ([X] weeks after launch)
- First update with deferred features
- Performance optimizations based on metrics
- User feedback incorporation

---

## 13. Stakeholders

| Role | Name | Responsibility | Contact |
|------|------|---------------|---------|
| Product Owner | [Name] | Final decisions, priorities | [Email] |
| iOS Developer | [Name] | Implementation | [Email] |
| Designer | [Name] | UI/UX | [Email] |
| QA | [Name] | Testing | [Email] |

---

## 14. References

- Product Development Plan: [Link/filename]
- Market Research: [Link/filename]
- Competitive Analysis: [Link/filename]
- Design Mockups: [Link when ready]
- Technical Architecture: [Link when ready]

---

## Appendix A: Detailed User Stories

[Include detailed user stories that didn't fit in main sections]

---

## Appendix B: Glossary

- **[Term 1]**: [Definition]
- **[Term 2]**: [Definition]

---

**Document History**:
| Version | Date | Author | Changes |
|---------|------|--------|---------|
| 1.0.0 | [Date] | [Name] | Initial PRD created |

```

## Execution Instructions

When activated, follow these steps:

1. **Locate and Read Product Development Plan**
   ```
   Look for files matching: product-plan-*.md
   If multiple exist, use the most recent
   If none exist, ask user to provide the file path
   ```

2. **Look for Market Research and Competitive Analysis** (Optional but Recommended)
   ```
   Check for competitive analysis:
   - competitive-analysis.md
   - docs/competitive-analysis.md
   - Competitive Analysis section in product plan

   Check for market research:
   - market-research.md
   - docs/market-research.md
   - Market Analysis section in product plan

   If found, read and incorporate these insights.
   If not found, proceed with product plan data only.
   ```

3. **Extract Key Information**
   From the product plan, extract:
   - App idea/name
   - Problem statement
   - Target users and personas
   - Core features (from MVP scope section)
   - Positioning and value proposition
   - Success criteria
   - Timeline estimate

   From competitive analysis (if available), extract:
   - Key competitors and their weaknesses
   - Feature gaps (opportunities)
   - Differentiation strategy
   - Pricing insights

   From market research (if available), extract:
   - TAM/SAM/SOM figures
   - Market growth rate
   - Entry barriers to address
   - Revenue potential for success metrics

4. **Create Output Directory**
   ```bash
   mkdir -p docs
   ```

5. **Generate PRD**
   Using the template above:
   - Fill in all sections with specific, actionable content
   - Convert generic placeholders to actual data from the product plan
   - Expand on user stories with Given/When/Then acceptance criteria
   - Add user flows with detailed steps
   - Include all non-functional requirements
   - Identify open questions and decision points

6. **Write to File**
   ```
   Write the complete PRD to: docs/PRD.md
   ```

7. **Present to User**
   After generating the PRD, present a summary:

   ```
   ✅ Product Requirements Document generated!

   📋 **PRD Summary**:
   - Document: docs/PRD.md
   - Features defined: [X] core features
   - User stories: [Y] stories with acceptance criteria
   - User flows: [Z] flows documented
   - Open questions: [N] decisions needed

   📊 **Data Sources Used**:
   - Product Development Plan: ✅
   - Competitive Analysis: [✅ Integrated / ⚠️ Not found - recommend running]
   - Market Research: [✅ Integrated / ⚠️ Not found - recommend running]

   **Next Steps**:
   1. Review the PRD in docs/PRD.md
   2. Answer open questions in Section 8
   3. Provide feedback on any features
   4. Once approved, we can proceed to architecture spec

   Would you like me to make any changes to the PRD?
   ```

8. **Iterate Based on Feedback**
   If user requests changes:
   - Ask clarifying questions
   - Update the PRD accordingly
   - Maintain document version history

## Quality Guidelines

When generating the PRD:

1. **Be Specific**: No generic statements like "the app should be user-friendly"
   - BAD: "The app should be fast"
   - GOOD: "Screen transitions should complete in < 300ms"

2. **Be Actionable**: Every feature should have clear acceptance criteria
   - BAD: "Users can search"
   - GOOD: "As a user, I want to search by keyword so that I can find items quickly. Given I enter 'test' in search, When I tap Search, Then I see results matching 'test' sorted by relevance"

3. **Be Complete**: Cover all aspects
   - Functional requirements (features)
   - Non-functional requirements (performance, security)
   - User flows (happy path + errors)
   - Edge cases and error handling

4. **Be Realistic**: Based on MVP scope from product plan
   - Don't add features beyond MVP unless flagged as "deferred"
   - Timeline should match product plan estimates
   - Success metrics should be measurable and achievable

5. **Be Consistent**: Terminology should match product plan
   - If product plan calls it "item", don't call it "post"
   - Feature names should align across documents

## Example Activation

**User**: "Generate PRD from my product plan"

**You**:
1. Search for product-plan-*.md file
2. Read and parse the product development plan
3. Extract all relevant information
4. Generate comprehensive PRD using template
5. Write to docs/PRD.md
6. Present summary and next steps

## Integration with Workflow

This skill is typically:
- **First step** in implementation specification generation
- Activated after `product-agent run` completes
- Followed by architecture-spec, ux-spec, implementation-guide, test-spec, release-spec

The PRD serves as the source of truth for all downstream specifications.

## Notes

- The PRD is a living document - expect iterations
- User stories should follow Given/When/Then format for testability
- All features should trace back to solving user pain points from discovery
- Keep stakeholder informed with clear decision points
- Document version history for accountability
