---
name: app-store
description: App Store optimization skills for descriptions, screenshots, keywords, and review responses. Use when user needs help with App Store presence, ASO, or customer communication.
allowed-tools: [Read, Write, Edit, Glob, Grep, AskUserQuestion, WebSearch]
---

# App Store Optimization Skills

Skills for optimizing your app's App Store presence, from compelling descriptions to keyword strategy.

## When This Skill Activates

Use this skill when the user:
- Needs to write App Store description or promotional text
- Wants to plan screenshot sequence and captions
- Asks about ASO (App Store Optimization) or keywords
- Needs help responding to App Store reviews
- Wants to improve app discoverability

## Available Skills

### app-description-writer/
Generate compelling App Store descriptions that convert.
- Promotional text (170 chars)
- Full description (4000 chars)
- What's New text for updates
- Localization guidance

### screenshot-planner/
Plan App Store screenshot sequences with captions.
- 5-10 screenshot storyboard
- Caption writing
- Device frame recommendations
- Localization considerations

### keyword-optimizer/
Optimize app title, subtitle, and keywords for search.
- Keyword research methodology
- Character limit optimization (100 chars)
- Competitor analysis
- Localization keyword strategy
- **NEW:** Advanced tactics (cross-localization, screenshot indexing)
- **NEW:** Keyword criteria (Pop/Diff sweet spots, opportunity scoring)
- **NEW:** Existing app strategy (safe optimization)

### review-response-writer/
Professional responses to App Store reviews.
- Templates for common scenarios
- Tone and brand voice guidelines
- Turning negative reviews into opportunities
- When to respond vs. when not to

## How to Use

1. User requests App Store help
2. Read the relevant skill's SKILL.md
3. Ask clarifying questions about the app
4. Generate optimized content
5. Provide alternatives and explain choices

## Key Principles

### 1. User-Focused Copy
- Lead with benefits, not features
- Speak to user pain points
- Use clear, simple language
- Include social proof where possible

### 2. Platform Guidelines
- Stay within character limits
- Follow Apple's content guidelines
- Avoid prohibited terms (free, best, #1)
- Don't mention competing platforms

### 3. Search Optimization
- Use high-value keywords naturally
- Don't stuff keywords
- Consider localized search terms
- Update for seasonal relevance
