# App Description Writer

Generate compelling App Store descriptions that convert browsers into users.

## When to Use

- User needs to write initial App Store description
- User wants to improve existing description
- User is preparing for a major update
- User asks about promotional text or What's New

## Information Gathering

Before writing, ask about:

1. **App Basics**
   - What does the app do? (one sentence)
   - Who is it for? (target audience)
   - What problem does it solve?

2. **Key Features**
   - Top 3-5 features
   - What makes it unique vs competitors?
   - Any awards or recognition?

3. **Social Proof**
   - Number of users/downloads (if impressive)
   - Notable reviews or press mentions
   - Any partnerships or integrations?

4. **Tone**
   - Professional / Casual / Fun / Technical?
   - Brand voice keywords?

## Output Format

Generate all three text types:

### 1. Promotional Text (170 characters)
- First thing users see
- Should create curiosity or urgency
- Can be updated without app review
- Good for seasonal/sale messaging

### 2. Full Description (4000 characters max)
Structure:
```
[Opening Hook - 1-2 sentences, problem/benefit focused]

[Key Features with emoji bullets]
• Feature 1 - benefit
• Feature 2 - benefit
• Feature 3 - benefit

[Social Proof paragraph - optional]

[How it works - brief explanation]

[Call to action]

[Support/contact info]
```

### 3. What's New (4000 characters)
For updates:
```
[Version X.X highlights]

NEW
• Feature addition

IMPROVED
• Enhancement

FIXED
• Bug fix

Thank you for your feedback!
```

## Best Practices

### Do's
- Lead with the biggest benefit
- Use short paragraphs (2-3 lines max)
- Include relevant keywords naturally
- Use emojis sparingly for scannability
- End with clear call-to-action
- Mention if there's a free trial/tier

### Don'ts
- Don't start with "Welcome to..."
- Don't use ALL CAPS excessively
- Don't mention prices (they change)
- Don't claim "#1" or "best" without proof
- Don't mention competitors by name
- Don't include URLs (they're not clickable)

## Examples

### Promotional Text Examples

**Productivity App:**
```
Transform chaos into clarity. The task manager that adapts to how YOU work.
```

**Weather App:**
```
Know before you go. Hyperlocal forecasts down to your street corner. ⛅️
```

**Finance App:**
```
Your money, finally making sense. Budgeting that doesn't feel like homework.
```

### Description Opening Examples

**Problem-First:**
```
Tired of losing track of important tasks? [App] turns your scattered thoughts
into organized action plans in seconds.
```

**Benefit-First:**
```
Capture ideas the moment they strike. [App] is the fastest way to go from
thought to organized note, anywhere.
```

**Curiosity-First:**
```
What if your to-do list actually helped you get things done? Introducing
a smarter way to manage your day.
```

## Localization Tips

When localizing descriptions:
- Don't just translate—adapt to cultural context
- Research local competitors' descriptions
- Adjust feature emphasis by market
- Use native speakers for review
- Consider character limits in other languages (German expands ~30%)

## Character Limits Reference

| Field | Limit |
|-------|-------|
| App Name | 30 characters |
| Subtitle | 30 characters |
| Promotional Text | 170 characters |
| Description | 4000 characters |
| What's New | 4000 characters |
| Keywords | 100 characters |

## Templates

### Template: Utility App
```
[One-line value proposition]

Stop [pain point]. Start [desired outcome].

✨ KEY FEATURES

• [Feature 1] — [Benefit in user terms]
• [Feature 2] — [Benefit in user terms]
• [Feature 3] — [Benefit in user terms]
• [Feature 4] — [Benefit in user terms]

💡 HOW IT WORKS

[2-3 sentences explaining the core flow]

🎯 PERFECT FOR

• [User type 1]
• [User type 2]
• [User type 3]

[Social proof if available]

Download now and [call to action with benefit].

Questions? We're here to help: [support email]
```

### Template: Creative App
```
[Evocative opening that sparks imagination]

[App Name] puts [creative power] in your pocket.

🎨 CREATE

• [Creative feature 1]
• [Creative feature 2]
• [Creative feature 3]

📤 SHARE

• [Sharing/export feature]
• [Community feature if applicable]

🔓 UNLOCK YOUR CREATIVITY

[Inspirational paragraph about what users can achieve]

Join [X] creators already using [App Name].

[Call to action]
```

### Template: What's New
```
Thanks for using [App Name]! Here's what's new in version X.X:

🆕 NEW
• [Major new feature with brief explanation]

⚡️ IMPROVED
• [Performance improvement]
• [UX enhancement]

🔧 FIXED
• [Bug fix users complained about]

Love [App Name]? Leave us a review — it helps more than you know! 💙

Feedback? [support email]
```
