# Problem-Solving Skills - Attribution

These skills were derived from agent patterns in the Microsoft Amplifier project.

## Source Repository

- **Name:** Amplifier
- **URL:** https://github.com/microsoft/amplifier
- **Commit:** 2adb63f858e7d760e188197c8e8d4c1ef721e2a6
- **Date:** 2025-10-10

## Skills Derived from Amplifier Agents

### From insight-synthesizer agent:
- **simplification-cascades** - Finding insights that eliminate multiple components
- **collision-zone-thinking** - Forcing unrelated concepts together for breakthroughs
- **meta-pattern-recognition** - Spotting patterns across 3+ domains
- **inversion-exercise** - Flipping assumptions to reveal alternatives
- **scale-game** - Testing at extremes to expose fundamental truths

### From ambiguity-guardian agent:
- **preserving-productive-tensions** - Preserving multiple valid approaches (in architecture skill)

### From knowledge-archaeologist agent:
- **tracing-knowledge-lineages** - Understanding how ideas evolved (in research skill)

### Dispatch pattern:
- **when-stuck** - Maps stuck-symptoms to appropriate technique

## What Was Adapted

The Amplifier agents are specialized long-lived agents with structured JSON output. These skills extract the core problem-solving techniques and adapt them as:

- **Scannable quick-reference guides** (~60-80 lines each)
- **Symptom-based discovery** via when_to_use descriptions
- **Immediate application** without special tooling
- **Composable patterns** through dispatch system
- **Progressive disclosure** via SKILL.md + references structure

## Core Insight

Agent capabilities are domain-agnostic patterns. Whether packaged as "amplifier agent" or "problem-solving skill", the underlying technique is the same.

We extracted the techniques and made them:
- Portable across contexts
- Immediately applicable
- Token-efficient through progressive disclosure
- Discoverable through symptom-matching
- Combinable for complex problems

## License

Original Amplifier project uses MIT License. These adapted skills maintain attribution and follow the same open spirit.

## Adaptation Notes

**Changes from original:**
- Converted from long-lived agent to scannable reference
- Added symptom-based dispatch system
- Removed JSON output requirements
- Focused on immediate application
- Added concrete examples
- Structured for progressive disclosure

**Preserved from original:**
- Core problem-solving techniques
- Recognition patterns
- Application processes
- Fundamental insights
