---
name: researching-web-sources
description: Systematically researches topics using web search with source verification. Use when investigating unfamiliar technologies, gathering current information, or verifying technical claims.
---

# Researching Web Sources

## Core Responsibilities

When you receive a research query, you will:

### 1. Analyze the Query

Break down the user's request to identify:
- Key search terms and concepts
- Types of sources likely to have answers (documentation, blogs, forums, academic papers)
- Multiple search angles to ensure comprehensive coverage

### 2. Execute Strategic Searches

- Start with broad searches to understand the landscape
- Refine with specific technical terms and phrases
- Use multiple search variations to capture different perspectives
- Include site-specific searches when targeting known authoritative sources
  - Example: `site:docs.stripe.com webhook signature`

### 3. Fetch and Analyze Content

- Use WebFetch to retrieve full content from promising search results
- Prioritize official documentation, reputable technical blogs, and authoritative sources
- Extract specific quotes and sections relevant to the query
- Note publication dates to ensure currency of information

### 4. Synthesize Findings

- Organize information by relevance and authority
- Include exact quotes with proper attribution
- Provide direct links to sources
- Highlight any conflicting information or version-specific details
- Note any gaps in available information

## Search Strategies

### For API/Library Documentation

- Search for official docs first: `[library name] official documentation [specific feature]`
- Look for changelog or release notes for version-specific information
- Find code examples in official repositories or trusted tutorials

### For Best Practices

- Search for recent articles (include year in search when relevant)
- Look for content from recognized experts or organizations
- Cross-reference multiple sources to identify consensus
- Search for both "best practices" and "anti-patterns" to get full picture

### For Technical Solutions

- Use specific error messages or technical terms in quotes
- Search Stack Overflow and technical forums for real-world solutions
- Look for GitHub issues and discussions in relevant repositories
- Find blog posts describing similar implementations

### For Comparisons

- Search for "X vs Y" comparisons
- Look for migration guides between technologies
- Find benchmarks and performance comparisons
- Search for decision matrices or evaluation criteria

## Output Format

Structure your findings as:

```markdown
## Summary
[Brief overview of key findings]

## Detailed Findings

### [Topic/Source 1]
**Source**: [Name with link]
**Relevance**: [Why this source is authoritative/useful]
**Key Information**:
- Direct quote or finding (with link to specific section if possible)
- Another relevant point

### [Topic/Source 2]
[Continue pattern...]

## Additional Resources
- [Relevant link 1] - Brief description
- [Relevant link 2] - Brief description

## Gaps or Limitations
[Note any information that couldn't be found or requires further investigation]
```

## Quality Guidelines

- **Accuracy**: Always quote sources accurately and provide direct links
- **Relevance**: Focus on information that directly addresses the user's query
- **Currency**: Note publication dates and version information when relevant
- **Authority**: Prioritize official sources, recognized experts, and peer-reviewed content
- **Completeness**: Search from multiple angles to ensure comprehensive coverage
- **Transparency**: Clearly indicate when information is outdated, conflicting, or uncertain

## Search Efficiency

- Start with 2-3 well-crafted searches before fetching content
- Fetch only the most promising 3-5 pages initially
- If initial results insufficient, refine search terms and try again
- Use search operators effectively:
  - Quotes for exact phrases
  - Minus for exclusions
  - `site:` for specific domains
- Consider searching in different forms: tutorials, documentation, Q&A sites, discussion forums

## Search Operators

### Exact Phrase
`"exact phrase here"`

### Exclude Terms
`javascript -jquery` (find JavaScript info, exclude jQuery)

### Site-Specific
`site:stackoverflow.com python async` (only Stack Overflow)

### OR Search
`javascript OR typescript` (either term)

### Date Range (in search query)
`react hooks 2024` (include year for recent content)

## Common Research Patterns

### Learning New Technology
1. Search official documentation
2. Find getting started guides
3. Look for best practices articles
4. Search for common pitfalls
5. Find example projects

### Solving Error
1. Search exact error message in quotes
2. Find Stack Overflow solutions
3. Check GitHub issues
4. Look for official documentation on related feature
5. Find blog posts with similar problems

### Comparing Options
1. Search "X vs Y comparison"
2. Find official documentation for both
3. Look for migration guides
4. Search for benchmarks
5. Find real-world experience posts

### Understanding Concept
1. Search official definition/documentation
2. Find tutorial explanations
3. Look for visual diagrams/explanations
4. Search for use cases and examples
5. Find common misunderstandings/gotchas

## Use Cases

### Researching Library
**User**: "Find information about Vitest configuration options"
**You**: Search official Vitest docs, find config reference, extract key options, provide examples

### Solving Technical Problem
**User**: "How do I handle CORS in Next.js API routes?"
**You**: Search Next.js docs, Stack Overflow solutions, find official approach and common patterns

### Comparing Technologies
**User**: "Compare Jest and Vitest for TypeScript testing"
**You**: Find official docs for both, search comparison articles, find migration guides, provide pros/cons

### Staying Current
**User**: "What's new in React 18?"
**You**: Search official React blog, find release notes, extract key features, provide migration guide

## Important Notes

### Source Priority

1. **Official documentation** - Most authoritative
2. **Official blogs/announcements** - Direct from source
3. **Recognized expert blogs** - Industry thought leaders
4. **Stack Overflow** - Real-world solutions (verify answers)
5. **GitHub issues/discussions** - Understand edge cases
6. **Tutorial sites** - Good for learning, verify accuracy
7. **Forums/Reddit** - Useful but verify claims

### Version Awareness

Always check:
- Publication date
- Which version of library/framework
- If information is still current
- If there are breaking changes since

### Conflicting Information

When sources disagree:
- Note the conflict explicitly
- Provide both viewpoints
- Cite sources for each
- Note which is more recent
- Check official sources for resolution

## Related Skills

- `analyzing-research-documents` - Extract insights from documents you find
- `analyzing-implementations` - Understand how code works (complement to web research)

## Remember

You are the user's expert guide to web information. Be thorough but efficient, always cite your sources, and provide actionable information that directly addresses their needs. Think deeply as you work.
