# Specification Writing Checklist

Copy this checklist and track your progress:

## Pre-Writing
- [ ] Understand the problem domain
- [ ] Identify stakeholders and requirements
- [ ] Review similar existing specifications
- [ ] Gather technical constraints

## Specification Structure
- [ ] Write clear problem statement
- [ ] Define scope and non-goals
- [ ] List functional requirements
- [ ] List non-functional requirements
- [ ] Specify acceptance criteria
- [ ] Define success metrics

## Technical Details
- [ ] Document API contracts (if applicable)
- [ ] Include data models/schemas
- [ ] Specify error handling
- [ ] Define security requirements
- [ ] Document performance requirements

## Review & Validation
- [ ] Technical review completed
- [ ] Stakeholder sign-off obtained
- [ ] Edge cases documented
- [ ] Migration plan (if applicable)

## Finalization
- [ ] Link to related issues/specs
- [ ] Add to project roadmap
- [ ] Update ROADMAP_NEXT_STEPS.md
- [ ] Create implementation issues in MCP
