---
name: debug
description: Expert debugging methodology. Triggers on debug, investigate, fix bug, troubleshoot.
---

# Debug Like an Expert

**Core principle:** VERIFY, DON'T ASSUME. Code you wrote deserves extra skepticism.

## Phase 1: EVIDENCE GATHERING
- Document exact error (full message, stack trace)
- Identify affected components
- Check recent changes (`git diff`, `git log`)
- Research error via context7 MCP if needed

**Output:** Evidence summary
**Gate:** Have reproducible steps before proceeding

## Phase 2: ROOT CAUSE ANALYSIS
- Form 2-3 testable hypotheses
- Test ONE variable at a time
- Read complete files, not snippets
- Chase dependencies to their source

**Output:** Identified root cause with evidence
**Gate:** Can explain WHY the bug occurs

## Phase 3: SOLUTION
- Implement minimal fix
- Verify fix addresses root cause (not symptoms)
- Test original reproduction steps
- Check for regressions

**Output:** Working fix with verification

## Rules
- No fixes without explaining WHY they work
- Never assume - verify every assumption
- Test one change at a time
- Would this fix survive code review?
