---
name: grant-compliance-checking
description: Expert knowledge of research grant compliance requirements, deliverables tracking, and funder expectations. Use when reviewing work against grant specifications, preparing progress reports, or ensuring alignment with funding requirements from NSF, NIH, EU, and other agencies.
---

# Grant Compliance Checking

This skill provides expertise in research grant compliance, helping ensure project developments align with grant deliverables, timelines, and funder requirements.

## Finding Grant Specifications

### Common Locations

Look for grant documents in:
- `/grant/`, `/funding/`, `/proposal/` directories
- Files named: `grant*.md`, `proposal*.md`, `specification*.md`, `award*.md`
- Project management files: `milestones.md`, `deliverables.md`
- README or project documentation mentioning funding
- `.github/` or documentation with award numbers

### Key Information to Extract

**Deliverables:**
- Specific outputs promised (software, papers, datasets, tools)
- Milestones with dates
- Quantitative targets (publications, users, impact metrics)

**Timeline:**
- Project start and end dates
- Interim deadlines and checkpoints
- Reporting schedule

**Requirements:**
- Open access publishing mandates
- Data sharing obligations
- Software licensing constraints
- Collaboration commitments
- Broader impact activities

**Budget:**
- Allowed vs disallowed expenses
- Personnel commitments
- Equipment or infrastructure

## Compliance Review Framework

### Deliverable Alignment

**Questions to assess:**
- Does this work contribute to stated deliverables?
- Which specific deliverable does this address?
- Is this work within the grant scope?
- Does this represent good progress toward milestones?

**Positive indicators:**
- Work directly implements promised features
- Addresses specific objectives from proposal
- Meets interim milestone requirements
- Builds toward final deliverables

**Warning signs:**
- Feature creep beyond grant scope
- Work unrelated to objectives
- Delayed progress on core deliverables
- Resources diverted to non-grant activities

### Scope Compliance

**In scope:**
- Activities described in proposal
- Natural extensions of proposed work
- Bug fixes and maintenance of grant deliverables
- Documentation of grant-funded work

**Potentially out of scope:**
- New features not in proposal
- Unrelated research directions
- Commercial applications not mentioned
- Collaboration outside grant team

**Guidance:**
- Minor scope changes usually acceptable
- Significant changes need funder approval
- Document rationale for any scope evolution
- Keep focus on original objectives

### Timeline Assessment

**On track indicators:**
- Meeting milestone dates
- Steady progress on deliverables
- Documentation keeping pace with development
- Regular outputs (papers, releases)

**Risk factors:**
- Missed interim deadlines
- Delayed starts on major components
- Scope expansion affecting timeline
- Resource constraints slowing work

### Required Documentation

**Track and maintain:**
- Progress reports prepared for funders
- Publication list (with open access status)
- Dataset releases with proper attribution
- Software releases and DOIs
- Presentations and outreach activities
- Collaboration activities
- Training provided
- Broader impact evidence

## Funder-Specific Requirements

### NSF (National Science Foundation)

**Key requirements:**
- Data Management Plan compliance
- Broader Impacts evidence
- Open access publication within 12 months
- Acknowledge NSF support in all outputs
- Annual and final reports required

**Common deliverables:**
- Educational materials
- Community engagement
- Diversity initiatives
- Open-source software
- Public datasets

### NIH (National Institutes of Health)

**Key requirements:**
- Public Access Policy compliance
- Resource sharing plans
- Human subjects/animal protocols
- Clinical trials registration
- Responsible conduct of research training

**Common deliverables:**
- Publications in PubMed Central
- Shared reagents/tools
- Clinical data sharing
- Training materials

### EU Framework Programmes (Horizon Europe, etc.)

**Key requirements:**
- Open Research Data Pilot
- Open access publications (immediate)
- Dissemination and exploitation plans
- Consortium collaboration
- Impact assessment

**Common deliverables:**
- Multi-partner outputs
- Industry engagement
- Policy influence
- Training networks
- International collaboration

### UK Research Councils (UKRI)

**Key requirements:**
- Open research outputs
- Impact case studies
- Public engagement
- Research data management
- Equality, diversity, inclusion

## Compliance Risk Assessment

### High Priority Risks

**Immediate attention needed:**
- Work outside grant scope
- Missed major milestones
- Non-compliance with open access mandates
- Missing required approvals (ethics, data)
- Incorrect grant attribution

### Medium Priority Risks

**Important but manageable:**
- Minor timeline delays
- Documentation gaps
- Underutilized broader impacts
- Incomplete data management
- Limited dissemination

### Low Priority Risks

**Suggestions for improvement:**
- Enhanced impact documentation
- Better progress tracking
- Improved collaboration evidence
- More public engagement
- Future grant positioning

## Grant Terminology

### Common Terms

**Deliverables**: Specific outputs promised in proposal
**Milestones**: Time-bound checkpoints for progress
**Work packages**: Major components of project work
**Broader impacts**: Societal benefits beyond research
**Intellectual merit**: Scientific quality and innovation
**Dissemination**: Sharing results with stakeholders
**Exploitation**: Using results for impact
**TRL (Technology Readiness Level)**: Maturity of technology

### Reporting Language

**Frame work positively:**
- "Achieved milestone X ahead of schedule"
- "Delivered Y exceeding original specifications"
- "Expanded impact through Z"
- "Addressed reviewer feedback by..."

**Address challenges constructively:**
- "Encountered technical challenge with X, resolved by Y"
- "Refined approach based on early findings"
- "Adjusted timeline with improved deliverable quality"
- "Redirected effort to higher-impact activities"

## Documentation Best Practices

### Grant Attribution

**Always include:**
- Grant award number in publications
- Funder acknowledgement in software/datasets
- Proper citation format for funder
- Disclaimer if required (e.g., "views expressed are those of authors")

**Example acknowledgements:**
```
This work was supported by [Funder] under Grant [Number].

This research was funded by [Agency] Grant No. [Number] to [PI].

Funding: This work received support from [Funder] (Grant [Number]).
```

### Progress Documentation

**Maintain evidence of:**
- Publications with grant number
- Software releases with citation
- Dataset publications with DOIs
- Conference presentations
- Collaboration meetings
- Training activities
- Public engagement events
- Media coverage or impact

### Compliance Checklist

For each grant-funded project, verify:
- [ ] Deliverables clearly mapped to current work
- [ ] Timeline alignment tracked
- [ ] Open access compliance for publications
- [ ] Data sharing plan followed
- [ ] Software licensing matches grant terms
- [ ] Grant attribution in all outputs
- [ ] Progress documentation maintained
- [ ] Broader impacts evidence collected
- [ ] Reporting deadlines tracked
- [ ] Budget spent according to plan

## Review Output Structure

When reviewing for grant compliance, provide:

```markdown
## Grant Compliance Assessment

### Deliverable Alignment
[How work relates to specific deliverables]

### Scope Compliance
[Whether work is within grant scope]

### Timeline Impact
[Progress toward milestones]

### Requirements Check
[Open access, data sharing, attribution, etc.]

### Risks Identified
**High Priority**: [Issues needing immediate attention]
**Medium Priority**: [Important considerations]
**Low Priority**: [Suggestions for improvement]

### Recommendations
[Specific actions to maintain or improve compliance]

### Documentation Needs
[What should be recorded for progress reports]
```

## When to Use This Skill

Apply grant compliance expertise when:
- Reviewing code changes or PRs for grant-funded projects
- Preparing progress or final reports
- Planning new features for grant-funded work
- Assessing scope of proposed changes
- Writing publications from grant-funded research
- Planning data or software releases
- Documenting impact and broader outcomes

Help projects maximise grant compliance whilst maintaining research quality and innovation.
Frame work effectively for funders and future proposals.
