# Getting Things Done (GTD) Methodology

> Complete overview of David Allen's GTD system - the foundational methodology for this skill

---

## Core Principle

> "Your mind is for having ideas, not holding them."

By externalizing your thoughts and commitments into a **trusted system**, you free your mental capacity to focus on execution rather than remembering what needs to be done.

---

## The Five-Stage Workflow

### 1. CAPTURE

**Purpose:** Get everything out of your head into a trusted external system.

**Key Principles:**
- Don't organize during capture - Just write it down
- No judgment - Capture it all, decide later
- Mind dump - When starting, externalize all existing open loops

**Why it matters:** Until it's captured in a trusted system, your mind keeps bringing it up.

---

### 2. CLARIFY

**Purpose:** Process each captured item to determine its meaning and required action.

**The Clarifying Questions:**

**Q1: What is it?**
- One-sentence summary

**Q2: Is it actionable?**
- If NO → trash, reference, or someday/maybe
- If YES → Continue

**Q3: What's the desired outcome?**
- Single action → It's a TASK
- Multiple actions → It's a PROJECT

**Q4: What's the next physical action?**
- Must be concrete and visible
- Examples:
  - "Call John at 555-1234 to discuss proposal"
  - NOT "Think about proposal"

**Q5: Where does it belong?**
- What context required?
- What priority?

---

### 3. ORGANIZE

**Purpose:** Put each clarified item into its appropriate location.

**The Eight End Points:**

1. **Trash** - Not needed → Delete
2. **Someday/Maybe** - Not now, but later → Review periodically
3. **Reference** - Non-actionable info → File it
4. **Projects** - Multi-step outcome → Add to projects with next action
5. **Do Immediately** - Takes < 2 min → Just do it (Two-Minute Rule)
6. **Delegate** - Someone else's action → Track in waiting-for
7. **Next Actions** - Organized by context
8. **Calendar** - Date/time specific only

---

### 4. REFLECT (Review)

**Purpose:** Regularly review to keep system current and trusted.

**Daily (Quick Scan):**
- Check calendar
- Review next action lists
- Quick scan of waiting-for

**Weekly (Full Review):**
- **Get Clear:** Process all inboxes to zero
- **Get Current:** Review all projects, ensure next actions defined
- **Get Creative:** Review someday/maybe
- **Get Perspective:** Assess priorities

---

### 5. ENGAGE (Execute)

**Purpose:** Do the work with confidence.

**Four Criteria Model for choosing actions:**

1. **Context** - What can you do given location/tools?
2. **Time Available** - How long do you have?
3. **Energy Available** - What's your mental/physical state?
4. **Priority** - Among available options, what's most important?

```
Context filters available actions
    ↓
Time available narrows the list
    ↓
Energy level refines further
    ↓
Priority determines final selection
```

---

## Key Concepts

### Projects vs. Tasks

**Task (Next Action):** Single physical activity completable in one step.
- "Email John", "Call dentist", "Draft outline"

**Project:** Any outcome requiring more than one action step.
- "Launch website", "Plan vacation"
- Every project MUST have at least one defined next action

### Next Actions

**Good Next Actions:**
- Concrete and specific
- Clearly executable
- Physical (something you can see yourself doing)
- Contextual (defines where/with what tools)

| Bad | Good |
|-----|------|
| "Follow up on proposal" | "Call John at 555-1234 to discuss proposal" |
| "Think about presentation" | "Draft three main points for Q2 presentation" |
| "Website" | "Research three WordPress themes" |

### Contexts

Physical locations or tools required:
- @Computer - Any computer work
- @Office - At office desk
- @Home - Personal tasks at home
- @Phone - Phone calls
- @Errands - Out running errands
- @Anywhere - Any location

### Waiting-For List

Track items delegated or blocked:
- **What** you're waiting for
- **Who** is responsible
- **When** you made the request
- **Follow-up date**

### Someday/Maybe

Ideas not ready to commit to now:
- Review during weekly reflection
- Items either move to active, stay, or get deleted

---

## The Weekly Review

**Get Clear:**
- [ ] Process all inboxes to zero
- [ ] Empty your head - brain dump new items

**Get Current:**
- [ ] Review previous week's calendar
- [ ] Review upcoming calendar (next 2-3 weeks)
- [ ] Review next action lists
- [ ] Review waiting-for list
- [ ] Review all project lists
- [ ] Ensure every project has next action

**Get Creative:**
- [ ] Review someday/maybe list

**Time Required:** 30-60 minutes weekly

---

## Common Pitfalls

1. **Vague Next Actions** - Must be physical and concrete
2. **Projects Without Next Actions** - Every project needs defined next step
3. **Using Calendar as To-Do List** - Only date-specific items on calendar
4. **Too Many Active Projects** - Limit to 3-5 per area
5. **Not Processing Inbox** - Process to zero at least 3x per week
6. **Skipping Weekly Review** - Non-negotiable for system health

---

## The GTD Workflow Diagram

```
STUFF (inputs)
    ↓
CAPTURE (inbox)
    ↓
CLARIFY: Is it actionable?
    ├─ NO → Reference / Someday-Maybe / Trash
    └─ YES → What's the outcome?
            ├─ Single action → NEXT ACTION (by context)
            └─ Multiple actions → PROJECT
                                   ↓
                        Define desired outcome
                                   ↓
                        Identify next physical action
                                   ↓
                           ORGANIZE appropriately
                                   ↓
                            REFLECT regularly
                                   ↓
                              ENGAGE with confidence
```

---

## Success Indicators

**GTD is working when:**
- Your mind feels clear
- You can focus on the task at hand
- You trust nothing is falling through cracks
- You can quickly answer "What should I be doing right now?"

**Warning signs:**
- Thinking "I should really..." repeatedly
- Items in inbox are >1 week old
- Haven't done weekly review in >2 weeks
- Projects don't have clear next actions
