# Estimation Guide

> 작업량 산정 기준 (assign-task Skill Reference)

## Point 체계

| Point | 소요 시간 | 설명 |
|-------|----------|------|
| 1 | 0.5일 (4시간) | 단순 작업 |
| 2 | 1일 (8시간) | 일반 작업 |
| 3 | 1.5일 | 복잡한 작업 |
| 5 | 2.5일 | 매우 복잡한 작업 |
| 8 | 4일 | 분리 검토 필요 |

> **원칙**: 1 Point = 0.5일 (4시간)

## 작업 유형별 기본 Point

### Backend

| 작업 유형 | Point | 예시 |
|----------|-------|------|
| DTO/Entity 추가 | 1 | Request/Response DTO 작성 |
| 간단한 CRUD API | 2 | 단일 엔드포인트 구현 |
| 복잡한 비즈니스 로직 | 3 | 여러 서비스 연동, 트랜잭션 |
| 외부 API 연동 | 3 | 3rd party 서비스 통합 |
| 배치/스케줄러 | 3-5 | 주기적 작업 구현 |

### Frontend

| 작업 유형 | Point | 예시 |
|----------|-------|------|
| 컴포넌트 스타일링 | 1 | UI 수정, CSS 작업 |
| 폼 컴포넌트 구현 | 2 | 입력 폼 + 유효성 검사 |
| 페이지 구현 | 2-3 | 새 페이지 + API 연동 |
| 복잡한 상태관리 | 3 | 전역 상태, 복잡한 플로우 |
| 애니메이션/인터랙션 | 2-3 | 고급 UX 구현 |

### Infra/DevOps

| 작업 유형 | Point | 예시 |
|----------|-------|------|
| 환경변수 추가 | 1 | .env 설정 |
| Docker 설정 수정 | 2 | Dockerfile, compose |
| CI/CD 파이프라인 | 3 | GitHub Actions 수정 |
| 인프라 프로비저닝 | 5 | 새 서비스 배포 |

### QA/Testing

| 작업 유형 | Point | 예시 |
|----------|-------|------|
| 단위 테스트 | 1 | 함수별 테스트 |
| 통합 테스트 | 2 | API 통합 테스트 |
| E2E 테스트 | 3 | 시나리오 테스트 |
| 성능 테스트 | 3 | 부하 테스트 |

## 복잡도 가중치

### 복잡도 판단 기준

| 요소 | 가중치 |
|------|--------|
| 외부 의존성 | +1 |
| DB 스키마 변경 | +1 |
| 보안 고려 필요 | +1 |
| 기존 코드 리팩토링 | +1 |
| 문서화 필요 | +0.5 |

### 계산 예시

```
기본 Point: 2 (API 엔드포인트 구현)
+ 외부 API 연동: +1
+ DB 스키마 변경: +1
= 최종 Point: 4
```

## 자동 산정 규칙

### 키워드 매칭

assign-task Skill이 이슈 본문/제목에서 키워드를 감지하여 자동 산정:

```javascript
const keywordPoints = {
  // 낮은 복잡도 (1점)
  'config': 1, '설정': 1, 'env': 1, 'lint': 1,
  'typo': 1, '오타': 1, 'rename': 1,

  // 일반 복잡도 (2점)
  'api': 2, 'endpoint': 2, 'crud': 2,
  'component': 2, '컴포넌트': 2,
  'form': 2, '폼': 2,

  // 높은 복잡도 (3점)
  'integration': 3, '연동': 3,
  'migration': 3, '마이그레이션': 3,
  'refactor': 3, '리팩토링': 3,

  // 매우 높은 복잡도 (5점)
  'architecture': 5, '아키텍처': 5,
  'security': 5, '보안': 5
};
```

### 라벨 기반 보정

| 라벨 | Point 보정 |
|------|-----------|
| `priority:critical` | +1 |
| `complexity:high` | +1 |
| `complexity:low` | -1 |
| `bug` | 기본값 유지 |

## 산정 결과 포맷

### 이슈 본문 체크리스트

```markdown
## 📊 작업량 산정

- [ ] API 엔드포인트 구현: 2점
- [ ] DTO 클래스 작성: 1점
- [ ] 테스트 코드 작성: 1점

**총점: 4점** (예상 소요: 2일)

---
_Generated by SEMO assign-task Skill_
```

### Project 필드 (작업량)

- **타입**: Number
- **값**: 총점 (정수)
- **예시**: `4`

## 참고

- [estimate-epic-timeline](../../../semo-core/skills/estimate-epic-timeline/SKILL.md) - Epic 전체 일정 산정
- [complete-draft-task](../../../semo-core/skills/complete-draft-task/SKILL.md) - Estimation 포함 Task 완성
