# Fast-Track 카테고리 가이드

> Fast-Track 작업 분류 및 카테고리별 처리 가이드

## 카테고리 개요

| 카테고리 | 라벨 | 이모지 | 설명 |
|----------|------|--------|------|
| 오타/문구 수정 | `typo` | ✏️ | 텍스트 오류 교정 |
| 스타일 미세조정 | `style` | 🎨 | UI 미세 조정 |
| 버그 핫픽스 | `hotfix` | 🔥 | 긴급 버그 수정 |
| 코드 정리 | `chore` | 🧹 | 린트, 정리 작업 |

## 카테고리별 상세

### ✏️ 오타/문구 수정 (`typo`)

텍스트 관련 오류를 수정하는 작업입니다.

#### 포함 범위

| 작업 | 예시 | 적격 |
|------|------|------|
| 오타 수정 | "로그읜" → "로그인" | ✅ |
| 띄어쓰기 수정 | "제출 하기" → "제출하기" | ✅ |
| 문구 개선 | "확인" → "저장하기" | ✅ |
| 번역 오류 | "Cancel" → "취소" (누락된 번역) | ✅ |
| 주석 오타 | `// 로그읜 처리` → `// 로그인 처리` | ✅ |
| 변수명 오타 | `const loign` → `const login` | ⚠️ 영향도 확인 |

#### 체크포인트

- [ ] 변경하는 텍스트가 하드코딩인가 i18n인가?
- [ ] 동일 오타가 다른 곳에도 있는가? (3개 이하 확인)
- [ ] 변수명/함수명 수정 시 전체 영향도 확인

#### 커밋 메시지 예시

```
🏃 [Fast-Track] 로그인 페이지 오타 수정

- LoginButton.tsx: "로그읜" → "로그인"
```

---

### 🎨 스타일 미세조정 (`style`)

CSS/스타일 관련 미세 조정 작업입니다.

#### 포함 범위

| 작업 | 예시 | 적격 |
|------|------|------|
| 간격 조정 | `padding: 16px` → `padding: 14px` | ✅ |
| 색상 미세 조정 | `#333` → `#2d2d2d` | ✅ |
| 폰트 크기 조정 | `14px` → `15px` | ✅ |
| z-index 수정 | 겹침 문제 해결 | ✅ |
| 레이아웃 변경 | flex → grid | ❌ |
| 반응형 추가 | 새 브레이크포인트 | ❌ |

#### 적격 기준

```
✅ 적격:
- 기존 디자인 의도 유지
- 1-5px 범위의 간격 조정
- 미세한 색상 조정 (#000 → #111 수준)

❌ 부적격:
- 새 디자인 패턴 도입
- 레이아웃 구조 변경
- 애니메이션 추가/제거
```

#### 커밋 메시지 예시

```
🏃 [Fast-Track] 헤더 간격 미세 조정

- Header.tsx: 패딩 16px → 14px (디자인 정렬)
```

---

### 🔥 버그 핫픽스 (`hotfix`)

명확한 원인의 단순 버그를 긴급 수정하는 작업입니다.

#### 포함 범위

| 작업 | 예시 | 적격 |
|------|------|------|
| null 체크 누락 | `user.name` → `user?.name` | ✅ |
| 조건문 오류 | `if (a = b)` → `if (a === b)` | ✅ |
| 이벤트 핸들러 누락 | onClick 미연결 | ✅ |
| 의존성 배열 오류 | useEffect deps 수정 | ⚠️ 영향도 확인 |
| API 엔드포인트 오타 | `/api/usr` → `/api/user` | ✅ |
| 로직 변경 | 비즈니스 로직 수정 | ❌ |
| 새 에러 처리 | try-catch 추가 | ❌ |

#### 적격 기준

```
✅ 적격:
- 원인이 명확함 (코드 보면 바로 알 수 있음)
- 수정이 단순함 (1-5줄 수정)
- 원래 의도한 동작으로 복구

❌ 부적격:
- 원인 파악에 디버깅 필요
- 수정 범위가 광범위
- 기존 동작 변경 필요
```

#### 긴급도 판단

| 상황 | 긴급도 | 조치 |
|------|--------|------|
| 프로덕션 영향 | 🔴 긴급 | 즉시 Fast-Track |
| 개발 환경만 영향 | 🟡 보통 | Fast-Track 가능 |
| 엣지 케이스 | 🟢 낮음 | 일반 프로세스 고려 |

#### 커밋 메시지 예시

```
🏃 [Fast-Track] 프로필 페이지 null 에러 수정

- ProfileCard.tsx: user?.name 옵셔널 체이닝 추가
- 문제: 로그아웃 상태에서 접근 시 에러 발생
```

---

### 🧹 코드 정리 (`chore`)

코드 품질 개선을 위한 정리 작업입니다.

#### 포함 범위

| 작업 | 예시 | 적격 |
|------|------|------|
| unused import 제거 | `import { unused } from...` | ✅ |
| console.log 제거 | 디버깅 코드 정리 | ✅ |
| lint 경고 수정 | ESLint 규칙 준수 | ✅ |
| 타입 오류 수정 | TypeScript 에러 해결 | ⚠️ 영향도 확인 |
| 포매팅 수정 | Prettier 적용 | ✅ |
| 리팩토링 | 함수 분리, 구조 변경 | ❌ |

#### 적격 기준

```
✅ 적격:
- 동작 변경 없음
- IDE/린터 경고 해결
- 불필요한 코드 제거

❌ 부적격:
- 코드 구조 변경
- 새 패턴 도입
- 성능 최적화 (측정 필요)
```

#### 커밋 메시지 예시

```
🏃 [Fast-Track] 미사용 import 정리

- utils/index.ts: 3개의 unused import 제거
- components/Button.tsx: console.log 제거
```

---

## 카테고리 선택 플로우

```
작업 내용 확인
    │
    ├─ 텍스트/문구 관련? → ✏️ typo
    │
    ├─ CSS/스타일 관련? → 🎨 style
    │
    ├─ 버그/오류 수정? → 🔥 hotfix
    │
    ├─ 코드 정리/린트? → 🧹 chore
    │
    └─ 해당 없음? → ❌ Fast-Track 부적격
```

## 카테고리별 주의사항

### typo 주의사항

- i18n 파일 수정 시 모든 언어 파일 확인
- 변수명 수정은 IDE 리팩토링 기능 활용 권장
- 동일 오타 검색으로 누락 방지

### style 주의사항

- 디자인 시스템 토큰 사용 여부 확인
- 반응형 영향 확인
- 스크린샷 첨부 권장

### hotfix 주의사항

- 프로덕션 영향 시 배포 우선순위 조정
- 재발 방지를 위한 테스트 추가 고려
- 원인 분석 내용 이슈에 기록

### chore 주의사항

- 타입 변경은 빌드 확인 필수
- 대량 포매팅은 별도 커밋 권장
- unused 제거 시 export 확인

## 복합 카테고리 처리

하나의 작업이 여러 카테고리에 해당하는 경우:

### 우선순위

1. `hotfix` (버그 수정이 포함되면 최우선)
2. `typo` (텍스트 변경이 주요 목적)
3. `style` (스타일 변경이 주요 목적)
4. `chore` (정리 작업이 주요 목적)

### 예시

```
"버튼 오타 수정하면서 패딩도 조금 조정"
→ 주요 목적: 오타 수정
→ 카테고리: typo
→ 라벨: fast-track, typo

"null 에러 수정하면서 console.log도 제거"
→ 주요 목적: 버그 수정
→ 카테고리: hotfix
→ 라벨: fast-track, hotfix
```
