# Fast-Track 적격성 체크 가이드

> 작업이 Fast-Track 프로세스에 적합한지 판단하는 상세 기준

## 적격성 4대 조건

모든 조건을 **동시에 충족**해야 Fast-Track 적격입니다.

### 1. 영향 범위 (Scope)

**기준**: 수정 파일 **3개 이하**

| 파일 수 | 판정 | 비고 |
|---------|------|------|
| 1개 | ✅ 적격 | 이상적인 Fast-Track |
| 2-3개 | ✅ 적격 | 연관 파일 포함 가능 |
| 4개 이상 | ❌ 부적격 | 일반 프로세스 필요 |

**체크 방법**:
```bash
# 예상 변경 파일 확인
git diff --stat  # 이미 변경한 경우
# 또는 변경 계획 파일 목록 작성
```

**예외 상황**:
- import 정리로 여러 파일 터치 → 부적격 (리팩토링 성격)
- 동일 컴포넌트의 .tsx + .test.tsx + .stories.tsx → 3개로 카운트

### 2. 기능 변경 여부 (Behavior)

**기준**: 사용자 관점에서 **동작 변화 없음**

| 변경 유형 | 판정 | 예시 |
|-----------|------|------|
| 텍스트만 변경 | ✅ 적격 | 오타 수정, 문구 개선 |
| 스타일만 변경 | ✅ 적격 | 색상, 간격, 폰트 미세 조정 |
| 버그 수정 (의도대로 동작) | ✅ 적격 | 원래 의도한 동작으로 복구 |
| 새 기능 추가 | ❌ 부적격 | 버튼 추가, 페이지 추가 |
| 기존 기능 변경 | ❌ 부적격 | 로직 변경, 플로우 수정 |
| API 변경 | ❌ 부적격 | 엔드포인트, 파라미터 변경 |

**체크 질문**:
- "이 변경 후 사용자가 다르게 행동해야 하나요?" → Yes면 부적격
- "QA 시나리오가 변경되나요?" → Yes면 부적격

### 3. 테스트 영향 (Test Impact)

**기준**: 기존 테스트 **수정 불필요**

| 상황 | 판정 | 이유 |
|------|------|------|
| 테스트 통과 유지 | ✅ 적격 | 기능 변경 없음 증명 |
| 테스트 assertion 수정 필요 | ❌ 부적격 | 기능 변경 의미 |
| 새 테스트 추가 필요 | ❌ 부적격 | 새 기능/시나리오 의미 |
| 스냅샷 테스트 업데이트 | ⚠️ 조건부 | 텍스트/스타일만 변경이면 적격 |

**체크 방법**:
```bash
# 기존 테스트 실행
npm run test

# 테스트 실패 시 → 부적격 가능성 높음
# 스냅샷 업데이트만 필요 → 적격 (텍스트/스타일 변경)
```

### 4. 소요 시간 (Duration)

**기준**: **30분 이내** 완료 가능

| 예상 시간 | 판정 | 권장 |
|-----------|------|------|
| ~15분 | ✅ 적격 | 이상적 |
| 15-30분 | ✅ 적격 | 적절한 범위 |
| 30분-1시간 | ⚠️ 경계 | 재검토 권장 |
| 1시간+ | ❌ 부적격 | 일반 프로세스 |

**시간 산정 포함 항목**:
- 코드 수정 시간
- 로컬 테스트 시간
- 커밋/PR 생성 시간
- 이슈 생성 시간 (Step 3)

## 카테고리별 적격성

### ✅ 항상 적격

| 카테고리 | 설명 | 예시 |
|----------|------|------|
| 오타 수정 | 텍스트 오류 교정 | "로그읜" → "로그인" |
| 문구 개선 | 더 나은 표현으로 변경 | "확인" → "저장하기" |
| 주석 수정 | 주석 오류/개선 | JSDoc 오타 수정 |
| lint 수정 | 린터 경고 해결 | unused import 제거 |

### ⚠️ 조건부 적격

| 카테고리 | 적격 조건 | 부적격 조건 |
|----------|-----------|-------------|
| 스타일 수정 | 1-2px 간격, 미세 색상 | 레이아웃 변경, 새 디자인 |
| 버그 수정 | 명확한 원인, 단순 수정 | 복잡한 원인, 광범위 영향 |
| 성능 개선 | 단순 memo 추가 | 아키텍처 변경 필요 |
| 접근성 수정 | aria-label 추가 | 컴포넌트 구조 변경 |

### ❌ 항상 부적격

| 카테고리 | 이유 | 대안 |
|----------|------|------|
| 새 기능 | 기획/QA 필요 | Epic→Task 프로세스 |
| DB 변경 | 마이그레이션 필요 | 기술 Epic 생성 |
| API 변경 | 영향도 분석 필요 | 기술 Epic 생성 |
| 인증/보안 | 리스크 검토 필요 | 보안 검토 프로세스 |
| 리팩토링 | 광범위 영향 | 기술 부채 Epic |

## 판정 플로우차트

```
작업 요청 수신
    │
    ▼
파일 수 3개 이하?
    │
    ├─ No → ❌ 부적격 (일반 프로세스)
    │
    ▼ Yes
    │
기능 변경 없음?
    │
    ├─ No → ❌ 부적격 (Epic 필요)
    │
    ▼ Yes
    │
테스트 수정 불필요?
    │
    ├─ No → ⚠️ 재검토 (스냅샷만이면 OK)
    │
    ▼ Yes
    │
30분 이내 완료?
    │
    ├─ No → ❌ 부적격 (범위 축소 검토)
    │
    ▼ Yes
    │
✅ Fast-Track 적격!
```

## 경계 케이스 판단

### Case 1: "여러 파일의 동일 오타"

**상황**: 10개 파일에 같은 오타 존재
**판정**: ❌ 부적격 (파일 수 초과)
**대안**: 범위 축소하여 3개씩 여러 Fast-Track으로 분리

### Case 2: "버그 수정인데 테스트 실패"

**상황**: 버그 수정 후 기존 테스트 실패
**판정**: ⚠️ 재검토 필요
- 테스트가 버그를 검증하고 있었다면 → 적격 (테스트도 수정)
- 테스트가 다른 기능을 검증한다면 → 부적격 (영향도 큼)

### Case 3: "간단한데 시간 오래 걸림"

**상황**: 오타 1개인데 빌드 시간이 30분
**판정**: ✅ 적격 (실제 작업은 단순)
**비고**: 빌드/배포 시간은 소요 시간에서 제외

## 적격성 체크리스트 템플릿

```markdown
## Fast-Track 적격성 체크

### 작업 내용
{작업 설명}

### 4대 조건 체크

- [ ] **영향 범위**: 수정 파일 ___개 (3개 이하)
  - 파일1: {경로}
  - 파일2: {경로}
  - 파일3: {경로}

- [ ] **기능 변경**: 없음 / 있음
  - 사용자 동작 변화: 없음 / 있음
  - QA 시나리오 변경: 없음 / 있음

- [ ] **테스트 영향**: 없음 / 있음
  - 기존 테스트: 통과 / 실패
  - 필요 조치: 없음 / 스냅샷 업데이트 / 테스트 수정

- [ ] **소요 시간**: ___분 (30분 이하)

### 판정

✅ Fast-Track 적격 / ❌ 일반 프로세스 필요

### 카테고리
- [ ] 오타/문구 수정
- [ ] 스타일 미세조정
- [ ] 버그 핫픽스
- [ ] 코드 정리
- [ ] 기타: ___
```
