# Fast-Track 이슈 템플릿

> 작업 완료 후 GitHub Issue 생성을 위한 템플릿

## 이슈 생성 목적

Fast-Track은 Epic→Task 프로세스를 생략하지만, **사후 보고**는 필수입니다.

- PO에게 변경사항 가시성 제공
- 팀 내 변경 이력 추적
- 관련 이슈/PR 연결 가능

## GitHub Issue 템플릿

### 제목 형식

```
[Fast-Track] {카테고리}: {작업 요약}
```

**예시**:
- `[Fast-Track] 오타수정: 로그인 버튼 텍스트 오타`
- `[Fast-Track] 핫픽스: 모달 닫기 버튼 동작 안함`
- `[Fast-Track] 스타일: 헤더 간격 조정`

### 본문 템플릿

```markdown
## Fast-Track 수정 보고

### 카테고리
<!-- 해당하는 항목에 체크 -->
- [ ] 오타/문구 수정
- [ ] 스타일 미세조정
- [ ] 버그 핫픽스
- [ ] 코드 정리
- [ ] 기타: ___

### 변경 내용
<!-- 무엇을 왜 변경했는지 간략히 설명 -->
{변경 사항 요약}

### 수정 파일
<!-- 변경된 파일 목록과 변경 내용 -->
| 파일 | 변경 내용 |
|------|-----------|
| `{경로}` | {설명} |

### 변경 전/후 (해당시)
<!-- 텍스트 변경이나 UI 변경의 경우 -->
**변경 전**: {이전 상태}
**변경 후**: {이후 상태}

### 스크린샷 (해당시)
<!-- UI 변경의 경우 스크린샷 첨부 -->

---

## 🧪 테스트 요구사항

### 엔지니어 테스트
<!-- speckit.implement 단계에서 테스트케이스로 작성하여 검증 -->
- [ ] {테스트 케이스 1}: {예상 결과}
- [ ] {테스트 케이스 2}: {예상 결과}

### QA 테스트
<!-- QA가 수동으로 검증할 유스케이스 -->
| Step | Action | Expected Result |
|------|--------|-----------------|
| 1 | {수행 동작} | {예상 결과} |
| 2 | {수행 동작} | {예상 결과} |

---

### 관련 커밋/PR
<!-- 커밋 해시 또는 PR 링크 -->
- 커밋: {hash}
- PR: #{number}

---
> 🏃 이 이슈는 **Fast-Track 프로세스**로 사후 생성되었습니다.
> Epic 연결 없이 개발자 주도로 처리된 경미한 수정입니다.
```

## 라벨 규칙

### 필수 라벨

| 라벨 | 설명 | 색상 권장 |
|------|------|-----------|
| `fast-track` | Fast-Track 프로세스 표시 | `#7057ff` (보라) |

### 카테고리 라벨 (택 1)

| 라벨 | 적용 상황 |
|------|-----------|
| `typo` | 오타/문구 수정 |
| `hotfix` | 버그 핫픽스 |
| `style` | 스타일 미세조정 |
| `chore` | 코드 정리, 린트 수정 |

### 라벨 예시

```
fast-track, typo          # 오타 수정
fast-track, hotfix        # 버그 핫픽스
fast-track, style         # 스타일 조정
fast-track, chore         # 코드 정리
```

## gh CLI 명령어

### 이슈 생성

```bash
gh issue create \
  --title "[Fast-Track] 오타수정: 로그인 버튼 텍스트" \
  --label "fast-track,typo" \
  --body "$(cat <<'EOF'
## Fast-Track 수정 보고

### 카테고리
- [x] 오타/문구 수정

### 변경 내용
로그인 버튼의 "로그읜" 오타를 "로그인"으로 수정

### 수정 파일
| 파일 | 변경 내용 |
|------|-----------|
| `src/components/LoginButton.tsx` | 버튼 텍스트 수정 |

### 변경 전/후
**변경 전**: 로그읜
**변경 후**: 로그인

---

## 🧪 테스트 요구사항

### 엔지니어 테스트
- [x] LoginButton 컴포넌트 렌더링 시 "로그인" 텍스트 표시 확인

### QA 테스트
| Step | Action | Expected Result |
|------|--------|-----------------|
| 1 | 로그인 페이지 접속 | 로그인 버튼에 "로그인" 텍스트 표시 |

---

### 관련 커밋/PR
- 커밋: abc1234

---
> 🏃 이 이슈는 **Fast-Track 프로세스**로 사후 생성되었습니다.
EOF
)"
```

### 이슈 생성 후 커밋에 연결

```bash
# 커밋 메시지에 이슈 번호 포함
git commit -m "🏃 [Fast-Track] 로그인 버튼 오타 수정

- '로그읜' → '로그인' 텍스트 수정

Closes #{issue_number}

🤖 Generated with [Claude Code](https://claude.com/claude-code)

Co-Authored-By: Claude <noreply@anthropic.com>"
```

## 자동 생성 가이드

SEMO가 이슈를 자동 생성할 때 사용하는 형식:

### SEMO 이슈 생성 출력

```
[SEMO] fast-track 완료 → 이슈 생성

📋 생성할 이슈:
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
제목: [Fast-Track] {카테고리}: {요약}
라벨: fast-track, {카테고리_라벨}
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

본문 미리보기:
┌────────────────────────────────
│ ## Fast-Track 수정 보고
│
│ ### 카테고리
│ - [x] {선택된 카테고리}
│
│ ### 변경 내용
│ {작업 설명}
│
│ ### 수정 파일
│ - `{파일1}`: {변경내용}
│ - `{파일2}`: {변경내용}
│
│ ### 관련 커밋
│ - {커밋 해시}
└────────────────────────────────

이슈를 생성할까요? (Y/n)
```

### 사용자 확인 후 생성

```bash
# Y 선택 시 자동 실행
gh issue create \
  --title "[Fast-Track] {카테고리}: {요약}" \
  --label "fast-track,{카테고리_라벨}" \
  --body "{본문}"
```

## 커밋 메시지 규칙

Fast-Track 작업의 커밋 메시지는 다음 형식을 따릅니다:

### 형식

```
🏃 [Fast-Track] {작업 요약}

- {변경 상세 1}
- {변경 상세 2}

{관련 이슈 연결}

🤖 Generated with [Claude Code](https://claude.com/claude-code)

Co-Authored-By: Claude <noreply@anthropic.com>
```

### 예시

```
🏃 [Fast-Track] 로그인 페이지 오타 수정

- LoginButton.tsx: "로그읜" → "로그인"
- LoginForm.tsx: "비밀먼호" → "비밀번호"

Closes #123

🤖 Generated with [Claude Code](https://claude.com/claude-code)

Co-Authored-By: Claude <noreply@anthropic.com>
```

## 이슈-커밋 연결 전략

### 옵션 1: 이슈 먼저 생성 (권장)

1. 작업 완료
2. 이슈 생성 → 번호 획득 (#123)
3. 커밋 시 `Closes #123` 포함
4. PR 또는 직접 푸시

### 옵션 2: 커밋 먼저, 이슈 나중

1. 작업 완료
2. 커밋 (이슈 번호 없이)
3. 푸시
4. 이슈 생성 시 커밋 해시 언급
5. 이슈에서 커밋 참조

### SEMO 기본 동작

SEMO는 **옵션 1**을 기본으로 사용합니다:
1. 작업 완료 확인
2. 이슈 생성 제안
3. 사용자 확인 후 이슈 생성
4. 이슈 번호를 포함한 커밋 메시지 생성
5. 커밋 및 푸시
