---
name: frontend-design
description: 차별화된 프로덕션 수준의 프론트엔드 UI 설계 및 구현. Use when (1) UI/UX 디자인 필요, (2) 컴포넌트 디자인, (3) 화면 설계 및 구현, (4) Design Thinking 기반 프론트엔드 개발.
tools: [Read, Write, Edit, Bash]
---

> **🔔 시스템 메시지**: 이 Skill이 호출되면 `[SEMO] Skill: frontend-design 실행 - {Phase}` 시스템 메시지를 첫 줄에 출력하세요.

# frontend-design Skill

> 차별화된 프로덕션 수준의 프론트엔드 UI를 설계하고 구현

## Purpose

**일반적인 AI 미학을 피하고**, 의도적이고 차별화된 프론트엔드 인터페이스를 설계 및 구현합니다.

### 핵심 철학

> "Bold maximalism and refined minimalism both work - the key is intentionality, not intensity."

| 추구 | 회피 |
|------|------|
| 의도적인 디자인 결정 | 디폴트 설정 그대로 사용 |
| 기억에 남는 차별점 | 쿠키커터 템플릿 |
| 프로덕션 수준 품질 | 프로토타입 수준 |
| 팀 디자인 시스템 준수 | 임의의 스타일 |

## Workflow

### Phase 1: Design Thinking (코딩 전 필수)

코드 작성 전 **반드시** 다음을 정의합니다:

1. **목적 (Purpose)**: 이 인터페이스가 해결할 문제는?
2. **톤 (Aesthetic Direction)**: Minimal/Bold/Professional/Playful/Premium 중 선택
3. **차별점 (Memorable Element)**: 경쟁 서비스와 구분되는 시각적 특징
4. **제약사항 (Constraints)**: 기술 스택, 반응형 요구사항, 접근성 수준

### Phase 2: Production Code

Design Thinking 완료 후 구현:
- 타이포그래피 선택
- 색상 시스템 정의
- 모션 & 인터랙션
- 공간 & 레이아웃

### Phase 3: Quality Check

- [ ] 제네릭 폰트 사용 안함
- [ ] 진부한 색상 조합 회피
- [ ] 차별화 요소 존재
- [ ] 반응형 테스트 완료
- [ ] 접근성 검증

## References

- [Design Thinking Guide](references/design-thinking.md) - Phase 1 상세 가이드
- [Anti-Pattern Catalog](references/anti-patterns.md) - 피해야 할 패턴 목록
- [Component Patterns](references/component-patterns.md) - 재사용 가능한 패턴
