# Design Thinking Guide

> 코딩 전 필수 디자인 사고 프로세스

## 개요

**Design Thinking**은 코드 작성 전 반드시 수행해야 하는 단계입니다. 이 단계를 생략하면 "AI가 만든 것 같은" 일반적인 결과물이 나옵니다.

## 4가지 핵심 질문

### 1. Purpose (목적)

> "이 인터페이스가 해결할 문제는 무엇인가?"

#### 체크리스트

- [ ] 타겟 사용자 정의됨
- [ ] 핵심 사용자 여정(journey) 파악됨
- [ ] 성공 지표 정의됨
- [ ] 실패 시나리오 고려됨

#### 질문 예시

```markdown
**타겟 사용자**:
- 페르소나: 30대 직장인, 모바일 중심 사용
- 기술 수준: 중급 (앱 사용 익숙)
- 핵심 니즈: 빠른 정보 확인, 간편한 조작

**핵심 여정**:
1. 앱 진입 → 2. 대시보드 확인 → 3. 상세 정보 → 4. 액션 수행

**성공 지표**:
- 대시보드 → 액션 완료까지 3탭 이내
- 핵심 정보 5초 내 인지
```

### 2. Tone (미학적 방향)

> "이 인터페이스의 성격은 무엇인가?"

#### 톤 스펙트럼

| 톤 | 특징 | 적합한 상황 |
|----|------|-------------|
| **Minimal & Clean** | 여백 중심, 필수 요소만, 고요함 | 생산성 도구, 독서 앱 |
| **Bold & Vibrant** | 강렬한 색상, 대담한 타이포 | 마케팅, 랜딩페이지 |
| **Professional & Trust** | 안정감, 신뢰성, 보수적 | 금융, 의료, B2B |
| **Playful & Friendly** | 친근함, 재미 요소, 둥근 형태 | 소셜, 게이미피케이션 |
| **Premium & Luxury** | 정제된 디테일, 고급스러움 | 프리미엄 서비스, 패션 |
| **Brutalist & Raw** | 노출된 구조, 의도적 거칠음 | 아트, 실험적 프로젝트 |

#### 톤 결정 가이드

```markdown
질문 1: 사용자가 느끼길 원하는 감정은?
→ 신뢰 / 흥분 / 편안함 / 전문성 / 재미

질문 2: 경쟁 서비스의 톤은?
→ 동일하게 갈 것인가 / 차별화할 것인가

질문 3: 브랜드 가이드라인이 있는가?
→ 있다면 준수 / 없다면 새로 정의
```

### 3. Differentiator (차별점)

> "What's the one thing someone will remember?"

#### 차별화 요소 카테고리

| 카테고리 | 예시 |
|----------|------|
| **모션** | 독특한 페이지 전환, 마이크로 인터랙션 |
| **레이아웃** | 비대칭 그리드, 풀스크린 섹션 |
| **타이포그래피** | 오버사이즈 헤드라인, 커스텀 폰트 |
| **색상** | 시그니처 컬러, 그래디언트 패턴 |
| **일러스트** | 커스텀 아이콘, 캐릭터 |
| **사운드** | 알림음, 인터랙션 피드백 |

#### 차별점 정의 템플릿

```markdown
**기억에 남을 요소**:
{구체적으로 기술}

**구현 방법**:
- 기술적 접근: {CSS/JS/라이브러리}
- 예상 난이도: 낮음/중간/높음
- 성능 영향: 최소/보통/주의필요

**경쟁사와의 차이**:
| 우리 | 경쟁 A | 경쟁 B |
|------|-------|-------|
| {차별점} | {그들의 접근} | {그들의 접근} |
```

### 4. Constraints (제약사항)

> "무엇이 불가능하고, 무엇이 필수인가?"

#### 기술적 제약

```markdown
**필수 스택**:
- Framework: Next.js 14+ (App Router)
- Styling: Tailwind CSS + shadcn/ui
- Animation: Framer Motion (선택)

**성능 요구사항**:
- LCP: < 2.5s
- FID: < 100ms
- CLS: < 0.1
- 번들 사이즈: < 200KB (초기 로드)

**브라우저 지원**:
- Chrome 90+
- Safari 14+
- Firefox 90+
- Edge 90+
- 모바일 Safari/Chrome
```

#### 접근성 제약

```markdown
**WCAG 준수 수준**: AA / AAA

**필수 준수 항목**:
- [ ] 색상 대비 4.5:1 이상
- [ ] 키보드 네비게이션 완전 지원
- [ ] 스크린리더 호환
- [ ] 포커스 표시 명확
- [ ] 터치 타겟 44x44px 이상
```

#### 브랜드 제약

```markdown
**브랜드 가이드라인**:
- 로고 사용 규칙: {링크 또는 설명}
- 색상 팔레트: {정의된 색상}
- 폰트: {지정된 폰트}
- 금지 요소: {사용 불가 항목}
```

## Design Thinking 출력 템플릿

```markdown
# Design Thinking: {프로젝트/기능명}

## 1. Purpose
**타겟 사용자**: {페르소나 설명}
**핵심 문제**: {해결할 문제}
**성공 지표**: {측정 가능한 지표}

## 2. Tone
**선택한 톤**: {톤 이름}
**선택 이유**: {근거}
**참고 사례**: {유사한 좋은 예시}

## 3. Differentiator
**기억에 남을 요소**: {구체적 설명}
**구현 계획**: {기술적 접근}

## 4. Constraints
**기술 스택**: Next.js + Tailwind + shadcn/ui
**성능 목표**: LCP < 2.5s
**접근성**: WCAG AA
**특수 요구사항**: {있다면 기술}

---
✅ Design Thinking 완료 - Production 단계로 진행
```

## 일반적인 실수와 해결책

### 실수 1: 톤 생략

```markdown
❌ BAD: "대시보드 만들어줘" → 바로 코딩 시작

✅ GOOD: "대시보드 만들어줘"
→ "어떤 느낌의 대시보드를 원하시나요?"
→ 톤 결정 후 코딩 시작
```

### 실수 2: 모호한 차별점

```markdown
❌ BAD: "예쁘게 만들어줘"

✅ GOOD: "카드 호버 시 미묘한 그림자 확대와
         위로 2px 이동하는 인터랙션 적용"
```

### 실수 3: 제약사항 무시

```markdown
❌ BAD: 멋진 애니메이션 추가 → 성능 저하

✅ GOOD: 성능 예산 확인 → 적절한 애니메이션만 적용
```
