# Brainstorming Guide (Phase 0)

> spec Skill의 Phase 0: 모호한 아이디어를 구체적인 명세로 발전시키는 대화형 탐색 프로세스

## 개요

Phase 0 Brainstorming은 사용자의 러프한 아이디어를 구조화된 디자인 브리프로 변환합니다.

**핵심 원칙**:
- 한 번에 하나의 질문
- 객관식 선택지 제공
- 사용자 주도적 방향 결정
- YAGNI (You Aren't Gonna Need It) 준수

## 활성화 조건

### 자동 활성화 트리거

| 패턴 유형 | 예시 표현 |
|----------|----------|
| 모호한 표현 | "뭔가 만들고 싶어", "이런 거 되나?" |
| 아이디어 키워드 | "아이디어가 있는데", "생각해봤는데" |
| 탐색적 질문 | "어떻게 하면 좋을까?", "가능할까?" |
| 불확실성 표현 | "잘 모르겠는데", "대충 이런 느낌?" |

### 명시적 활성화

```javascript
// 명시적 brainstorming 요청
skill: spec({ brainstorm: true, idea: "커뮤니티 기능" });

// 또는 자연어로
"브레인스토밍부터 시작하고 싶어"
"아이디어 정리 좀 도와줘"
```

## 3단계 워크플로우

### Step 1: 아이디어 이해

**목표**: 핵심 의도와 컨텍스트 파악

**수행 작업**:
1. 프로젝트 현재 상태 파악
   - 기존 파일/문서 스캔
   - 최근 커밋 히스토리 확인
   - 관련 이슈/PR 검토

2. **단일 질문**으로 핵심 파악
   ```
   💡 한 가지만 여쭤볼게요:
   이 기능으로 사용자가 어떤 문제를 해결하게 되나요?
   ```

3. 집중 영역:
   - 목적 (Purpose): 왜 이 기능이 필요한가?
   - 제약사항 (Constraints): 어떤 제한이 있는가?
   - 성공 기준 (Success Criteria): 어떻게 성공을 측정하는가?

**질문 기법**:

| 질문 유형 | 예시 | 용도 |
|----------|------|------|
| Why 질문 | "왜 이 기능이 필요하다고 느끼셨나요?" | 근본 동기 파악 |
| Who 질문 | "주로 어떤 사용자가 쓰게 될까요?" | 타겟 사용자 정의 |
| What-if 질문 | "이 기능이 없으면 어떻게 되나요?" | 필수성 검증 |
| Scale 질문 | "얼마나 자주 사용될 것 같나요?" | 우선순위 판단 |

### Step 2: 접근 방식 탐색

**목표**: 구현 방향에 대한 합의 도출

**수행 작업**:
1. 2-3가지 옵션을 **객관식**으로 제시
2. 각 옵션의 트레이드오프 설명
3. 추천 방안과 그 이유 제시

**출력 형식**:

```markdown
🔍 접근 방식 옵션

**A) 최소 구현 (MVP)**
- 장점: 빠른 검증, 낮은 리스크
- 단점: 기능 제한
- 소요: 1-2일
- 추천 상황: 아이디어 검증 필요 시

**B) 표준 구현**
- 장점: 균형잡힌 기능성
- 단점: 중간 복잡도
- 소요: 3-5일
- 추천 상황: 명확한 요구사항 존재 시

**C) 확장 구현**
- 장점: 완전한 기능 세트
- 단점: 높은 복잡도, 긴 개발 시간
- 소요: 1-2주
- 추천 상황: 장기 로드맵 확정 시

💡 추천: **B) 표준 구현**
이유: 현재 요구사항 기준 MVP는 부족하고, 확장 구현은 YAGNI 위반 가능성

어떤 방향으로 진행할까요? (A/B/C)
```

**옵션 설계 원칙**:
- 항상 MVP 옵션 포함
- 과도한 엔지니어링 옵션 경고 표시
- 각 옵션의 롤백 가능성 명시

### Step 3: 디자인 합의

**목표**: 구조화된 디자인 브리프 작성

**수행 작업**:
1. 선택된 방향으로 디자인 브리프 작성
2. 섹션별 200-300단어로 구조화
3. 각 섹션 검증 후 다음 진행

**디자인 브리프 템플릿**:

```markdown
# Design Brief: {기능명}

## 1. 문제 정의 (Problem Statement)
- 현재 상황: {현재 사용자 경험}
- 문제점: {해결해야 할 핵심 문제}
- 영향: {문제로 인한 비즈니스/사용자 영향}

## 2. 목표 (Goals)
- Primary: {핵심 목표}
- Secondary: {부가 목표}
- Non-goals: {명시적으로 범위 외인 것}

## 3. 사용자 시나리오 (User Scenarios)
### 시나리오 1: {시나리오 제목}
1. 사용자가 {action}
2. 시스템이 {response}
3. 결과로 {outcome}

## 4. 제약사항 (Constraints)
- 기술적 제약: {기존 스택, 성능 요구}
- 비즈니스 제약: {일정, 리소스}
- 사용자 제약: {접근성, 호환성}

## 5. 성공 지표 (Success Metrics)
- [ ] {측정 가능한 지표 1}
- [ ] {측정 가능한 지표 2}

## 6. 다음 단계 (Next Steps)
→ Phase 1: Specification으로 진행
```

**섹션별 검증 질문**:

| 섹션 | 검증 질문 |
|------|----------|
| 문제 정의 | "이 문제 설명이 정확한가요?" |
| 목표 | "Non-goals에 추가할 것이 있나요?" |
| 시나리오 | "이 흐름이 자연스러운가요?" |
| 제약사항 | "빠진 제약이 있나요?" |
| 성공 지표 | "이 지표로 성공을 판단할 수 있나요?" |

## 질문 기법

### 효과적인 질문 패턴

**1. 단일 질문 원칙**
```
❌ 잘못된 예:
"사용자가 누구이고, 어떤 기능이 필요하고, 언제까지 완성해야 하나요?"

✅ 올바른 예:
"먼저, 이 기능의 주요 사용자는 누구인가요?"
(답변 후)
"그 사용자에게 가장 중요한 기능은 무엇일까요?"
```

**2. 객관식 선택지**
```
❌ 잘못된 예:
"어떤 방식으로 구현하면 좋을까요?"

✅ 올바른 예:
"구현 방식 중 어떤 것이 좋을까요?
A) REST API - 단순하고 표준적
B) GraphQL - 유연한 쿼리
C) tRPC - 타입 안전성 최대화"
```

**3. 확인 질문**
```
"정리하면, {요약}이 맞나요?"
"제가 이해한 것이 맞는지 확인해주세요: {이해한 내용}"
```

### 피해야 할 질문 패턴

| 피해야 할 것 | 이유 | 대안 |
|-------------|------|------|
| 복합 질문 | 답변 부담 | 분리하여 순차 질문 |
| 유도 질문 | 편향된 답변 | 중립적 표현 사용 |
| 전문 용어 | 소통 장벽 | 일상 언어로 설명 |
| 가정 포함 질문 | 잘못된 전제 | 가정 먼저 확인 |

## 출력 형식

### Brainstorming 세션 시작

```
[SEMO] Skill: spec 호출 - Brainstorming 모드

🧠 Phase 0: Brainstorming

아이디어를 구체화하겠습니다.
한 번에 하나의 질문으로 진행합니다.

---

💡 첫 번째 질문:
{단일 질문}
```

### 진행 중 출력

```
✅ 이해했습니다: {요약}

💡 다음 질문:
{단일 질문}
```

### 완료 출력

```
🎯 Brainstorming 완료

## Design Brief 생성됨
- 파일: docs/design-briefs/{feature-name}.md

## 다음 단계
Phase 1 (Specification)으로 진행하려면:
"spec 계속해줘" 또는 "명세 작성해줘"

## 기술적 불확실성 발견 시
spike Skill 호출 추천:
"spike {기술 주제}"
```

## spike Skill 연계

### 기술적 불확실성 감지 시

Brainstorming 중 기술적 불확실성이 발견되면 spike Skill로 전환을 제안합니다.

**감지 패턴**:
- "이게 가능한지 모르겠어"
- "성능이 괜찮을지..."
- "어떤 라이브러리가 좋을지"
- 구현 방식 간 명확한 선택 기준 부재

**전환 제안**:

```
⚠️ 기술적 불확실성 감지

다음 사항에 대해 spike가 필요해 보입니다:
- {불확실한 기술 주제}

spike 진행 후 brainstorming을 계속하시겠습니까?
A) spike 먼저 진행 → spike Skill 호출
B) 현재 정보로 계속 → 리스크 인지 후 진행
```

## 예시 세션

### 예시: 커뮤니티 기능 아이디어

```
사용자: "커뮤니티 기능 같은 거 추가하면 좋을 것 같은데..."

[SEMO] Skill: spec 호출 - Brainstorming 모드

🧠 Phase 0: Brainstorming

아이디어를 구체화하겠습니다.

---

💡 첫 번째 질문:
"커뮤니티 기능"으로 사용자들이 어떤 활동을 하길 기대하시나요?

사용자: "글 쓰고 댓글 달고 그런 거?"

✅ 이해했습니다: 게시글 작성과 댓글 기능이 핵심

💡 다음 질문:
어떤 유형의 커뮤니티가 더 맞을까요?

A) 자유 게시판 - 누구나 자유롭게 글 작성
B) Q&A 포럼 - 질문과 답변 중심
C) 토론 스레드 - 주제별 깊은 토론

사용자: "B가 좋을 것 같아"

✅ Q&A 포럼 방식으로 진행합니다.

💡 확인 질문:
정리하면:
- 형태: Q&A 포럼
- 핵심 기능: 질문 작성, 답변 달기
- 목적: 사용자 간 지식 공유

이 방향이 맞나요?

사용자: "응 맞아"

🎯 Design Brief 작성 중...

(design-brief.md 생성)

Brainstorming 완료! Phase 1으로 진행하시겠습니까?
```

## Related Skills

- `spec` (Phase 1-3) - Brainstorming 이후 명세 작성
- `spike` - 기술적 불확실성 탐색
- `implement` - Phase 4 구현

## References

- [spec Skill](../SKILL.md) - Phase 0-3 전체 워크플로우
- [Phase Details](phase-details.md) - Phase 1-7 상세
- [spike Skill](../../spike/SKILL.md) - 기술 탐색 워크플로우
