# Brainstorming Guide

> ideate Skill Phase 1: 모호한 아이디어를 구체적인 Design Brief로 발전

## 핵심 원칙

- **한 번에 하나의 질문**
- **객관식 선택지 제공**
- **사용자 주도적 방향 결정**
- **YAGNI** (You Aren't Gonna Need It) 준수

## 질문 기법

### 효과적인 질문 패턴

**1. 단일 질문 원칙**

```markdown
❌ 잘못된 예:
"사용자가 누구이고, 어떤 기능이 필요하고, 언제까지 완성해야 하나요?"

✅ 올바른 예:
"먼저, 이 기능의 주요 사용자는 누구인가요?"
(답변 후)
"그 사용자에게 가장 중요한 기능은 무엇일까요?"
```

**2. 객관식 선택지**

```markdown
❌ 잘못된 예:
"어떤 방식으로 구현하면 좋을까요?"

✅ 올바른 예:
"구현 방식 중 어떤 것이 좋을까요?
A) REST API - 단순하고 표준적
B) GraphQL - 유연한 쿼리
C) tRPC - 타입 안전성 최대화"
```

**3. 확인 질문**

```markdown
"정리하면, {요약}이 맞나요?"
"제가 이해한 것이 맞는지 확인해주세요: {이해한 내용}"
```

### 질문 유형별 용도

| 질문 유형 | 예시 | 용도 |
|----------|------|------|
| Why 질문 | "왜 이 기능이 필요하다고 느끼셨나요?" | 근본 동기 파악 |
| Who 질문 | "주로 어떤 사용자가 쓰게 될까요?" | 타겟 사용자 정의 |
| What-if 질문 | "이 기능이 없으면 어떻게 되나요?" | 필수성 검증 |
| Scale 질문 | "얼마나 자주 사용될 것 같나요?" | 우선순위 판단 |

### 피해야 할 질문 패턴

| 피해야 할 것 | 이유 | 대안 |
|-------------|------|------|
| 복합 질문 | 답변 부담 | 분리하여 순차 질문 |
| 유도 질문 | 편향된 답변 | 중립적 표현 사용 |
| 전문 용어 | 소통 장벽 | 일상 언어로 설명 |
| 가정 포함 질문 | 잘못된 전제 | 가정 먼저 확인 |

## 옵션 설계 원칙

### MVP 옵션 필수 포함

```markdown
**A) 최소 구현 (MVP)**
- 핵심 기능만 포함
- 검증 목적
- 롤백 용이
```

### 과도한 엔지니어링 경고

```markdown
**C) 확장 구현** ⚠️
- 완전한 기능 세트
- ⚠️ YAGNI 위반 가능성
- 장기 로드맵 확정 시에만 권장
```

### 롤백 가능성 명시

```markdown
각 옵션의 롤백 가능성:
- A) MVP: 완전 롤백 가능 (영향 최소)
- B) 표준: 부분 롤백 가능
- C) 확장: 롤백 비용 높음
```

## 예시 세션

```markdown
사용자: "커뮤니티 기능 같은 거 추가하면 좋을 것 같은데..."

[SEMO] Skill: ideate 호출 - 커뮤니티 기능

🧠 Phase 1: Brainstorming

💡 첫 번째 질문:
"커뮤니티 기능"으로 사용자들이 어떤 활동을 하길 기대하시나요?

사용자: "글 쓰고 댓글 달고 그런 거?"

✅ 이해했습니다: 게시글 작성과 댓글 기능이 핵심

💡 다음 질문:
어떤 유형의 커뮤니티가 더 맞을까요?

A) 자유 게시판 - 누구나 자유롭게 글 작성
B) Q&A 포럼 - 질문과 답변 중심
C) 토론 스레드 - 주제별 깊은 토론

사용자: "B가 좋을 것 같아"

✅ Q&A 포럼 방식으로 진행합니다.

💡 확인 질문:
정리하면:
- 형태: Q&A 포럼
- 핵심 기능: 질문 작성, 답변 달기
- 목적: 사용자 간 지식 공유

이 방향이 맞나요?
```
