# Design Brief Template

> ideate Skill의 최종 산출물

## 템플릿

```markdown
# Design Brief: {기능명}

**생성일**: {date}
**작성자**: {author}
**상태**: Draft | Review | Approved

---

## 1. 문제 정의 (Problem Statement)

### 현재 상황
{현재 사용자가 겪고 있는 경험 또는 상황}

### 문제점
{해결해야 할 핵심 문제}

### 영향
{이 문제로 인한 비즈니스/사용자 영향}

---

## 2. 목표 (Goals)

### Primary Goal
{이 기능의 핵심 목표 - 반드시 달성해야 할 것}

### Secondary Goals
- {부가 목표 1}
- {부가 목표 2}

### Non-goals (명시적 범위 외)
- {이번 범위에서 의도적으로 제외하는 것 1}
- {제외 사항 2}

---

## 3. 사용자 시나리오 (User Scenarios)

### 시나리오 1: {시나리오 제목}

| Step | 사용자 액션 | 시스템 응답 |
|------|------------|------------|
| 1 | {action} | {response} |
| 2 | {action} | {response} |
| 3 | {action} | {response} |

**결과**: {최종 outcome}

### 시나리오 2: {시나리오 제목}
...

---

## 4. 제약사항 (Constraints)

### 기술적 제약
- 기존 스택: {사용 중인 기술 스택}
- 성능 요구: {응답 시간, 처리량 등}
- 호환성: {지원 브라우저, 디바이스}

### 비즈니스 제약
- 일정: {데드라인 또는 마일스톤}
- 리소스: {가용 인력, 예산}

### 사용자 제약
- 접근성: {A11y 요구사항}
- 호환성: {최소 지원 환경}

---

## 5. 개발자 체크리스트 (Dev Checklist)

### 데이터 흐름
- **충돌 해결**: {정책}
- **동기화**: {전략}
- **삭제 정책**: {방식}

### 시간/계산
- **집계 기준**: {일/주/월}
- **타임존**: {정책}

### 플랫폼
- **타겟**: {PWA/웹/네이티브}
- **제약 대안**: {제약사항별 대안}

### 엣지 케이스
- **빈 상태**: {처리 방법}
- **대량 데이터**: {처리 방법}
- **동시 접속**: {처리 방법}

---

## 6. 성공 지표 (Success Metrics)

- [ ] {측정 가능한 지표 1} - 목표: {수치}
- [ ] {측정 가능한 지표 2} - 목표: {수치}
- [ ] {측정 가능한 지표 3} - 목표: {수치}

---

## 7. 다음 단계 (Next Steps)

1. **Epic 생성**: #{epic_number}
2. **Specification**: `/speckit.specify`
3. **Plan**: `/speckit.plan`
```

## 예시

```markdown
# Design Brief: Q&A 포럼

**생성일**: 2025-01-20
**작성자**: @reus
**상태**: Approved

---

## 1. 문제 정의

### 현재 상황
사용자들이 서비스 이용 중 궁금한 점이 생기면 1:1 문의를 통해 질문함.
동일한 질문이 반복되어 CS 부담 증가.

### 문제점
- 같은 질문에 대한 반복 답변
- 사용자 간 지식 공유 불가
- 커뮤니티 형성 어려움

### 영향
- CS 팀 업무량 30% 증가
- 사용자 이탈률 상승 (답변 대기 시간)

---

## 2. 목표

### Primary Goal
사용자가 질문을 올리고 다른 사용자 또는 운영자가 답변하는 Q&A 포럼 구축

### Secondary Goals
- 인기 질문 노출로 자주 묻는 질문 자동 해결
- 답변 채택 시스템으로 품질 높은 답변 우선 노출

### Non-goals
- 실시간 채팅 기능
- 1:1 DM 기능
- 파일 첨부 (v1에서 제외)

---

## 5. 개발자 체크리스트

### 데이터 흐름
- **충돌 해결**: 동시 답변 시 모두 저장 (시간순 정렬)
- **동기화**: 실시간 (WebSocket)
- **삭제 정책**: Soft delete (복구 가능)

### 시간/계산
- **집계 기준**: 주간 인기 질문 (조회수 기준)
- **타임존**: KST 고정

### 플랫폼
- **타겟**: PWA
- **제약 대안**: 푸시 알림 대신 이메일 알림

### 엣지 케이스
- **빈 상태**: "아직 질문이 없습니다" 안내 + 첫 질문 유도
- **대량 데이터**: 무한 스크롤 (20개씩)
- **동시 접속**: 낙관적 업데이트

---

## 6. 성공 지표

- [ ] 월간 질문 수 100건 이상
- [ ] 답변율 80% 이상
- [ ] CS 문의 20% 감소
```
