# 개발자 관점 체크리스트

> Design Brief 완성 후 개발자가 구현 시 할 질문들을 사전 검증

## 사용 시점

Design Brief 작성 완료 → Epic 생성 **전** 자동 검증

## 검증 카테고리

### 1. 데이터 흐름

| 질문 | 확인 사항 | Design Brief에 명시할 내용 |
|------|----------|---------------------------|
| 데이터 충돌 시 처리? | 동일 데이터 동시 수정 가능? | 충돌 해결 정책 (최신 우선/병합/경고) |
| 멀티 플랫폼 동기화? | 모바일/PC 동시 사용? | 동기화 전략 (실시간/폴링/수동) |
| 오프라인 지원? | 네트워크 없이 동작 필요? | 오프라인 큐잉 정책 |
| 삭제 시 연관 데이터? | Cascade 삭제? Soft 삭제? | 삭제 정책 명시 |

### 2. 시간/계산 로직

| 질문 | 확인 사항 | Design Brief에 명시할 내용 |
|------|----------|---------------------------|
| 집계 주기? | 일별/주별/월별 집계? | 집계 기준 (일/주/월/연) |
| 날짜 기준? | 생성일? 수정일? 특정 날짜? | 기준 날짜 필드 명시 |
| 일할 계산? | 월 → 일 환산 필요? | 일할 계산 공식 |
| 타임존? | 사용자별? 서버 기준? | 타임존 처리 정책 (KST 고정 등) |

### 3. 플랫폼 제약

#### PWA 제약

| 기능 | 제약사항 | 대안 |
|------|---------|------|
| 카메라 커스텀 UI | 불가 (브라우저 기본만) | 촬영 후 크롭 UI |
| 푸시 알림 | iOS Safari 제한적 | 이메일/SMS 병행 |
| 파일 시스템 | 제한적 | File API 활용 |
| 백그라운드 동기화 | 제한적 | 앱 활성화 시 동기화 |

#### 웹 제약

| 기능 | 제약사항 | 대안 |
|------|---------|------|
| 로컬 파일 접근 | 사용자 선택 필요 | 드래그앤드롭 UI |
| 클립보드 | HTTPS 필수 | 수동 복사 안내 |

### 4. 도메인 지식

| 도메인 | 확인 필요 개념 |
|--------|---------------|
| 회계/재무 | 일할 계산, 발생주의/현금주의, 결산 |
| 이커머스 | 재고 관리, 주문 상태 머신, 환불 정책 |
| 예약 시스템 | 중복 예약 방지, 취소 정책, 노쇼 처리 |
| 콘텐츠 관리 | 버전 관리, 발행 워크플로우, 권한 |
| 사용자 인증 | 세션 관리, 토큰 갱신, 다중 디바이스 |

### 5. 엣지 케이스

- [ ] 빈 상태 (데이터 없음) 처리
- [ ] 대량 데이터 (1000건 이상) 처리
- [ ] 동시 접속/수정 처리
- [ ] 권한 없는 접근 처리
- [ ] 네트워크 오류 재시도 정책

## 자동 검증 프로세스

```text
Design Brief 완성
      ↓
각 카테고리별 키워드 스캔
      ↓
누락 항목 탐지
      ↓
사용자에게 추가 질문
      ↓
Design Brief 보완
      ↓
Epic 생성 진행
```

## 검증 출력 예시

### 모든 항목 충족

```markdown
✅ 개발자 체크리스트 검증 완료

| 카테고리 | 상태 | 내용 |
|----------|------|------|
| 데이터 흐름 | ✅ | 충돌 시 최신 우선 |
| 시간/계산 | ✅ | KST 기준 일별 집계 |
| 플랫폼 | ✅ | PWA (오프라인 미지원) |
| 도메인 | ✅ | Q&A 포럼 표준 |
| 엣지케이스 | ✅ | 빈 상태 UI 정의됨 |

→ Epic 생성 진행
```

### 누락 항목 존재

```markdown
⚠️ 개발자 체크리스트 미충족

다음 항목이 Design Brief에 누락되었습니다:

| 카테고리 | 누락 항목 | 필요한 정보 |
|----------|----------|------------|
| 데이터 흐름 | 동시 수정 | 같은 글을 여러 명이 수정하면? |
| 엣지케이스 | 대량 데이터 | 게시글 1000개 이상이면? |

💡 추가 질문:
같은 질문에 여러 사용자가 동시에 답변을 달면 어떻게 처리할까요?
A) 모두 저장 (시간순 정렬)
B) 먼저 제출한 답변만 저장
C) 경고 표시 후 사용자 선택
```
