---
name: process-feedback
description: |
  SEMO 피드백 이슈 분석 및 반영. Use when (1) "피드백 처리해줘", "이슈 반영해줘",
  (2) check-feedback 후 수정 요청, (3) SEMO 시스템/패키지 개선 요청.
tools: [Read, Write, Edit, Bash, Glob, Grep, Task, AskUserQuestion]
model: inherit
---

> **🔔 호출 시 메시지**: 이 Skill이 호출되면 반드시 `[SEMO] Skill: process-feedback 호출 - #{issue_number}` 시스템 메시지를 첫 줄에 출력하세요.

# process-feedback Skill

> SEMO 피드백 이슈 분석, 설계, 반영 및 배포 자동화

---

## 🔴 NON-NEGOTIABLE: 완료 조건

> **⚠️ 아래 체크리스트를 모두 완료해야 피드백 처리 완료로 간주합니다.**

| # | 단계 | 완료 확인 |
|---|------|----------|
| 1 | 피드백 분석 완료 | `[SEMO] 피드백 분석 완료` |
| 2 | 수정 대상 결정 | `[SEMO] 수정 대상: {packages}` |
| 3 | 구현/수정 완료 | `[SEMO] 수정 완료` |
| 4 | 버저닝 완료 | `[SEMO] Versioning: 완료` |
| 5 | 커밋 & 푸시 | `git push` 성공 |
| 6 | **Slack 알림** | `[SEMO] Slack 알림 전송 완료` |
| 7 | **이슈 종료** | `Closes #{issue_number}` |
| 8 | (meta만) 로컬 동기화 | `.claude/` 최신화 |

---

## Purpose

SEMO 시스템/패키지에 대한 피드백 이슈를 분석하고, 적절한 수정을 설계 및 반영합니다.

- 피드백 수용 여부 분석
- 전체 패키지 구조를 고려한 재설계
- 적절한 수정 대상 평가 (semo-hooks, semo-cli, semo-mcp 등)
- 버저닝, 배포, Slack 알림까지 자동화

---

## 🔴 Phase 1: 피드백 분석

### 1.1 이슈 상세 조회

```bash
gh issue view {issue_number} --repo semicolon-devteam/semo --json title,body,labels,author
```

### 1.2 피드백 유형 분류

| 유형 | 라벨 | 처리 방식 |
|------|------|----------|
| 버그 | `bug` | 즉시 수정, PATCH 버전 |
| 기능 요청 | `enhancement` | 설계 검토 후 수정, MINOR 버전 |
| 문서 | `documentation` | 문서만 수정, PATCH 버전 |
| 질문 | `question` | 답변 후 이슈 종료 |

### 1.3 수용 가능성 분석

```text
[분석 기준]
1. 기존 아키텍처와 호환 가능한가?
2. 다른 패키지에 영향을 주는가?
3. Breaking Change가 발생하는가?
4. 보안 이슈가 있는가?
```

**수용 불가 시 대응**:
```markdown
[SEMO] Skill: process-feedback

❌ 피드백 수용 불가
- **사유**: {rejection_reason}
- **대안**: {alternative_suggestion}

→ 이슈에 코멘트 후 종료
```

---

## 🔴 Phase 2: 수정 대상 평가

### 2.1 SEMO 패키지 구조 이해

```text
semo/
├── semo-system/
│   ├── semo-core/          # 원칙, 오케스트레이터
│   ├── semo-skills/        # 통합 스킬
│   ├── semo-hooks/         # Claude Code Hooks (로깅)
│   └── meta/               # Meta 패키지 (SEMO 자체 개발)
├── packages/
│   ├── cli/                # semo CLI 도구
│   └── mcp-server/         # MCP 서버 (Slack, GitHub, Supabase)
└── .claude/                # 심볼릭 링크 (semo-system 참조)
```

### 2.2 수정 대상 결정 기준

| 피드백 내용 | 수정 대상 | 버저닝 |
|------------|----------|--------|
| 스킬 동작 변경 | semo-skills | MINOR |
| 오케스트레이터 라우팅 | semo-core | MINOR |
| Hook 동작 변경 | semo-hooks | MINOR/PATCH |
| CLI 명령어 변경 | packages/cli | MINOR |
| MCP 도구 변경 | packages/mcp-server | MINOR |
| 문서/오타 수정 | 해당 패키지 | PATCH |

### 2.3 영향 범위 분석

```bash
# 수정 대상 파일에서 참조하는 다른 파일 확인
grep -r "{keyword}" --include="*.md" semo-system/
```

---

## 🔴 Phase 3: 설계 및 구현

### 3.1 재설계 필요 여부 판단

```text
[재설계 기준]
- 기존 구조와 충돌하는 요청
- 여러 패키지에 걸친 변경
- 새로운 스킬/에이전트 추가 필요
- 워크플로우 변경 필요
```

### 3.2 사용자 확인 (필요 시)

```markdown
피드백 반영 방식을 확인합니다:

**원본 요청**: {original_request}
**제안된 구현**: {proposed_implementation}

이대로 진행할까요?
```

### 3.3 구현

> **⚠️ 직접 수정하지 말고 `skill:implement` 또는 적절한 스킬 호출**

```text
[수정 유형별 스킬 라우팅]
- 스킬 수정 → skill:implement (meta 컨텍스트)
- CLI 수정 → skill:implement (cli 컨텍스트)
- 문서 수정 → 직접 Edit
```

---

## 🔴 Phase 4: 버저닝 및 배포

### 4.1 버저닝 (자동 체인)

> **📖 참조**: [version-manager Skill](../version-manager/SKILL.md)

```text
수정 완료
    ↓
[자동] skill:version-manager 호출
    ↓
VERSION 업데이트 + CHANGELOG 생성
    ↓
커밋 & 푸시
    ↓
[자동] skill:notify-slack 호출 (릴리스 알림)
```

### 4.2 npm 배포 (해당 시)

> **📖 참조**: [deploy-npm Skill](../deploy-npm/SKILL.md)

| 패키지 | npm 배포 필요 |
|--------|--------------|
| semo-hooks | ✅ |
| packages/cli | ✅ |
| packages/mcp-server | ✅ |
| semo-skills | ❌ (문서만) |
| semo-core | ❌ (문서만) |

---

## 🔴 Phase 5: 로컬 동기화 (Meta 환경)

> **meta 패키지 수정 시 필수**

```bash
# .claude/ 심볼릭 링크가 최신 상태인지 확인
cd .claude && git pull origin main
```

### 완료 확인

```markdown
[SEMO] Skill: process-feedback → 로컬 동기화 완료

✅ .claude/semo-system/ 최신화됨
```

---

## 🔴 Phase 6: 이슈 종료 및 알림

### 6.1 이슈 종료

```bash
# 커밋 메시지에 포함
git commit -m "fix(skills): {변경 요약}

Closes #{issue_number}"
```

### 6.2 피드백 작성자 알림

> **📖 참조**: [check-feedback Skill](../check-feedback/SKILL.md#피드백-수정-완료-후-슬랙-알림)

```text
1. 이슈 작성자 GitHub ID 조회
2. team-members.md에서 Slack Name 조회
3. Slack API로 User ID 조회
4. #_협업에 멘션 포함 알림 전송
```

---

## 출력 형식

### 분석 완료

```markdown
[SEMO] Skill: process-feedback 호출 - #86

## 📋 피드백 분석

**이슈**: #86 [Feature] 테스트 요청 시 기본 테스터 멘션
**유형**: enhancement
**작성자**: reus-jeon

### 분석 결과
- **수용 여부**: ✅ 수용
- **수정 대상**: tester, request-test, notify-slack 스킬
- **버전 타입**: MINOR
- **영향 범위**: 테스트 요청 워크플로우

### 구현 계획
1. project-channels.md 생성 (프로젝트별 채널 매핑)
2. tester 스킬에 프로젝트 채널 연동 추가
3. team-members.md 참조하여 테스터 멘션 추가
```

### 처리 완료

```markdown
[SEMO] Skill: process-feedback 완료 - #86

## ✅ 피드백 처리 완료

**이슈**: #86
**수정 패키지**: semo-skills, semo-core
**버전**: 3.0.29

### 변경 내역
- project-channels.md 신규 생성
- tester, notify-slack 스킬 업데이트

### 배포
- [x] 커밋 & 푸시 완료
- [x] Slack 알림 전송
- [x] 이슈 자동 종료

**문의자 알림**: @Reus → #_협업
```

---

## 스킬 체이닝

### 이전 스킬 (호출자)

| 스킬 | 트리거 |
|------|--------|
| `check-feedback` | 이슈 목록 확인 후 "처리해줘" |

### 다음 스킬 (자동 호출)

| 스킬 | 트리거 |
|------|--------|
| `implement` | 코드/문서 수정 |
| `version-manager` | 버저닝 |
| `notify-slack` | Slack 알림 |
| `deploy-npm` | npm 배포 (해당 시) |

---

## References

- [check-feedback Skill](../check-feedback/SKILL.md) - 피드백 확인
- [version-manager Skill](../version-manager/SKILL.md) - 버저닝
- [deploy-npm Skill](../deploy-npm/SKILL.md) - npm 배포
- [team-members.md](../../semo-core/_shared/team-members.md) - GitHub ↔ Slack 매핑
- [project-channels.md](../../semo-core/_shared/project-channels.md) - 프로젝트별 채널
