---
name: project-board
description: GitHub Project 보드 이슈 연동 및 상태 관리. Use when (1) 이슈 생성 후 프로젝트 보드 연동, (2) 태스크 완료 후 상태 변경.
tools: [Bash, GitHub CLI]
---

> **🔔 시스템 메시지**: 이 Skill이 호출되면 `[SEMO] Skill: project-board 호출 - {action}` 시스템 메시지를 첫 줄에 출력하세요.

# Project Board Skill

> GitHub Project 보드에 이슈 추가 및 상태 관리 자동화

## 🔴 이슈관리 프로젝트 설정 (하드코딩)

> **⚠️ 이슈관리 프로젝트 설정은 SEMO에 하드코딩되어 있습니다.**

📖 **공통 설정 참조**: [github-projects.md](../../../core/_shared/github-projects.md)

| 항목 | 값 |
|------|-----|
| **Project ID** | `PVT_kwDOC01-Rc4AtDz2` |
| **Status Field ID** | `PVTSSF_lADOC01-Rc4AtDz2zgj4dzs` |
| **Organization** | semicolon-devteam |
| **Project Number** | 1 |

### Status Option IDs

| Status | Option ID |
|--------|-----------|
| 작업중 | `47fc9ee4` |
| 리뷰요청 | `9b58620e` |
| 테스트중 | `13a75176` |
| 병합됨 | `98236657` |

---

## Purpose

이슈의 GitHub Projects 상태를 관리합니다:

1. **자동 추가**: 이슈가 프로젝트에 없으면 기본 프로젝트에 자동 추가
2. **상태 변경**: Projects 보드의 **Status 필드** 변경 (Labels 아님!)
3. **날짜 속성 자동 설정**: 상태 변경 시 관련 날짜 속성 자동 설정

## 날짜 속성 자동화 규칙

| 상태 변경 | 설정 속성 | 값 |
|----------|----------|-----|
| → **작업중** | `시작일` | 오늘 날짜 |
| → **리뷰요청** | `종료일` | 오늘 날짜 |
| → **테스트중** | `Assignee 추가` | @kokkh (QA) |

> **🔴 CRITICAL**: 상태 변경 시 **Labels가 아닌 Projects Status 필드**를 변경해야 합니다.

## Core Functions

1. 이슈를 프로젝트에 추가
2. 상태 변경 (GraphQL mutation)
3. 테스터 Assignee 추가 (테스트중 시)

## Output

```markdown
[SEMO] Skill: project-board 완료

📋 **이슈**: {repo}#{issue_number}
📊 **프로젝트**: 이슈관리 (#1)
🔄 **상태 변경**: {이전} → **{새 상태}**

✅ Projects 보드 상태 변경 완료
```

## References

- [API Calls](references/api-calls.md)
- [Status Rules](references/status-rules.md)
