---
name: qa-test
description: |
  QA 테스트 관리 스킬. Use when (1) 할당된 테스트 목록 확인,
  (2) 테스트 결과 업데이트, (3) 테스트 완료 보고.
tools: [Read, Bash, Glob, mcp__semo-integrations__slack_lookup_user, mcp__semo-integrations__slack_send_message]
model: inherit
---

> **시스템 메시지**: 이 Skill이 호출되면 `[SEMO] Skill: qa-test 호출` 시스템 메시지를 첫 줄에 출력하세요.

# qa-test Skill

> QA 담당자의 테스트 업무 관리 스킬 (독립 스킬)

## Purpose

QA 담당자가 본인에게 할당된 테스트 업무를 확인하고 결과를 업데이트합니다.

- 할당된 테스트 목록 조회
- 테스트 결과 업데이트 (체크박스, 라벨, 코멘트)
- 테스트 완료 알림

---

## 기능 1: 테스트 목록 조회

### 트리거

- "내 테스트 목록"
- "할당된 테스트"
- "테스트 뭐있어"

### 실행 흐름

```text
1. gh CLI로 본인 Assignee 이슈 검색
2. testing/qa 라벨 필터링
3. 목록 출력
```

### gh CLI 명령

```bash
# 본인에게 할당된 testing 라벨 이슈 조회
gh issue list --assignee @me --label testing --state open --json number,title,repository,createdAt
```

### 출력 형식

```markdown
[SEMO] Skill: qa-test → 테스트 목록

📋 **할당된 테스트** (3건)

| # | 이슈 | 프로젝트 | 요청일 |
|---|------|----------|--------|
| 1 | #123 - 로그인 기능 테스트 | half-time | 2024-01-15 |
| 2 | #456 - 결제 플로우 검증 | cm-land | 2024-01-14 |
| 3 | #789 - API 응답 확인 | cm-office | 2024-01-13 |

💡 "123 테스트 완료" 또는 "#123 테스트 결과 업데이트"
```

---

## 기능 2: 테스트 결과 업데이트

### 트리거

- "#123 테스트 완료"
- "123 테스트 결과 업데이트"
- "테스트 완료 처리해줘"

### 필수 입력

| 입력 | 설명 | 필수 |
|------|------|------|
| 이슈 번호 | GitHub 이슈 번호 | ✅ |
| 테스트 결과 | pass / fail | ✅ |
| 코멘트 | 추가 설명 | ❌ |

### 실행 흐름

```text
1. 이슈 조회 (gh issue view)
2. 체크박스 업데이트 (이슈 본문)
3. 테스트 결과 코멘트 추가
4. 라벨 변경 (testing → tested)
5. Slack 알림 (선택)
```

### gh CLI 명령

```bash
# 1. 이슈 조회
gh issue view {number} -R {owner}/{repo} --json body,title,labels,assignees

# 2. 체크박스 업데이트 (본문에서 - [ ] → - [x] 변환)
gh issue edit {number} -R {owner}/{repo} --body "{updated_body}"

# 3. 코멘트 추가
gh issue comment {number} -R {owner}/{repo} --body "## 🧪 테스트 결과

✅ **Pass**

테스트 완료: @{qa_user}
테스트 일시: {datetime}"

# 4. 라벨 변경
gh issue edit {number} -R {owner}/{repo} --remove-label testing --add-label tested
```

### 출력 형식

```markdown
[SEMO] Skill: qa-test → 테스트 결과 업데이트 완료

✅ **테스트 완료**: #123 - 로그인 기능 테스트

📋 **결과**: Pass
💬 **코멘트**: 추가됨
🏷️ **라벨**: testing → tested
📢 **알림**: @Reus에게 Slack 전송됨
```

---

## Slack 알림 (선택)

테스트 완료 시 요청자에게 Slack 알림을 발송할 수 있습니다.

### 알림 형식

```text
🧪 *테스트 완료*

<@{SLACK_ID}> 님, 테스트가 완료되었습니다.

📋 *이슈*: {이슈 제목}
🔗 *링크*: {이슈 URL}
✅ *결과*: Pass
👤 *테스터*: {QA 이름}
```

---

## 프로젝트 지정

여러 프로젝트에서 테스트를 관리하는 경우, 프로젝트를 명시할 수 있습니다.

```bash
# 특정 레포지토리의 이슈만 조회
gh issue list -R semicolon-devteam/half-time --assignee @me --label testing --state open
```

---

## QA 담당자 정보

> 팀원 정보는 [team-members.md](../../semo-core/_shared/team-members.md) 참조

| 역할 | GitHub ID | Slack Display Name |
|------|-----------|-------------------|
| QA | kokkh | Goni |

---

## Related Skills

| Skill | 역할 | 연결 |
|-------|------|------|
| `request-test` | 테스트 요청 전송 | 개발자 → QA |
| `change-to-testing` | 상태 변경 + QA 할당 | 개발자 → QA |

---

## References

- [Team Members](../../semo-core/_shared/team-members.md) - GitHub/Slack ID 매핑
- [request-test Skill](../request-test/SKILL.md) - 테스트 요청 스킬
