---
name: review-task
description: |
  GitHub 태스크 이슈카드 기반 구현 완료 리뷰. Use when:
  (1) PR 전 태스크카드 검토, (2) "리뷰해줘" 요청, (3) Acceptance Criteria 충족 확인,
  (4) Draft→일반 이슈 전환 확인, (5) 브랜치명 규칙 준수 확인.
tools: [Bash, Read, Grep, Glob, GitHub CLI]
triggers:
  - 리뷰해줘
  - 태스크 리뷰
  - 구현 리뷰해줘
  - PR 전 검토
  - 이슈카드 리뷰
---

> **시스템 메시지**: 이 Skill이 호출되면 `[SEMO] Skill: review-task 호출 - {repo}#{issue_number}` 시스템 메시지를 첫 줄에 출력하세요.

# Review Task Skill

@./../_shared/quality-gates.md

**Purpose**: GitHub 태스크 이슈카드를 기준으로 구현 완료 여부를 종합 리뷰

## Quick Start

### When to Use

- PR 생성 전 최종 점검
- 태스크카드 Acceptance Criteria 충족 확인
- Draft 이슈 → 일반 이슈 전환 확인
- 브랜치명/커밋 컨벤션 준수 확인

### What It Does

1. **이슈카드 분석**: GitHub 이슈에서 AC, 테스트 요구사항 추출
2. **메타데이터 검증**: Draft 상태, 라벨, 브랜치명 규칙
3. **테스트 구조 검증**: 개발자 테스트 / QA 테스트 분리 확인
4. **아키텍처 검증**: DDD 레이어, 팀 컨벤션 준수
5. **기능 구현 확인**: AC 항목별 코드 매칭
6. **PR 리뷰 작성**: 대상 PR에 리뷰 코멘트 자동 작성 (APPROVE/REQUEST_CHANGES)

## Usage

```bash
# 현재 브랜치 이슈 자동 감지
"리뷰해줘"

# 이슈 번호 지정
"cm-land#565 리뷰해줘"

# 이슈 URL로 리뷰
"https://github.com/semicolon-devteam/cm-land/issues/565 리뷰해줘"
```

## Review Phases

| Phase | 검증 항목 |
|-------|----------|
| **1. 메타데이터** | Draft 접두사/라벨 제거, 브랜치명 규칙 |
| **2. 테스트 구조** | 개발자 테스트 vs QA 테스트 분리 |
| **3. 아키텍처** | DDD 레이어, 팀 컨벤션 |
| **4. 기능 구현** | Acceptance Criteria 충족 |
| **5. 품질 게이트** | Lint, TypeScript, 테스트 통과 |
| **6. PR 리뷰 작성** | 대상 PR에 리뷰 코멘트 자동 작성 |
| **7. 프로젝트 보드** | PR 머지 후 이슈 상태 "테스트중"으로 변경 |

> 📚 **상세**: [references/review-phases.md](references/review-phases.md)

## 이슈 번호 자동 감지

```bash
# 현재 브랜치에서 이슈 번호 추출
ISSUE_NUM=$(git branch --show-current | grep -oE '^[0-9]+' | head -1)
```

## Severity Levels

### 🔴 Critical (PR 차단)

- Draft 상태 미전환
- Acceptance Criteria 미충족
- 테스트 실패
- 아키텍처 위반

### 🟡 Warning (수정 권장)

- 브랜치명 규칙 불일치
- 테스트 섹션 미분리
- 커버리지 미달

### 🟢 Info (참고)

- 추가 테스트 권장
- 문서 업데이트 필요

## Output Format

> 📚 **상세**: [references/output-format.md](references/output-format.md)

```markdown
[SEMO] Skill: review-task 호출 - {repo}#{issue_number}

=== 태스크 리뷰: {repo}#{issue_number} ===

## 이슈 정보
**제목**: {title}
**상태**: ✅ 일반 이슈 (Draft 전환 완료)

## 리뷰 결과

| Phase | 상태 | 요약 |
|-------|------|------|
| 메타데이터 | ✅ | Draft 제거됨, 브랜치명 규칙 준수 |
| 테스트 구조 | 🟡 | QA 테스트 섹션 분리 필요 |
| 아키텍처 | ✅ | DDD 레이어 준수 |
| 기능 구현 | ✅ | AC 5/5 충족 |
| 품질 게이트 | ✅ | Lint/TS/Test 통과 |

## 최종 결과: ✅ PR 가능 (경고 1건)
```

## PR 리뷰 코멘트 작성 (Phase 6)

리뷰 완료 후 대상 PR에 자동으로 리뷰 코멘트를 작성합니다.

### 트리거

- 리뷰 완료 후 사용자 확인: "PR에 리뷰 코멘트 작성할까요?"
- 명시적 요청: "리뷰하고 PR에 코멘트 남겨줘"

### 리뷰 타입

| 결과 | 리뷰 타입 | 조건 |
|------|----------|------|
| ✅ PR 가능 | `APPROVE` | Critical 0건 |
| 🟡 경고 있음 | `COMMENT` | Critical 0건, Warning 1건 이상 |
| 🔴 PR 차단 | `REQUEST_CHANGES` | Critical 1건 이상 |

### 명령어

```bash
# PR 찾기
gh pr list --head $(git branch --show-current) --json number,url

# 리뷰 작성
gh pr review {pr_number} --approve --body "리뷰 내용"
gh pr review {pr_number} --comment --body "리뷰 내용"
gh pr review {pr_number} --request-changes --body "리뷰 내용"
```

## Phase 7: 프로젝트 보드 상태 변경

PR 머지 완료 후 이슈 상태를 자동으로 "테스트중"으로 변경합니다.

### 트리거

- PR이 `APPROVE` 리뷰를 받고 머지된 후
- 사용자가 "머지하고 상태 변경해줘" 요청 시

### 프로세스

```markdown
[SEMO] Skill: review-task → 프로젝트 보드 상태 변경

📋 **이슈**: {repo}#{issue_number}
🔀 **PR**: #{pr_number} 머지 완료

🔄 상태 변경 중...
- 이전: 리뷰요청
- 이후: **테스트중**

✅ 완료: {repo}#{issue_number} → 테스트중

다음 단계: STG 환경에서 QA 테스트 진행
```

### 명령어

```bash
# skill: project-board 호출
skill: project-board({
  repo: "{repo}",
  issue_number: {issue_number},
  target_status: "테스트중"
})
```

> 📖 상세 API: [../project-board/references/api-commands.md](../project-board/references/api-commands.md)

## 🔴 리뷰 승인 시 다음 단계 제안 (NON-NEGOTIABLE)

> **⚠️ 리뷰 결과가 "✅ 승인" 또는 "✅ PR 가능"인 경우 반드시 다음 단계를 제안합니다.**

### 트리거

- 최종 판정: ✅ 승인 (Critical 0건)
- 최종 판정: ✅ PR 가능 (경고만 존재)

### 승인 시 출력 템플릿

```markdown
[SEMO] Skill: review-task 완료 - {repo}#{issue_number}

## 🎯 최종 판정: ✅ 승인

| 항목 | 결과 |
|------|------|
| 요구사항 충족 | {percentage}% |
| 코드 품질 | {quality} |
| 부작용 위험 | {risk_level} |

---

## 🔄 다음 단계

{if pr_exists}
📋 **PR이 존재합니다**: #{pr_number}

| 옵션 | 설명 | 실행 방법 |
|------|------|----------|
| **A. PR 머지** (권장) | 리뷰 통과, 머지 가능 | "머지해줘" |
| **B. 리뷰어 추가** | 추가 리뷰 필요 시 | "리뷰어 추가해줘" |
| **C. 추가 수정** | 보완 필요 시 | 수정 내용 설명 |
{else}
📋 **PR이 없습니다**

| 옵션 | 설명 | 실행 방법 |
|------|------|----------|
| **A. PR 생성** (권장) | 리뷰 통과, PR 생성 | "PR 생성해줘" |
| **B. 추가 수정** | 보완 필요 시 | 수정 내용 설명 |
{/if}

어떻게 진행할까요?
```

### PR 존재 여부 확인

```bash
# 현재 브랜치의 PR 확인
gh pr list --head $(git branch --show-current) --json number,url,state
```

### 머지 실행 시 프로세스

사용자가 "머지해줘" 요청 시:

```markdown
[SEMO] Skill: review-task → PR 머지 진행

📋 **이슈**: {repo}#{issue_number}
🔀 **PR**: #{pr_number}

1. ✅ PR 머지 실행
2. ✅ 이슈 상태 → "테스트중" 변경
3. ✅ QA 담당자 알림 (해당 시)

---

✅ **완료**

- PR #{pr_number} 머지됨
- {repo}#{issue_number} → 테스트중

**다음**: STG 환경에서 QA 테스트 진행
```

---

## Related Skills

- `verify-implementation` - 요구사항 구현 확인 (경량)
- `git-workflow` - PR 생성 자동화
- `check-team-codex` - 팀 컨벤션 검증
- `verify` - 종합 품질 검증
- `project-board` - 프로젝트 보드 연동

## References

- [Review Phases](references/review-phases.md) - 리뷰 단계별 상세
- [Output Format](references/output-format.md) - 출력 형식 상세
- [Project Board API](../project-board/references/api-commands.md) - 프로젝트 보드 API
